/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.util.Vector;
import javax.swing.JOptionPane;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;
import org.af.jhlir.call.RList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphMCP {
    private static final Log logger = LogFactory.getLog(GraphMCP.class);
    protected String name;
    public Vector<Edge> edges = new Vector();
    public Vector<Node> nodes = new Vector();
    NetList nl;
    String description;
    String corMatName;
    String test;
    double[] pvalues = null;
    double[] entangledWeights = null;

    public GraphMCP(String name, NetList nl) {
        this.name = name;
        this.nl = nl;
        this.loadGraph(name);
        nl.revalidate();
        nl.repaint();
    }

    public String getDescription() {
        return this.description;
    }

    protected void loadGraph(String name) {
        block19: {
            block18: {
                if (RControl.getR().eval("exists(\"" + name + "\")").asRLogical().getData()[0]) {
                    RList edgeL;
                    String[] nodeArray;
                    if (RControl.getR().eval("\"entangledMCP\" %in% class(" + name + ")").asRLogical().getData()[0]) {
                        nodeArray = RControl.getR().eval("getNodes(" + name + ")").asRChar().getData();
                        double[] x = RControl.getR().eval("getXCoordinates(" + name + ")").asRNumeric().getData();
                        double[] y = RControl.getR().eval("getYCoordinates(" + name + ")").asRNumeric().getData();
                        boolean[] rejected = RControl.getR().eval("getRejected(" + name + ")").asRLogical().getData();
                        this.entangledWeights = RControl.getR().eval(name + "@weights").asRNumeric().getData();
                        for (int i = 0; i < nodeArray.length; ++i) {
                            logger.debug((Object)("Adding node " + nodeArray[i] + " at (" + x[i] + "," + y[i] + ")."));
                            double[] alpha = RControl.getR().eval("getWeights(" + name + ")[," + (i + 1) + "]").asRNumeric().getData();
                            this.nodes.add(new Node(nodeArray[i], (int)x[i], (int)y[i], alpha, this.nl));
                            if (!rejected[i]) continue;
                            this.nodes.lastElement().rejected = true;
                        }
                        for (int layer = 0; layer < RControl.getR().eval("gMCP:::layers(" + name + ")").asRInteger().getData()[0]; ++layer) {
                            edgeL = RControl.getR().eval("gMCP:::getEdges(" + name + "@subgraphs[[" + (layer + 1) + "]])").asRList();
                            this.addEdges(edgeL, layer);
                            if (layer == 0) continue;
                            this.nl.control.addEntangledLayer();
                        }
                    } else {
                        nodeArray = RControl.getR().eval("getNodes(" + name + ")").asRChar().getData();
                        double[] alpha = RControl.getR().eval("getWeights(" + name + ")").asRNumeric().getData();
                        double[] x = RControl.getR().eval("getXCoordinates(" + name + ")").asRNumeric().getData();
                        double[] y = RControl.getR().eval("getYCoordinates(" + name + ")").asRNumeric().getData();
                        boolean[] rejected = RControl.getR().eval("getRejected(" + name + ")").asRLogical().getData();
                        for (int i = 0; i < nodeArray.length; ++i) {
                            logger.debug((Object)("Adding node " + nodeArray[i] + " at (" + x[i] + "," + y[i] + ")."));
                            this.nodes.add(new Node(nodeArray[i], (int)x[i], (int)y[i], new double[]{alpha[i]}, this.nl));
                            if (!rejected[i]) continue;
                            this.nodes.lastElement().rejected = true;
                        }
                        edgeL = RControl.getR().eval("gMCP:::getEdges(" + name + ")").asRList();
                        this.addEdges(edgeL, 0);
                    }
                }
                try {
                    this.description = RControl.getR().eval("attr(" + name + ", \"description\")").asRChar().getData()[0];
                }
                catch (Exception e) {
                    if (!(e instanceof NullPointerException)) {
                        System.out.println("No description for graph \"" + name + "\".");
                        e.printStackTrace();
                    }
                    this.description = "Enter a description for the graph.";
                }
                try {
                    this.pvalues = RControl.getR().eval("attr(" + name + ", \"pvalues\")").asRNumeric().getData();
                    int answer = JOptionPane.showConfirmDialog(this.nl.control.getGraphGUI(), "Graph object has pvalues attached.\n Should they be loaded?", "Load p-values", 0);
                    if (answer == 1) {
                        this.pvalues = null;
                    }
                }
                catch (Exception e) {
                    if (e instanceof NullPointerException) break block18;
                    e.printStackTrace();
                }
            }
            try {
                this.test = RControl.getR().eval("attr(" + name + ", \"test\")").asRChar().getData()[0];
                int answer = JOptionPane.showConfirmDialog(this.nl.control.getGraphGUI(), "Graph object has test information attached.\n Should they be loaded?", "Load test information", 0);
                if (answer == 1) {
                    this.test = null;
                } else {
                    this.corMatName = RControl.getR().eval("attr(" + name + ", \"corMatName\")").asRChar().getData()[0];
                    RControl.getR().eval("assign('" + this.corMatName + "', attr(" + name + ", \"corMat\"), envir=globalenv())").asRNumeric().getData();
                }
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) break block19;
                e.printStackTrace();
            }
        }
        for (Node k : this.nodes) {
            this.nl.addNode(k);
        }
        for (Edge e : this.edges) {
            this.nl.setEdge(e);
        }
    }

    private void addEdges(RList edgeL, int layer) {
        if (edgeL.get(0) != null) {
            String[] from = edgeL.get(0).asRChar().getData();
            String[] to = edgeL.get(1).asRChar().getData();
            double[] weight = edgeL.get(2).asRNumeric().getData();
            double[] labelX = edgeL.get(3).asRNumeric().getData();
            double[] labelY = edgeL.get(4).asRNumeric().getData();
            boolean[] curved = edgeL.get(5).asRLogical().getData();
            String[] weightStr = edgeL.get(6).asRChar().getData();
            for (int i = 0; i < from.length; ++i) {
                Node fromNode = this.getNode(from[i]);
                Node toNode = this.getNode(to[i]);
                int xl = (int)labelX[i];
                int yl = (int)labelY[i];
                boolean curve = curved[i];
                if (!Double.valueOf(weight[i]).toString().equals("NaN")) {
                    if (xl < -50 || yl < -50) {
                        this.edges.add(new Edge(fromNode, toNode, weight[i], this.nl, curve, layer));
                        continue;
                    }
                    this.edges.add(new Edge(fromNode, toNode, weight[i], this.nl, xl + Node.getRadius(), yl + Node.getRadius(), layer));
                    this.edges.lastElement().setFixed(true);
                    continue;
                }
                if (xl < -50 || yl < -50) {
                    this.edges.add(new Edge(fromNode, toNode, weightStr[i], this.nl, curve, layer));
                    continue;
                }
                this.edges.add(new Edge(fromNode, toNode, weightStr[i], this.nl, xl + Node.getRadius(), yl + Node.getRadius(), layer));
                this.edges.lastElement().setFixed(true);
            }
        }
    }

    private Node getNode(String name) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }
}

