/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.Tools;
import bartMachine.TreeArrayIllustration;
import bartMachine.TreeIllustration;
import bartMachine.bartMachineTreeNode;
import bartMachine.bartMachine_d_init;
import java.io.Serializable;

public abstract class bartMachine_e_gibbs_base
extends bartMachine_d_init
implements Serializable {
    @Override
    public void Build() {
        this.SetupGibbsSampling();
        this.DoGibbsSampling();
    }

    protected void DoGibbsSampling() {
        while (this.gibbs_sample_num <= this.num_gibbs_total_iterations) {
            this.DoOneGibbsSample();
            this.FlushDataForSample(this.gibbs_samples_of_bart_trees[this.gibbs_sample_num - 1]);
            this.DeleteBurnInsOnPreviousSamples();
            ++this.gibbs_sample_num;
        }
    }

    protected void DoOneGibbsSample() {
        bartMachineTreeNode[] bartMachineTreeNodeArray = new bartMachineTreeNode[this.num_trees];
        TreeArrayIllustration treeArrayIllustration = new TreeArrayIllustration(this.gibbs_sample_num, this.unique_name);
        double[] dArray = new double[this.n];
        for (int i = 0; i < this.num_trees; ++i) {
            if (this.verbose) {
                this.GibbsSampleDebugMessage(i);
            }
            dArray = this.SampleTree(this.gibbs_sample_num, i, bartMachineTreeNodeArray, treeArrayIllustration);
            this.SampleMusWrapper(this.gibbs_sample_num, i);
        }
        this.SampleSigsq(this.gibbs_sample_num, this.getResidualsFromFullSumModel(this.gibbs_sample_num, dArray));
        if (this.tree_illust) {
            this.illustrate(treeArrayIllustration);
        }
    }

    protected void GibbsSampleDebugMessage(int n) {
        if (n == 0 && this.gibbs_sample_num % 100 == 0) {
            String string = "Iteration " + this.gibbs_sample_num + "/" + this.num_gibbs_total_iterations;
            if (this.num_cores > 1) {
                string = string + "  thread: " + (this.threadNum + 1);
            }
            if (ON_WINDOWS) {
                long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                long l2 = Runtime.getRuntime().maxMemory();
                string = string + "  mem: " + TreeIllustration.one_digit_format.format((double)l / 1000000.0) + "/" + TreeIllustration.one_digit_format.format((double)l2 / 1000000.0) + "MB";
            }
            System.out.println(string);
        }
    }

    protected void SampleMusWrapper(int n, int n2) {
        bartMachineTreeNode bartMachineTreeNode2 = this.gibbs_samples_of_bart_trees[n - 1][n2];
        this.sum_resids_vec = Tools.subtract_arrays(this.sum_resids_vec, bartMachineTreeNode2.yhats);
        bartMachineTreeNode bartMachineTreeNode3 = this.gibbs_samples_of_bart_trees[n][n2];
        double d = this.gibbs_samples_of_sigsq[n - 1];
        this.assignLeafValsBySamplingFromPosteriorMeanAndSigsqAndUpdateYhats(bartMachineTreeNode3, d);
        this.sum_resids_vec = Tools.add_arrays(this.sum_resids_vec, bartMachineTreeNode3.yhats);
    }

    private void DeleteBurnInsOnPreviousSamples() {
        if (this.gibbs_sample_num <= this.num_gibbs_burn_in + 1 && this.gibbs_sample_num >= 2) {
            this.gibbs_samples_of_bart_trees[this.gibbs_sample_num - 2] = null;
        }
    }

    protected void SampleSigsq(int n, double[] dArray) {
        double d;
        this.gibbs_samples_of_sigsq[n] = d = this.drawSigsqFromPosterior(n, dArray);
    }

    protected double[] getResidualsFromFullSumModel(int n, double[] dArray) {
        bartMachineTreeNode bartMachineTreeNode2 = this.gibbs_samples_of_bart_trees[n][this.num_trees - 1];
        for (int i = 0; i < this.n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] - bartMachineTreeNode2.yhats[i];
        }
        return dArray;
    }

    protected double[] SampleTree(int n, int n2, bartMachineTreeNode[] bartMachineTreeNodeArray, TreeArrayIllustration treeArrayIllustration) {
        bartMachineTreeNode bartMachineTreeNode2;
        bartMachineTreeNode bartMachineTreeNode3 = this.gibbs_samples_of_bart_trees[n - 1][n2].clone();
        double[] dArray = Tools.add_arrays(Tools.subtract_arrays(this.y_trans, this.sum_resids_vec), bartMachineTreeNode3.yhats);
        bartMachineTreeNode3.updateWithNewResponsesRecursively(dArray);
        bartMachineTreeNodeArray[n2] = bartMachineTreeNode2 = this.metroHastingsPosteriorTreeSpaceIteration(bartMachineTreeNode3, n2, this.accept_reject_mh, this.accept_reject_mh_steps);
        this.gibbs_samples_of_bart_trees[n] = bartMachineTreeNodeArray;
        treeArrayIllustration.AddTree(bartMachineTreeNode2);
        return dArray;
    }

    protected abstract double drawSigsqFromPosterior(int var1, double[] var2);

    protected abstract bartMachineTreeNode metroHastingsPosteriorTreeSpaceIteration(bartMachineTreeNode var1, int var2, boolean[][] var3, char[][] var4);

    protected abstract void assignLeafValsBySamplingFromPosteriorMeanAndSigsqAndUpdateYhats(bartMachineTreeNode var1, double var2);
}

