## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("gauss_example_2", package = "YEAB") # In this case the IF value is 30s.
peak_data <- gauss_example_2
den <- density(peak_data$Response_Average)

fwhm_values <- fwhm(den$x, den$y)

fwhm_values

## ----echo = FALSE-------------------------------------------------------------
# x1 <- fwhm_values$peak - fwhm_values$fwhm / 2
# x2 <- fwhm_values$peak + fwhm_values$fwhm / 2
plot(den,
  main = "Full Width at Half Maximum",
  xlab = " "
)
abline(v = c(fwhm_values$x1, fwhm_values$peak, fwhm_values$x2), col = c(1, 2, 1))
abline(h = max(den$y) / 2, col = 1)

