/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.data;

import keel.Algorithms.Neural_Networks.NNEP_Common.data.DatasetException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IMetadata;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.Metadata;

public abstract class AbstractDataset
implements IDataset {
    protected String name;
    protected Metadata metadata;
    protected int cursorPosition;
    protected Instance cursorInstance;

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public abstract void open() throws DatasetException;

    @Override
    public abstract void close() throws DatasetException;

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public int numberOfInstances() throws DatasetException {
        int currCursorPosition = this.cursorPosition;
        this.reset();
        int numbVec = 0;
        while (this.next()) {
            ++numbVec;
        }
        this.reset();
        for (int i = 0; i < currCursorPosition; ++i) {
            this.next();
        }
        return numbVec;
    }

    @Override
    public abstract void reset() throws DatasetException;

    @Override
    public abstract boolean next() throws DatasetException;

    @Override
    public abstract boolean move(int var1) throws DatasetException;

    @Override
    public IDataset.IInstance read(int rowNumber) throws DatasetException {
        this.move(rowNumber);
        return this.read();
    }

    @Override
    public int read(IDataset.IInstance[] buffer) throws DatasetException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(IDataset.IInstance[] b, int off, int len) throws DatasetException {
        int i;
        if (b == null) {
            throw new DatasetException("Array b can't be null.");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new DatasetException("Index out of bounds. Check offset and length.");
        }
        if (len == 0) {
            return 0;
        }
        for (i = 0; i < len && this.next(); ++i) {
            b[off + i] = this.read();
        }
        return i;
    }

    protected class Instance
    implements IDataset.IInstance {
        protected double[] values;
        protected double weight;

        protected Instance() {
            this.values = new double[AbstractDataset.this.metadata.numberOfAttributes()];
        }

        public final void setValue(int attributeIndex, double attributeValue) {
            this.values[attributeIndex] = attributeValue;
        }

        public final void setValue(int attributeIndex, String attributeString) {
        }

        public final void setWeight(double weight) {
            this.weight = weight;
        }

        @Override
        public double[] getValues() {
            return this.values;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public double getValue(int attributeIndex) {
            return this.values[attributeIndex];
        }

        @Override
        public double getValue(IAttribute attribute) {
            return this.values[AbstractDataset.this.metadata.getIndex(attribute)];
        }

        @Override
        public double getValue(String attributeName) {
            return this.values[AbstractDataset.this.metadata.getIndex(attributeName)];
        }
    }
}

