/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree.mut;

import java.util.Comparator;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class SelectiveMutator
implements IMutateSyntaxTree,
IConfigure {
    private static final long serialVersionUID = -2706522794304044852L;
    protected int maximumBrachDepth;
    protected NonTerminalNode[] selectedSymbols;
    protected Comparator<SyntaxTreeNode> symbolsComparator = new Comparator<SyntaxTreeNode>(){

        @Override
        public int compare(SyntaxTreeNode o1, SyntaxTreeNode o2) {
            if (o1 instanceof NonTerminalNode && o2 instanceof NonTerminalNode) {
                NonTerminalNode co1 = (NonTerminalNode)o1;
                NonTerminalNode co2 = (NonTerminalNode)o2;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append(co1.getSymbol(), co2.getSymbol());
                if (eb.isEquals()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };

    public int getMaximumBrachDepth() {
        return this.maximumBrachDepth;
    }

    public void setMaximumBrachDepth(int maximumBrachDepth) {
        this.maximumBrachDepth = maximumBrachDepth;
    }

    public NonTerminalNode[] getSelectedSymbols() {
        return this.selectedSymbols;
    }

    public void setSelectedSymbols(NonTerminalNode[] selectedSymbols) {
        this.selectedSymbols = selectedSymbols;
    }

    @Override
    public void configure(Configuration settings) {
        int maximumBranchDepth = settings.getInt("maximum-branch-depth");
        this.setMaximumBrachDepth(maximumBranchDepth);
        int selSymDimension = settings.getInt("selected-symbols[@selected-dimension]");
        this.selectedSymbols = new NonTerminalNode[selSymDimension];
        int i = 0;
        while (i < selSymDimension) {
            NonTerminalNode element = new NonTerminalNode();
            String header = "selected-symbols.dimension(" + i + ")";
            String selName = settings.getString(String.valueOf(header) + ".name");
            element.setSymbol(selName);
            this.selectedSymbols[i] = element;
            ++i;
        }
        this.setSelectedSymbols(this.selectedSymbols);
    }

    @Override
    public SyntaxTree mutateSyntaxTree(SyntaxTree parent, SyntaxTreeSchema schema, IRandGen randgen) {
        if (this.selectedSymbols == null) {
            this.selectedSymbols = schema.getNonTerminals();
        }
        SyntaxTree son = new SyntaxTree();
        int numberOfSelectedSymbols = this.selectedSymbols.length;
        NonTerminalNode selectedSymbol = this.selectedSymbols[randgen.choose(0, numberOfSelectedSymbols)];
        int p0_branchStart = this.searchSymbolIn(selectedSymbol, parent, randgen);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            return son;
        }
        int p0_branchEnd = parent.subTree(p0_branchStart);
        int i = 0;
        while (i < p0_branchStart) {
            son.addNode(parent.getNode(i).copy());
            ++i;
        }
        int p0_branchDepth = parent.derivSize();
        int p0_swapBranch = 0;
        int i2 = p0_branchStart;
        while (i2 < p0_branchEnd) {
            if (parent.getNode(i2).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i2;
        }
        schema.fillSyntaxBranch(son, selectedSymbol.getSymbol(), p0_branchDepth - p0_swapBranch, randgen);
        int p0_length = parent.size();
        int i3 = p0_branchEnd;
        while (i3 < p0_length) {
            son.addNode(parent.getNode(i3).copy());
            ++i3;
        }
        return son;
    }

    private final int searchSymbolIn(NonTerminalNode symbol, SyntaxTree tree, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (this.symbolsComparator.compare(symbol, tree.getNode(actPos)) == 0) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

