/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ResIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Iterator;

public final class IteratorFactory {
    private IteratorFactory() {
    }

    public static RDFNode asRDFNode(Node n, Model m) {
        return m.asRDFNode(n);
    }

    public static Statement asStatement(Triple t, ModelCom m) {
        return StatementImpl.toStatement(t, m);
    }

    public static StmtIterator asStmtIterator(Iterator i, final ModelCom m) {
        return new StmtIteratorImpl(new Map1Iterator(new Map1(){

            public Object map1(Object o) {
                return m.asStatement((Triple)o);
            }
        }, i));
    }

    public static ResIterator asResIterator(Iterator i, final ModelCom m) {
        return new ResIteratorImpl((Iterator)new Map1Iterator(new Map1(){

            public Object map1(Object o) {
                return m.asRDFNode((Node)o);
            }
        }, i), null);
    }

    public static NodeIterator asRDFNodeIterator(Iterator i, final ModelCom m) {
        return new NodeIteratorImpl((Iterator)new Map1Iterator(new Map1(){

            public Object map1(Object o) {
                return m.asRDFNode((Node)o);
            }
        }, i), null);
    }

    static Resource asResource(Node n, ModelCom m) {
        return IteratorFactory.asResource(n, Resource.class, m);
    }

    static Property asProperty(Node n, ModelCom m) {
        return (Property)IteratorFactory.asResource(n, Property.class, m);
    }

    static Literal asLiteral(Node n, ModelCom m) {
        return (Literal)((Object)m.getNodeAs(n, Literal.class));
    }

    static Resource asResource(Node n, Class cl, ModelCom m) {
        return (Resource)((Object)m.getNodeAs(n, cl));
    }
}

