/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmx21Client;
import it.bancaditalia.oss.sdmx.client.RestSdmx30Client;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxUnknownProviderException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.lang.reflect.InvocationTargetException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDMXClientFactory {
    private static final String sourceClass;
    protected static Logger logger;
    private static NavigableMap<String, Provider> providers;

    private static void initExternalProviders() throws SdmxException {
        String string = Configuration.getExternalProviders();
        if (string != null && !string.isEmpty()) {
            String[] stringArray = string.trim().split("\\s*,\\s*");
            for (int i = 0; i < stringArray.length; ++i) {
                SDMXClientFactory.addExternalProvider(stringArray[i]);
            }
        }
    }

    public static void addProvider(String string, URI uRI, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) throws SdmxException {
        SDMXClientFactory.addProvider(string, uRI, bl, bl2, bl3, bl4, string2, SDMXVersion.V2);
    }

    public static void addProvider(String string, URI uRI, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, SDMXVersion sDMXVersion) throws SdmxException {
        Provider provider = new Provider(string, uRI, bl, bl2, bl3, bl4, string2, sDMXVersion);
        providers.put(string, provider);
    }

    private static void addExternalProvider(String string) throws SdmxException {
        try {
            String string2 = Configuration.getProperty("providers." + string + ".name", string);
            String string3 = Configuration.getProperty("providers." + string + ".endpoint", (String)null);
            if (string3 == null || string3.isEmpty()) {
                logger.warning("No URL has been configured for the external provider: '" + string + "'. It will be skipped.");
                return;
            }
            URI uRI = new URI(string3);
            boolean bl = Configuration.getProperty("providers." + string + ".needsCredentials", false);
            boolean bl2 = Configuration.getProperty("providers." + string + ".needsURLEncoding", false);
            boolean bl3 = Configuration.getProperty("providers." + string + ".supportsCompression", false);
            boolean bl4 = Configuration.getProperty("providers." + string + ".supportsAvailability", false);
            String string4 = Configuration.getProperty("providers." + string + ".description", string);
            SDMXVersion sDMXVersion = Configuration.getProperty("providers." + string + ".sdmxversion", SDMXVersion.V2);
            SDMXClientFactory.addProvider(string2, uRI, bl, bl2, bl3, bl4, string4, sDMXVersion);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.log(Level.SEVERE, "Exception. Class: {0} .Message: {1}", new Object[]{uRISyntaxException.getClass().getName(), uRISyntaxException.getMessage()});
            logger.log(Level.FINER, "", uRISyntaxException);
        }
    }

    public static GenericSDMXClient createClient(String string) throws SdmxException {
        Object object;
        logger.entering(sourceClass, "createClient");
        logger.fine("Create an SDMX client for '" + string + "'");
        GenericSDMXClient genericSDMXClient = null;
        Provider provider = (Provider)providers.get(string);
        if (provider == null) {
            throw new SdmxInvalidParameterException("The provider '" + string + "' is not available in this configuration.");
        }
        try {
            object = Class.forName("it.bancaditalia.oss.sdmx.client.custom." + string).asSubclass(GenericSDMXClient.class);
            genericSDMXClient = ((Class)object).getConstructor(Provider.class).newInstance(provider);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (provider.getEndpoint().getScheme().toLowerCase().startsWith("http")) {
                switch (provider.getSdmxVersion()) {
                    case V2: {
                        genericSDMXClient = new RestSdmx21Client(provider);
                    }
                    case V3: {
                        genericSDMXClient = new RestSdmx30Client(provider);
                    }
                    default: {
                        throw new SdmxInvalidParameterException("Unsupported SDMX REST API version: " + (Object)((Object)provider.getSdmxVersion()));
                    }
                }
            }
            throw new SdmxInvalidParameterException("The protocol '" + provider.getEndpoint().getScheme() + "' is not supported.");
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            logger.severe("The provider implementation it.bancaditalia.oss.sdmx.client.custom." + string + " does not define a default constructor.");
            throw new SdmxUnknownProviderException(string, reflectiveOperationException);
        }
        catch (InstantiationException | InvocationTargetException reflectiveOperationException) {
            logger.severe("Could not instantiate provider implementation it.bancaditalia.oss.sdmx.client.custom." + string);
            throw new SdmxUnknownProviderException(string, reflectiveOperationException);
        }
        object = provider.getEndpoint().getHost();
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (object != null && proxySelector != null && proxySelector instanceof SdmxProxySelector) {
            ((SdmxProxySelector)proxySelector).addToDefaultProxy((String)object);
        }
        logger.exiting(sourceClass, "createClient");
        return genericSDMXClient;
    }

    public static NavigableMap<String, Provider> getProviders() {
        return providers;
    }

    static {
        providers = new TreeMap<String, Provider>();
        logger = Configuration.getSdmxLogger();
        try {
            SDMXClientFactory.initExternalProviders();
        }
        catch (SdmxException sdmxException) {
            sdmxException.printStackTrace();
        }
        sourceClass = SDMXClientFactory.class.getSimpleName();
    }
}

