/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.Timer;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSampler;
import cern.jet.stat.tfloat.FloatDescriptive;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.bin.DynamicFloatBin1D;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.ref.FloatHistogram2D;
import hep.aida.tfloat.ref.FloatHistogram3D;
import hep.aida.tfloat.ref.FloatVariableAxis;
import java.util.concurrent.Future;

public class FloatStatistic {
    private static final FloatFunctions F = FloatFunctions.functions;
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        public final float apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return (float)Math.sqrt(floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.chain(FloatFunctions.square, FloatFunctions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        public final float apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.chain(FloatFunctions.abs, FloatFunctions.minus)) / floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        FloatFloatFunction fun = new FloatFloatFunction(){

            public final float apply(float f, float f2) {
                return Math.abs(f - f2) / Math.abs(f + f2);
            }
        };

        public final float apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        public final float apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.max, FloatFunctions.chain(FloatFunctions.abs, FloatFunctions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        public final float apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
            return floatMatrix1D.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.chain(FloatFunctions.abs, FloatFunctions.minus));
        }
    };

    protected FloatStatistic() {
    }

    public static FloatMatrix2D aggregate(FloatMatrix2D floatMatrix2D, FloatBinFunction1D[] floatBinFunction1DArray, FloatMatrix2D floatMatrix2D2) {
        DynamicFloatBin1D dynamicFloatBin1D = new DynamicFloatBin1D();
        float[] fArray = new float[floatMatrix2D.rows()];
        FloatArrayList floatArrayList = new FloatArrayList(fArray);
        int n = floatMatrix2D.columns();
        while (--n >= 0) {
            floatMatrix2D.viewColumn(n).toArray(fArray);
            dynamicFloatBin1D.clear();
            dynamicFloatBin1D.addAllOf(floatArrayList);
            int n2 = floatBinFunction1DArray.length;
            while (--n2 >= 0) {
                floatMatrix2D2.set(n2, n, floatBinFunction1DArray[n2].apply(dynamicFloatBin1D));
            }
        }
        return floatMatrix2D2;
    }

    public static DynamicFloatBin1D bin(FloatMatrix1D floatMatrix1D) {
        DynamicFloatBin1D dynamicFloatBin1D = new DynamicFloatBin1D();
        dynamicFloatBin1D.addAllOf(FloatFactory1D.dense.toList(floatMatrix1D));
        return dynamicFloatBin1D;
    }

    public static FloatMatrix2D correlation(FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix2D.columns();
        while (--n >= 0) {
            int n2 = n;
            while (--n2 >= 0) {
                float f = (float)Math.sqrt(floatMatrix2D.getQuick(n, n));
                float f2 = (float)Math.sqrt(floatMatrix2D.getQuick(n2, n2));
                float f3 = floatMatrix2D.getQuick(n, n2);
                float f4 = f3 / (f * f2);
                floatMatrix2D.setQuick(n, n2, f4);
                floatMatrix2D.setQuick(n2, n, f4);
            }
        }
        n = floatMatrix2D.columns();
        while (--n >= 0) {
            floatMatrix2D.setQuick(n, n, 1.0f);
        }
        return floatMatrix2D;
    }

    public static FloatMatrix2D covariance(FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(n2, n2);
        float[] fArray = new float[n2];
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            floatMatrix1DArray[n3] = floatMatrix2D.viewColumn(n3);
            fArray[n3] = floatMatrix1DArray[n3].zSum();
        }
        n3 = n2;
        while (--n3 >= 0) {
            int n4 = n3 + 1;
            while (--n4 >= 0) {
                float f = floatMatrix1DArray[n3].zDotProduct(floatMatrix1DArray[n4]);
                float f2 = (f - fArray[n3] * fArray[n4] / (float)n) / (float)n;
                ((FloatMatrix2D)denseFloatMatrix2D).setQuick(n3, n4, f2);
                ((FloatMatrix2D)denseFloatMatrix2D).setQuick(n4, n3, f2);
            }
        }
        return denseFloatMatrix2D;
    }

    public static FloatIHistogram2D cube(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, FloatMatrix1D floatMatrix1D3) {
        if (floatMatrix1D.size() != floatMatrix1D2.size() || floatMatrix1D2.size() != floatMatrix1D3.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        float f = 1.0E-5f;
        FloatArrayList floatArrayList = new FloatArrayList();
        float[] fArray = new float[(int)floatMatrix1D.size()];
        FloatArrayList floatArrayList2 = new FloatArrayList(fArray);
        floatMatrix1D.toArray(fArray);
        floatArrayList2.sort();
        FloatDescriptive.frequencies(floatArrayList2, floatArrayList, null);
        if (floatArrayList.size() > 0) {
            floatArrayList.add(floatArrayList.get(floatArrayList.size() - 1) + f);
        }
        floatArrayList.trimToSize();
        FloatVariableAxis floatVariableAxis = new FloatVariableAxis(floatArrayList.elements());
        floatMatrix1D2.toArray(fArray);
        floatArrayList2.sort();
        FloatDescriptive.frequencies(floatArrayList2, floatArrayList, null);
        if (floatArrayList.size() > 0) {
            floatArrayList.add(floatArrayList.get(floatArrayList.size() - 1) + f);
        }
        floatArrayList.trimToSize();
        FloatVariableAxis floatVariableAxis2 = new FloatVariableAxis(floatArrayList.elements());
        FloatHistogram2D floatHistogram2D = new FloatHistogram2D("Cube", floatVariableAxis, floatVariableAxis2);
        return FloatStatistic.histogram(floatHistogram2D, floatMatrix1D, floatMatrix1D2, floatMatrix1D3);
    }

    public static FloatIHistogram3D cube(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, FloatMatrix1D floatMatrix1D3, FloatMatrix1D floatMatrix1D4) {
        if (floatMatrix1D.size() != floatMatrix1D2.size() || floatMatrix1D.size() != floatMatrix1D3.size() || floatMatrix1D.size() != floatMatrix1D4.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        float f = 1.0E-5f;
        FloatArrayList floatArrayList = new FloatArrayList();
        float[] fArray = new float[(int)floatMatrix1D.size()];
        FloatArrayList floatArrayList2 = new FloatArrayList(fArray);
        floatMatrix1D.toArray(fArray);
        floatArrayList2.sort();
        FloatDescriptive.frequencies(floatArrayList2, floatArrayList, null);
        if (floatArrayList.size() > 0) {
            floatArrayList.add(floatArrayList.get(floatArrayList.size() - 1) + f);
        }
        floatArrayList.trimToSize();
        FloatVariableAxis floatVariableAxis = new FloatVariableAxis(floatArrayList.elements());
        floatMatrix1D2.toArray(fArray);
        floatArrayList2.sort();
        FloatDescriptive.frequencies(floatArrayList2, floatArrayList, null);
        if (floatArrayList.size() > 0) {
            floatArrayList.add(floatArrayList.get(floatArrayList.size() - 1) + f);
        }
        floatArrayList.trimToSize();
        FloatVariableAxis floatVariableAxis2 = new FloatVariableAxis(floatArrayList.elements());
        floatMatrix1D3.toArray(fArray);
        floatArrayList2.sort();
        FloatDescriptive.frequencies(floatArrayList2, floatArrayList, null);
        if (floatArrayList.size() > 0) {
            floatArrayList.add(floatArrayList.get(floatArrayList.size() - 1) + f);
        }
        floatArrayList.trimToSize();
        FloatVariableAxis floatVariableAxis3 = new FloatVariableAxis(floatArrayList.elements());
        FloatHistogram3D floatHistogram3D = new FloatHistogram3D("Cube", floatVariableAxis, floatVariableAxis2, floatVariableAxis3);
        return FloatStatistic.histogram(floatHistogram3D, floatMatrix1D, floatMatrix1D2, floatMatrix1D3, floatMatrix1D4);
    }

    public static void demo1() {
        float[][] fArrayArray = new float[][]{{1.0f, 2.0f, 3.0f}, {2.0f, 4.0f, 6.0f}, {3.0f, 6.0f, 9.0f}, {4.0f, -8.0f, -10.0f}};
        FloatFactory2D floatFactory2D = FloatFactory2D.dense;
        FloatMatrix2D floatMatrix2D = floatFactory2D.make(fArrayArray);
        System.out.println("\n\nmatrix=" + floatMatrix2D);
        System.out.println("\ncovar1=" + FloatStatistic.covariance(floatMatrix2D));
    }

    public static void demo2(int n, int n2, boolean bl) {
        System.out.println("\n\ninitializing...");
        FloatFactory2D floatFactory2D = FloatFactory2D.dense;
        FloatMatrix2D floatMatrix2D = floatFactory2D.ascending(n, n2);
        System.out.println("benchmarking correlation...");
        Timer timer = new Timer().start();
        FloatMatrix2D floatMatrix2D2 = FloatStatistic.correlation(FloatStatistic.covariance(floatMatrix2D));
        timer.stop().display();
        if (bl) {
            System.out.println("printing result...");
            System.out.println(floatMatrix2D2);
        }
        System.out.println("done.");
    }

    public static void demo3(VectorVectorFunction vectorVectorFunction) {
        float[][] fArrayArray = new float[][]{{-0.9611052f, -0.25421095f}, {0.4308269f, -0.69932646f}, {-1.2071029f, 0.62030596f}, {1.5345166f, 0.02135884f}, {-1.1341542f, 0.2038843f}};
        System.out.println("\n\ninitializing...");
        FloatFactory2D floatFactory2D = FloatFactory2D.dense;
        FloatMatrix2D floatMatrix2D = floatFactory2D.make(fArrayArray).viewDice();
        System.out.println("\nA=" + floatMatrix2D.viewDice());
        System.out.println("\ndist=" + FloatStatistic.distance(floatMatrix2D, vectorVectorFunction).viewDice());
    }

    public static FloatMatrix2D distance(FloatMatrix2D floatMatrix2D, VectorVectorFunction vectorVectorFunction) {
        int n = floatMatrix2D.columns();
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(n, n);
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n];
        int n2 = n;
        while (--n2 >= 0) {
            floatMatrix1DArray[n2] = floatMatrix2D.viewColumn(n2);
        }
        n2 = n;
        while (--n2 >= 0) {
            int n3 = n2;
            while (--n3 >= 0) {
                float f = vectorVectorFunction.apply(floatMatrix1DArray[n2], floatMatrix1DArray[n3]);
                ((FloatMatrix2D)denseFloatMatrix2D).setQuick(n2, n3, f);
                ((FloatMatrix2D)denseFloatMatrix2D).setQuick(n3, n2, f);
            }
        }
        return denseFloatMatrix2D;
    }

    public static FloatIHistogram1D histogram(FloatIHistogram1D floatIHistogram1D, FloatMatrix1D floatMatrix1D) {
        int n = (int)floatMatrix1D.size();
        while (--n >= 0) {
            floatIHistogram1D.fill(floatMatrix1D.getQuick(n));
        }
        return floatIHistogram1D;
    }

    public static FloatIHistogram1D histogram(FloatIHistogram1D floatIHistogram1D, FloatMatrix2D floatMatrix2D) {
        floatIHistogram1D.fill_2D((float[])floatMatrix2D.elements(), floatMatrix2D.rows(), floatMatrix2D.columns(), (int)floatMatrix2D.index(0, 0), floatMatrix2D.rowStride(), floatMatrix2D.columnStride());
        return floatIHistogram1D;
    }

    public static FloatIHistogram1D[][] histogram(final FloatIHistogram1D[][] floatIHistogram1DArray, final FloatMatrix2D floatMatrix2D, int n, final int n2) {
        int n3;
        int n4 = floatMatrix2D.rows();
        int n5 = floatMatrix2D.columns();
        if (n >= n4) {
            throw new IllegalArgumentException("Parameter m must be smaller than the number of rows in the matrix");
        }
        if (n2 >= n5) {
            throw new IllegalArgumentException("Parameter n must be smaller than the number of columns in the matrix");
        }
        final int n6 = n4 / n;
        final int n7 = n5 / n2;
        final int[] nArray = new int[n];
        final int[] nArray2 = new int[n2];
        for (n3 = 0; n3 < n - 1; ++n3) {
            nArray[n3] = n6;
        }
        nArray[n - 1] = n4 - (n - 1) * n6;
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            nArray2[n3] = n7;
        }
        nArray2[n2 - 1] = n5 - (n2 - 1) * n7;
        n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n4 * n5 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n8 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n3 - 1 ? n : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        FloatMatrix2D floatMatrix2D2 = null;
                        for (int i = n9; i < n10; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                floatMatrix2D2 = floatMatrix2D.viewPart(i * n6, j * n7, nArray[i], nArray2[j]);
                                floatIHistogram1DArray[i][j].fill_2D((float[])floatMatrix2D2.elements(), floatMatrix2D2.rows(), floatMatrix2D2.columns(), (int)floatMatrix2D2.index(0, 0), floatMatrix2D2.rowStride(), floatMatrix2D2.columnStride());
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            FloatMatrix2D floatMatrix2D2 = null;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    floatMatrix2D2 = floatMatrix2D.viewPart(i * n6, j * n7, nArray[i], nArray2[j]);
                    floatIHistogram1DArray[i][j].fill_2D((float[])floatMatrix2D2.elements(), floatMatrix2D2.rows(), floatMatrix2D2.columns(), (int)floatMatrix2D2.index(0, 0), floatMatrix2D2.rowStride(), floatMatrix2D2.columnStride());
                }
            }
        }
        return floatIHistogram1DArray;
    }

    public static FloatIHistogram2D histogram(FloatIHistogram2D floatIHistogram2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D.size() != floatMatrix1D2.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = (int)floatMatrix1D.size();
        while (--n >= 0) {
            floatIHistogram2D.fill(floatMatrix1D.getQuick(n), floatMatrix1D2.getQuick(n));
        }
        return floatIHistogram2D;
    }

    public static FloatIHistogram2D histogram(FloatIHistogram2D floatIHistogram2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, FloatMatrix1D floatMatrix1D3) {
        if (floatMatrix1D.size() != floatMatrix1D2.size() || floatMatrix1D2.size() != floatMatrix1D3.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = (int)floatMatrix1D.size();
        while (--n >= 0) {
            floatIHistogram2D.fill(floatMatrix1D.getQuick(n), floatMatrix1D2.getQuick(n), floatMatrix1D3.getQuick(n));
        }
        return floatIHistogram2D;
    }

    public static FloatIHistogram3D histogram(FloatIHistogram3D floatIHistogram3D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, FloatMatrix1D floatMatrix1D3, FloatMatrix1D floatMatrix1D4) {
        if (floatMatrix1D.size() != floatMatrix1D2.size() || floatMatrix1D.size() != floatMatrix1D3.size() || floatMatrix1D.size() != floatMatrix1D4.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int n = (int)floatMatrix1D.size();
        while (--n >= 0) {
            floatIHistogram3D.fill(floatMatrix1D.getQuick(n), floatMatrix1D2.getQuick(n), floatMatrix1D3.getQuick(n), floatMatrix1D4.getQuick(n));
        }
        return floatIHistogram3D;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        boolean bl = stringArray[2].equals("print");
        FloatStatistic.demo2(n, n2, bl);
    }

    public static FloatMatrix1D viewSample(FloatMatrix1D floatMatrix1D, float f, FloatRandomEngine floatRandomEngine) {
        int n;
        float f2 = 1.0E-5f;
        if (f < 0.0f - f2 || f > 1.0f + f2) {
            throw new IllegalArgumentException();
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (floatRandomEngine == null) {
            floatRandomEngine = new FloatMersenneTwister((int)System.currentTimeMillis());
        }
        int n2 = n = Math.round((float)floatMatrix1D.size() * f);
        long[] lArray = new long[n2];
        int n3 = n;
        int n4 = (int)floatMatrix1D.size();
        FloatRandomSampler.sample(n3, n4, n3, 0L, lArray, 0, floatRandomEngine);
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return floatMatrix1D.viewSelection(nArray);
    }

    public static FloatMatrix2D viewSample(FloatMatrix2D floatMatrix2D, float f, float f2, FloatRandomEngine floatRandomEngine) {
        float f3 = 1.0E-5f;
        if (f < 0.0f - f3 || f > 1.0f + f3) {
            throw new IllegalArgumentException();
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f - f3 || f2 > 1.0f + f3) {
            throw new IllegalArgumentException();
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (floatRandomEngine == null) {
            floatRandomEngine = new FloatMersenneTwister((int)System.currentTimeMillis());
        }
        int n = Math.round((float)floatMatrix2D.rows() * f);
        int n2 = Math.round((float)floatMatrix2D.columns() * f2);
        int n3 = Math.max(n, n2);
        long[] lArray = new long[n3];
        int n4 = n;
        int n5 = floatMatrix2D.rows();
        FloatRandomSampler.sample(n4, n5, n4, 0L, lArray, 0, floatRandomEngine);
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = (int)lArray[i];
        }
        n4 = n2;
        n5 = floatMatrix2D.columns();
        FloatRandomSampler.sample(n4, n5, n4, 0L, lArray, 0, floatRandomEngine);
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = (int)lArray[i];
        }
        return floatMatrix2D.viewSelection(nArray, nArray2);
    }

    public static FloatMatrix3D viewSample(FloatMatrix3D floatMatrix3D, float f, float f2, float f3, FloatRandomEngine floatRandomEngine) {
        float f4 = 1.0E-5f;
        if (f < 0.0f - f4 || f > 1.0f + f4) {
            throw new IllegalArgumentException();
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f - f4 || f2 > 1.0f + f4) {
            throw new IllegalArgumentException();
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f - f4 || f3 > 1.0f + f4) {
            throw new IllegalArgumentException();
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (floatRandomEngine == null) {
            floatRandomEngine = new FloatMersenneTwister((int)System.currentTimeMillis());
        }
        int n = Math.round((float)floatMatrix3D.slices() * f);
        int n2 = Math.round((float)floatMatrix3D.rows() * f2);
        int n3 = Math.round((float)floatMatrix3D.columns() * f3);
        int n4 = Math.max(n, Math.max(n2, n3));
        long[] lArray = new long[n4];
        int n5 = n;
        int n6 = floatMatrix3D.slices();
        FloatRandomSampler.sample(n5, n6, n5, 0L, lArray, 0, floatRandomEngine);
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = (int)lArray[i];
        }
        n5 = n2;
        n6 = floatMatrix3D.rows();
        FloatRandomSampler.sample(n5, n6, n5, 0L, lArray, 0, floatRandomEngine);
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray2[i] = (int)lArray[i];
        }
        n5 = n3;
        n6 = floatMatrix3D.columns();
        FloatRandomSampler.sample(n5, n6, n5, 0L, lArray, 0, floatRandomEngine);
        int[] nArray3 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray3[i] = (int)lArray[i];
        }
        return floatMatrix3D.viewSelection(nArray, nArray2, nArray3);
    }

    public static interface VectorVectorFunction {
        public float apply(FloatMatrix1D var1, FloatMatrix1D var2);
    }
}

