/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class FieldDescription
extends AbstractInboundMessage
implements PGConstants {
    private final byte[] m_fieldName;
    private final short m_columnAttributeNumber;
    private final int m_dataTypeObjectID;
    private final int m_dataTypeSize;
    private final int m_dataTypeModifier;
    private final short m_formatCode;
    private final String m_tableObjectIDString;
    private final String m_columnAttributeNumberString;

    public FieldDescription(ByteBuffer byteBuffer, IPGLogger iPGLogger) {
        this.m_fieldName = this.getNullTerminatedField(byteBuffer);
        int n = byteBuffer.getInt();
        this.m_tableObjectIDString = Integer.toString(n);
        this.m_columnAttributeNumber = byteBuffer.getShort();
        this.m_columnAttributeNumberString = Short.toString(this.m_columnAttributeNumber);
        this.m_dataTypeObjectID = byteBuffer.getInt();
        int n2 = byteBuffer.getShort();
        this.m_dataTypeModifier = byteBuffer.getInt();
        this.m_formatCode = byteBuffer.getShort();
        int n3 = this.getDataTypeModifier();
        if (-1 == n2) {
            if (n3 > 0) {
                n2 = n3;
                if (FieldDescription.isVariableLengthType(this.m_dataTypeObjectID)) {
                    n2 -= 4;
                }
            } else {
                n2 = 0;
            }
        }
        this.m_dataTypeSize = n2;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public byte[] getFieldName() {
        return this.m_fieldName;
    }

    public String getTableObjectIDString() {
        return this.m_tableObjectIDString;
    }

    public short getColumnAttributeNumber() {
        return this.m_columnAttributeNumber;
    }

    public String getColumnAttributeNumberString() {
        return this.m_columnAttributeNumberString;
    }

    public int getDataTypeObjectID() {
        return this.m_dataTypeObjectID;
    }

    public int getDataTypeSize() {
        return this.m_dataTypeSize;
    }

    public int getDataTypeModifier() {
        return this.m_dataTypeModifier;
    }

    public short getFormatCode() {
        return this.m_formatCode;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = this.getFormatCode() == 0 ? "T" : "B";
        String string2 = "\t Field(" + new String(this.getFieldName()) + "," + this.getDataTypeObjectID() + "," + this.m_dataTypeSize + "," + string + ")";
        iPGLogger.logDebugExternal(string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nFieldDescription: getFieldName - ");
        stringBuilder.append(new String(this.getFieldName()));
        stringBuilder.append("\ngetTableObjectID - ");
        stringBuilder.append(this.getTableObjectIDString());
        stringBuilder.append("\ngetColumnAttributeNumber - ");
        stringBuilder.append(this.getColumnAttributeNumber());
        stringBuilder.append("\ngetDataTypeObjectID - ");
        stringBuilder.append(this.getDataTypeObjectID());
        stringBuilder.append("\ngetDataTypeSize - ");
        stringBuilder.append(this.getDataTypeSize());
        stringBuilder.append("\ngetDataTypeModifier - ");
        stringBuilder.append(this.getDataTypeModifier());
        stringBuilder.append("\ngetFormatCode - ");
        stringBuilder.append(this.getFormatCode());
        return stringBuilder.toString();
    }

    private static boolean isVariableLengthType(int n) {
        return n == 25 || n == 1043 || n == 1562 || n == 1042;
    }
}

