/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

import dr.math.MathUtils;
import dr.math.functionEval.DrMath;
import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.NewtonZeroFinder;
import java.util.Enumeration;
import java.util.Vector;

public class PolynomialFunction
implements OneVariableFunction {
    private final double[] coefficients;

    public PolynomialFunction(double[] dArray) {
        this.coefficients = dArray;
    }

    public PolynomialFunction add(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[n];
        dArray[0] = this.coefficients[0] + d;
        for (int i = 1; i < n; ++i) {
            dArray[i] = this.coefficients[i];
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction add(PolynomialFunction polynomialFunction) {
        int n = Math.max(polynomialFunction.degree(), this.degree()) + 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficient(i) + polynomialFunction.coefficient(i);
        }
        return new PolynomialFunction(dArray);
    }

    public double coefficient(int n) {
        return n < this.coefficients.length ? this.coefficients[n] : 0.0;
    }

    public PolynomialFunction deflate(double d) {
        int n = this.degree();
        double d2 = this.coefficients[n];
        double[] dArray = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            dArray[i] = d2;
            d2 = d2 * d + this.coefficients[i];
        }
        return new PolynomialFunction(dArray);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public PolynomialFunction derivative() {
        int n = this.degree();
        if (n == 0) {
            double[] dArray = new double[]{0.0};
            return new PolynomialFunction(dArray);
        }
        double[] dArray = new double[n];
        for (int i = 1; i <= n; ++i) {
            dArray[i - 1] = this.coefficients[i] * (double)i;
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction divide(double d) {
        return this.multiply(1.0 / d);
    }

    public PolynomialFunction divide(PolynomialFunction polynomialFunction) {
        return this.divideWithRemainder(polynomialFunction)[0];
    }

    public PolynomialFunction[] divideWithRemainder(PolynomialFunction polynomialFunction) {
        int n;
        int n2;
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[2];
        int n3 = this.degree();
        if (n3 < (n2 = polynomialFunction.degree())) {
            double[] dArray = new double[]{0.0};
            polynomialFunctionArray[0] = new PolynomialFunction(dArray);
            polynomialFunctionArray[1] = polynomialFunction;
            return polynomialFunctionArray;
        }
        double[] dArray = new double[n3 - n2 + 1];
        double[] dArray2 = new double[n3 + 1];
        for (int i = 0; i <= n3; ++i) {
            dArray2[i] = this.coefficients[i];
        }
        double d = 1.0 / polynomialFunction.coefficient(n2);
        for (int i = n3 - n2; i >= 0; --i) {
            dArray[i] = dArray2[n2 + i] * d;
            for (n = n2 + i - 1; n >= i; --n) {
                int n4 = n;
                dArray2[n4] = dArray2[n4] - dArray[i] * polynomialFunction.coefficient(n - i);
            }
        }
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = dArray2[n];
        }
        polynomialFunctionArray[0] = new PolynomialFunction(dArray);
        polynomialFunctionArray[1] = new PolynomialFunction(dArray3);
        return polynomialFunctionArray;
    }

    public PolynomialFunction integral() {
        return this.integral(0.0);
    }

    public PolynomialFunction integral(double d) {
        int n = this.coefficients.length + 1;
        double[] dArray = new double[n];
        dArray[0] = d;
        for (int i = 1; i < n; ++i) {
            dArray[i] = this.coefficients[i - 1] / (double)i;
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction multiply(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficients[i] * d;
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction multiply(PolynomialFunction polynomialFunction) {
        int n = polynomialFunction.degree() + this.degree();
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j <= i; ++j) {
                int n2 = i;
                dArray[n2] = dArray[n2] + polynomialFunction.coefficient(j) * this.coefficient(i - j);
            }
        }
        return new PolynomialFunction(dArray);
    }

    public double[] roots() {
        return this.roots(DrMath.defaultNumericalPrecision());
    }

    public double[] roots(double d) {
        PolynomialFunction polynomialFunction = this.derivative();
        double d2 = 0.0;
        while (Math.abs(polynomialFunction.value(d2)) < d) {
            d2 = MathUtils.nextDouble();
        }
        PolynomialFunction polynomialFunction2 = this;
        NewtonZeroFinder newtonZeroFinder = new NewtonZeroFinder(this, polynomialFunction, d2);
        newtonZeroFinder.setDesiredPrecision(d);
        Vector<Double> vector = new Vector<Double>(this.degree());
        while (true) {
            newtonZeroFinder.evaluate();
            if (!newtonZeroFinder.hasConverged()) break;
            double d3 = newtonZeroFinder.getResult();
            vector.addElement(d3);
            polynomialFunction2 = polynomialFunction2.deflate(d3);
            if (polynomialFunction2.degree() == 0) break;
            newtonZeroFinder.setFunction(polynomialFunction2);
            try {
                newtonZeroFinder.setDerivative(polynomialFunction2.derivative());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        double[] dArray = new double[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            dArray[n++] = (Double)enumeration.nextElement();
        }
        return dArray;
    }

    public PolynomialFunction subtract(double d) {
        return this.add(-d);
    }

    public PolynomialFunction subtract(PolynomialFunction polynomialFunction) {
        int n = Math.max(polynomialFunction.degree(), this.degree()) + 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficient(i) - polynomialFunction.coefficient(i);
        }
        return new PolynomialFunction(dArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.coefficients.length; ++i) {
            if (this.coefficients[i] == 0.0) continue;
            if (bl) {
                stringBuffer.append(this.coefficients[i] > 0.0 ? " + " : " ");
            } else {
                bl = true;
            }
            if (i == 0 || this.coefficients[i] != 1.0) {
                stringBuffer.append(Double.toString(this.coefficients[i]));
            }
            if (i <= 0) continue;
            stringBuffer.append(" X^" + i);
        }
        return stringBuffer.toString();
    }

    @Override
    public double value(double d) {
        int n = this.coefficients.length;
        double d2 = this.coefficients[--n];
        while (n > 0) {
            d2 = d2 * d + this.coefficients[--n];
        }
        return d2;
    }

    public double[] valueAndDerivative(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[]{this.coefficients[--n], 0.0};
        while (n > 0) {
            dArray[1] = dArray[1] * d + dArray[0];
            dArray[0] = dArray[0] * d + this.coefficients[--n];
        }
        return dArray;
    }
}

