/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.loggers;

import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.inference.model.Likelihood;

public class MLLogger
extends MCLogger {
    private final Likelihood likelihood;
    private double bestLikelihood;
    private long bestState;
    private String[] bestValues = null;
    private long logEvery = 0L;

    public MLLogger(Likelihood likelihood, LogFormatter logFormatter, long l) {
        super(logFormatter, l, false);
        this.likelihood = likelihood;
    }

    @Override
    public void startLogging() {
        this.bestLikelihood = Double.NEGATIVE_INFINITY;
        this.bestState = 0L;
        this.bestValues = new String[this.getColumnCount()];
        if (this.logEvery > 0L) {
            String[] stringArray = new String[this.getColumnCount() + 1];
            stringArray[0] = "state";
            for (int i = 0; i < this.getColumnCount(); ++i) {
                stringArray[i + 1] = this.getColumnLabel(i);
            }
            this.logLabels(stringArray);
        }
        super.startLogging();
    }

    @Override
    public void log(long l) {
        double d = this.likelihood.getLogLikelihood();
        if (d > this.bestLikelihood) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.bestValues[i] = this.getColumnFormatted(i);
            }
            this.bestState = l;
            this.bestLikelihood = d;
            if (this.logEvery == 1L) {
                String[] stringArray = new String[this.getColumnCount() + 1];
                stringArray[0] = Long.toString(this.bestState);
                System.arraycopy(this.bestValues, 0, stringArray, 1, this.getColumnCount());
                this.logValues(stringArray);
            }
        }
        if (this.logEvery > 1L && l % this.logEvery == 0L) {
            String[] stringArray = new String[this.getColumnCount() + 1];
            stringArray[0] = Long.toString(this.bestState);
            System.arraycopy(this.bestValues, 0, stringArray, 1, this.getColumnCount());
            this.logValues(stringArray);
        }
    }

    @Override
    public void stopLogging() {
        int n = this.getColumnCount();
        String[] stringArray = new String[n + 2];
        stringArray[0] = Long.toString(this.bestState);
        stringArray[1] = Double.toString(this.bestLikelihood);
        System.arraycopy(this.bestValues, 0, stringArray, 2, n);
        if (this.logEvery > 0L) {
            this.logValues(stringArray);
        } else {
            String[] stringArray2 = new String[n + 2];
            stringArray2[0] = "state";
            stringArray2[1] = "ML";
            for (int i = 0; i < n; ++i) {
                stringArray2[i + 2] = this.getColumnLabel(i);
            }
            this.logLabels(stringArray2);
            this.logValues(stringArray);
        }
        super.stopLogging();
    }
}

