/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeNodeFilter;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class BackboneNodeFilter
extends AbstractModel
implements TreeNodeFilter {
    private boolean backboneSetKnown;
    private final Set<NodeRef> backboneSet;
    private BitSet tipSet;
    private final Tree tree;
    private final boolean includeStem;
    private final boolean excludeClade;

    public BackboneNodeFilter(String string, Tree tree, TaxonList taxonList, boolean bl, boolean bl2) {
        super(string);
        this.tree = tree;
        this.excludeClade = bl;
        this.includeStem = bl2;
        this.backboneSet = new HashSet<NodeRef>();
        try {
            this.tipSet = TreeUtils.getTipsBitSetForTaxa(this.tree, taxonList);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            missingTaxonException.printStackTrace();
        }
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.backboneSetKnown = false;
    }

    @Override
    public boolean includeNode(Tree tree, NodeRef nodeRef) {
        if (!this.backboneSetKnown) {
            this.computeBackBoneMap();
            this.backboneSetKnown = true;
        }
        return this.backboneSet.contains(nodeRef);
    }

    public void computeBackBoneMap() {
        this.backboneSet.clear();
        this.recursivelyComputeBackBoneMap(this.tree, this.tree.getRoot());
    }

    private boolean recursivelyComputeBackBoneMap(Tree tree, NodeRef nodeRef) {
        boolean bl = false;
        if (tree.isExternal(nodeRef)) {
            if (this.tipSet.get(nodeRef.getNumber())) {
                bl = true;
            }
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                if (!this.recursivelyComputeBackBoneMap(tree, nodeRef2)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.recursivelyPruneStemAndClade(tree, nodeRef, this.includeStem, this.excludeClade);
            return true;
        }
        return false;
    }

    private void recursivelyPruneStemAndClade(Tree tree, NodeRef nodeRef, boolean bl, boolean bl2) {
        if (!tree.isExternal(nodeRef) && !bl2) {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.recursivelyPruneStemAndClade(tree, nodeRef2, true, true);
            }
        }
        if (bl && !this.backboneSet.contains(nodeRef)) {
            this.backboneSet.add(nodeRef);
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.backboneSetKnown = false;
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

