/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Clade;
import dr.evolution.tree.ImportanceDistribution;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractCladeImportanceDistribution
implements ImportanceDistribution {
    protected Clade getNonComplementaryClades(Tree tree, NodeRef nodeRef, List<Clade> list, List<Clade> list2, HashMap<String, Integer> hashMap) {
        BitSet bitSet = new BitSet();
        Clade clade = null;
        if (tree.isExternal(nodeRef)) {
            String string = tree.getTaxon(nodeRef.getNumber()).getId();
            int n = hashMap.get(string);
            bitSet.set(n);
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
        } else {
            NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
            Clade clade2 = this.getNonComplementaryClades(tree, nodeRef2, list, list2, hashMap);
            bitSet.or(clade2.getBits());
            nodeRef2 = tree.getChild(nodeRef, 1);
            Clade clade3 = this.getNonComplementaryClades(tree, nodeRef2, list, list2, hashMap);
            bitSet.or(clade3.getBits());
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
            if (clade2.getSize() >= 2) {
                list.add(clade);
                list2.add(clade2);
            } else if (clade3.getSize() >= 2) {
                list.add(clade);
                list2.add(clade3);
            }
        }
        return clade;
    }

    protected Clade getNonComplementaryClades(Tree tree, NodeRef nodeRef, List<Clade> list, List<Clade> list2) {
        BitSet bitSet = new BitSet();
        Clade clade = null;
        if (tree.isExternal(nodeRef)) {
            int n = nodeRef.getNumber();
            bitSet.set(n);
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
        } else {
            NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
            Clade clade2 = this.getNonComplementaryClades(tree, nodeRef2, list, list2);
            bitSet.or(clade2.getBits());
            nodeRef2 = tree.getChild(nodeRef, 1);
            Clade clade3 = this.getNonComplementaryClades(tree, nodeRef2, list, list2);
            bitSet.or(clade3.getBits());
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
            if (clade2.getSize() >= 2) {
                list.add(clade);
                list2.add(clade2);
            } else if (clade3.getSize() >= 2) {
                list.add(clade);
                list2.add(clade3);
            }
        }
        return clade;
    }

    protected Clade getClades(Tree tree, NodeRef nodeRef, List<Clade> list, List<Clade> list2) {
        BitSet bitSet = new BitSet();
        Clade clade = null;
        if (tree.isExternal(nodeRef)) {
            int n = nodeRef.getNumber();
            bitSet.set(n);
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
        } else {
            NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
            Clade clade2 = this.getClades(tree, nodeRef2, list, list2);
            bitSet.or(clade2.getBits());
            nodeRef2 = tree.getChild(nodeRef, 1);
            Clade clade3 = this.getClades(tree, nodeRef2, list, list2);
            bitSet.or(clade3.getBits());
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
            if (clade2.getSize() >= 2) {
                list.add(clade);
                list2.add(clade2);
            }
            if (clade3.getSize() >= 2) {
                list.add(clade);
                list2.add(clade3);
            }
        }
        return clade;
    }

    protected Clade getClades(Tree tree, NodeRef nodeRef, List<Clade> list, List<Clade> list2, HashMap<String, Integer> hashMap) {
        BitSet bitSet = new BitSet();
        Clade clade = null;
        if (tree.isExternal(nodeRef)) {
            String string = tree.getTaxon(nodeRef.getNumber()).getId();
            int n = hashMap.get(string);
            bitSet.set(n);
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
        } else {
            NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
            Clade clade2 = this.getClades(tree, nodeRef2, list, list2, hashMap);
            bitSet.or(clade2.getBits());
            nodeRef2 = tree.getChild(nodeRef, 1);
            Clade clade3 = this.getClades(tree, nodeRef2, list, list2, hashMap);
            bitSet.or(clade3.getBits());
            clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
            if (clade2.getSize() >= 2) {
                list.add(clade);
                list2.add(clade2);
            }
            if (clade3.getSize() >= 2) {
                list.add(clade);
                list2.add(clade3);
            }
        }
        return clade;
    }

    public void getClades(Tree tree, NodeRef nodeRef, List<Clade> list, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        if (tree.isExternal(nodeRef)) {
            int n = nodeRef.getNumber();
            bitSet2.set(n);
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.getClades(tree, nodeRef2, list, bitSet2);
            }
            list.add(new Clade(bitSet2, tree.getNodeHeight(nodeRef)));
        }
        if (bitSet != null) {
            bitSet.or(bitSet2);
        }
    }

    public void getCladesHeights(Tree tree, NodeRef nodeRef, List<Double> list) {
        if (!tree.isExternal(nodeRef)) {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.getCladesHeights(tree, nodeRef2, list);
            }
            list.add(tree.getNodeHeight(nodeRef));
        }
    }

    public void getRelativeCladesHeights(Tree tree, NodeRef nodeRef, List<Double> list) {
        if (!tree.isExternal(nodeRef)) {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.getRelativeCladesHeights(tree, nodeRef2, list);
            }
            if (nodeRef != tree.getRoot()) {
                NodeRef nodeRef3 = tree.getParent(nodeRef);
                list.add(tree.getNodeHeight(nodeRef) / tree.getNodeHeight(nodeRef3));
            } else {
                list.add(1.0);
            }
        }
    }

    protected Clade getClade(Tree tree, NodeRef nodeRef) {
        int n;
        BitSet bitSet = new BitSet();
        if (tree.isExternal(nodeRef)) {
            n = nodeRef.getNumber();
            bitSet.set(n);
        } else {
            for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, n);
                Clade clade = this.getClade(tree, nodeRef2);
                bitSet.or(clade.getBits());
            }
        }
        Clade clade = new Clade(bitSet, tree.getNodeHeight(nodeRef));
        return clade;
    }

    protected Clade getParentClade(List<Clade> list, Clade clade) {
        Clade clade2 = null;
        BitSet bitSet = clade.getBits();
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            Clade clade3 = list.get(i);
            if (clade.equals(clade3) || !this.containsClade(clade3.getBits(), bitSet) || clade2 != null && n <= clade3.getSize()) continue;
            clade2 = clade3;
            n = clade2.getSize();
        }
        if (clade2 == null) {
            clade2 = clade;
        }
        return clade2;
    }

    protected boolean containsClade(Clade clade, Clade clade2) {
        return this.containsClade(clade.getBits(), clade2.getBits());
    }

    protected boolean containsClade(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.xor(bitSet2);
        int n = bitSet3.cardinality();
        bitSet3.and(bitSet);
        int n2 = bitSet3.cardinality();
        return n == n2;
    }

    @Override
    public abstract void addTree(Tree var1);

    @Override
    public abstract double getTreeProbability(Tree var1);

    @Override
    public abstract double splitClade(Clade var1, Clade[] var2);

    public abstract double setNodeHeights(TreeModel var1, Likelihood var2);

    public abstract double getChanceForNodeHeights(TreeModel var1, Likelihood var2);
}

