/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.AbstractOutbreak;
import dr.evomodel.epidemiology.casetocase.BadPartitionException;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PartitionedTreeModel
extends TreeModel {
    private final AbstractOutbreak outbreak;
    private BranchMapModel branchMap;
    private final int elementCount;
    public static final String PARTITIONED_TREE_MODEL = "partitionedTreeModel";
    Set<NodeRef> partitionsQueue = new HashSet<NodeRef>();

    public PartitionedTreeModel(String string, Tree tree, AbstractOutbreak abstractOutbreak) {
        super(string, tree);
        this.outbreak = abstractOutbreak;
        this.elementCount = abstractOutbreak.infectedSize();
        this.branchMap = new BranchMapModel(this);
        this.partitionAccordingToRandomTT(false);
    }

    public PartitionedTreeModel(String string, Tree tree, AbstractOutbreak abstractOutbreak, String string2) {
        super(string, tree);
        this.outbreak = abstractOutbreak;
        this.elementCount = abstractOutbreak.infectedSize();
        this.branchMap = new BranchMapModel(this);
        this.partitionAccordingToSpecificTT(string2);
    }

    public PartitionedTreeModel(TreeModel treeModel, AbstractOutbreak abstractOutbreak) {
        this(PARTITIONED_TREE_MODEL, treeModel, abstractOutbreak);
    }

    public PartitionedTreeModel(TreeModel treeModel, AbstractOutbreak abstractOutbreak, String string) {
        this(PARTITIONED_TREE_MODEL, (Tree)treeModel, abstractOutbreak, string);
    }

    public void partitionsChangingAlert(HashSet<AbstractCase> hashSet) {
        this.listenerHelper.fireModelChanged(this, new PartitionsChangedEvent(hashSet));
    }

    public void partitionChangingAlert(AbstractCase abstractCase) {
        HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>();
        hashSet.add(abstractCase);
        this.partitionsChangingAlert(hashSet);
    }

    public void universalAlert() {
        HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>(Arrays.asList(this.branchMap.getArrayCopy()));
        this.partitionsChangingAlert(hashSet);
    }

    public BranchMapModel getBranchMap() {
        return this.branchMap;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    public void pushNodePartitionsChangedEvent(NodeRef nodeRef) {
        int n = nodeRef.getNumber();
        if (!this.inTreeEdit()) {
            this.partitionChangingAlert(this.branchMap.get(n));
        } else {
            this.partitionsQueue.add(nodeRef);
        }
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
            this.universalAlert();
        } else {
            TreeModel.Node node = this.getNodeOfParameter((Parameter)variable);
            this.partitionsChangingAlert(this.adjacentElements(node));
        }
    }

    public HashSet<AbstractCase> adjacentElements(NodeRef nodeRef) {
        HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>();
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        arrayList.add(nodeRef);
        arrayList.add(this.getParent(nodeRef));
        arrayList.add(this.getChild(nodeRef, 0));
        arrayList.add(this.getChild(nodeRef, 1));
        for (NodeRef nodeRef2 : arrayList) {
            if (nodeRef2 == null) continue;
            hashSet.add(this.branchMap.get(nodeRef2.getNumber()));
        }
        return hashSet;
    }

    private void flushQueue() {
        if (this.inTreeEdit()) {
            throw new RuntimeException("Wait until you've finished editing the tree before flushing the partitionqueue");
        }
        for (NodeRef nodeRef : this.partitionsQueue) {
            AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
            this.partitionChangingAlert(abstractCase);
            NodeRef nodeRef2 = this.getParent(nodeRef);
            if (nodeRef2 == null || this.branchMap.get(nodeRef.getNumber()) == this.branchMap.get(nodeRef2.getNumber())) continue;
            this.partitionChangingAlert(this.branchMap.get(nodeRef2.getNumber()));
        }
        this.partitionsQueue.clear();
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.pushNodePartitionsChangedEvent(nodeRef);
        this.pushNodePartitionsChangedEvent(nodeRef2);
        super.addChild(nodeRef, nodeRef2);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.pushNodePartitionsChangedEvent(nodeRef);
        this.pushNodePartitionsChangedEvent(nodeRef2);
        super.removeChild(nodeRef, nodeRef2);
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        this.partitionsChangingAlert(this.adjacentElements(nodeRef));
        super.setNodeHeight(nodeRef, d);
    }

    @Override
    public void endTreeEdit() {
        super.endTreeEdit();
        this.flushQueue();
    }

    public boolean checkPartitions() {
        return this.checkPartitions(this.branchMap, true);
    }

    protected boolean checkPartitions(BranchMapModel branchMapModel, boolean bl) {
        int n;
        boolean bl2 = false;
        for (n = 0; n < this.getInternalNodeCount(); ++n) {
            boolean bl3 = false;
            for (Integer n2 : this.samePartitionElement(this.getInternalNode(n))) {
                if (!this.isExternal(this.getNode(n2))) continue;
                bl3 = true;
            }
            if (bl2 || bl3) continue;
            bl2 = true;
            if (!bl) continue;
            System.out.println("Node " + (n + this.getExternalNodeCount()) + " is not connected to a tip");
        }
        for (n = 0; n < this.getExternalNodeCount(); ++n) {
            AbstractCase abstractCase = this.branchMap.get(n);
            NodeRef nodeRef = this.caseMRCA(abstractCase);
            if (this.branchMap.get(nodeRef.getNumber()) == abstractCase) continue;
            throw new BadPartitionException("Node partition disconnected");
        }
        return !bl2;
    }

    public HashSet<Integer> samePartitionElementUpTree(NodeRef nodeRef) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
        NodeRef nodeRef2 = nodeRef;
        NodeRef nodeRef3 = this.getParent(nodeRef);
        while (nodeRef3 != null && this.branchMap.get(nodeRef3.getNumber()) == abstractCase) {
            hashSet.add(nodeRef3.getNumber());
            if (this.countChildrenInSameElement(nodeRef3) == 2) {
                NodeRef nodeRef4 = PartitionedTreeModel.sibling(this, nodeRef2);
                hashSet.add(nodeRef4.getNumber());
                hashSet.addAll(this.samePartitionElementDownTree(nodeRef4));
            }
            nodeRef2 = nodeRef3;
            nodeRef3 = this.getParent(nodeRef2);
        }
        return hashSet;
    }

    public HashSet<Integer> samePartitionElementDownTree(NodeRef nodeRef) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
        for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
            if (this.branchMap.get(this.getChild(nodeRef, i).getNumber()) != abstractCase) continue;
            hashSet.add(this.getChild(nodeRef, i).getNumber());
            hashSet.addAll(this.samePartitionElementDownTree(this.getChild(nodeRef, i)));
        }
        return hashSet;
    }

    public Integer[] samePartitionElement(NodeRef nodeRef) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(nodeRef.getNumber());
        hashSet.addAll(this.samePartitionElementUpTree(nodeRef));
        hashSet.addAll(this.samePartitionElementDownTree(nodeRef));
        return hashSet.toArray(new Integer[hashSet.size()]);
    }

    public int[] allTipsForThisCase(AbstractCase abstractCase) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.getExternalNodeCount(); ++i) {
            if (this.branchMap.get(i) != abstractCase) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public NodeRef getEarliestNodeInElement(AbstractCase abstractCase) {
        if (abstractCase.wasEverInfected()) {
            boolean bl;
            NodeRef nodeRef = this.caseMRCA(abstractCase);
            if (this.branchMap.get(nodeRef.getNumber()) != abstractCase) {
                throw new BadPartitionException("Node partition element disconnected");
            }
            NodeRef nodeRef2 = nodeRef;
            NodeRef nodeRef3 = this.getParent(nodeRef2);
            boolean bl2 = bl = nodeRef3 == null;
            while (!bl) {
                if (this.branchMap.get(nodeRef2.getNumber()) != this.branchMap.get(nodeRef3.getNumber())) {
                    bl = true;
                    continue;
                }
                nodeRef2 = nodeRef3;
                if ((nodeRef3 = this.getParent(nodeRef2)) != null) continue;
                bl = true;
            }
            return nodeRef2;
        }
        return null;
    }

    public HashSet<AbstractCase> getDescendants(AbstractCase abstractCase) {
        HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>(this.getInfectees(abstractCase));
        if (abstractCase.wasEverInfected()) {
            for (AbstractCase abstractCase2 : hashSet) {
                hashSet.addAll(this.getDescendants(abstractCase2));
            }
        }
        return hashSet;
    }

    public AbstractCase getInfector(AbstractCase abstractCase) {
        if (abstractCase.wasEverInfected()) {
            NodeRef nodeRef = this.caseMRCA(abstractCase);
            if (this.branchMap.get(nodeRef.getNumber()) != abstractCase) {
                throw new BadPartitionException("Node partition element disconnected");
            }
            NodeRef nodeRef2 = nodeRef;
            while (this.branchMap.get(nodeRef2.getNumber()) == abstractCase) {
                if ((nodeRef2 = this.getParent(nodeRef2)) != null) continue;
                return null;
            }
            return this.branchMap.get(nodeRef2.getNumber());
        }
        return null;
    }

    public AbstractCase getRootCase() {
        return this.branchMap.get(this.getRoot().getNumber());
    }

    public HashSet<AbstractCase> getInfectees(AbstractCase abstractCase) {
        if (abstractCase.wasEverInfected()) {
            return this.getInfecteesInClade(this.getEarliestNodeInElement(abstractCase));
        }
        return new HashSet<AbstractCase>();
    }

    public HashSet<AbstractCase> getInfecteesInClade(NodeRef nodeRef) {
        HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>();
        if (this.isExternal(nodeRef)) {
            return hashSet;
        }
        AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
        for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.getChild(nodeRef, i);
            AbstractCase abstractCase2 = this.branchMap.get(nodeRef2.getNumber());
            if (abstractCase2 != abstractCase) {
                hashSet.add(abstractCase2);
                continue;
            }
            hashSet.addAll(this.getInfecteesInClade(nodeRef2));
        }
        return hashSet;
    }

    public AbstractCase getInfector(NodeRef nodeRef) {
        if (this.isRoot(nodeRef) || nodeRef.getNumber() == this.getRoot().getNumber()) {
            return null;
        }
        AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
        if (this.branchMap.get(this.getParent(nodeRef).getNumber()) != abstractCase) {
            return this.branchMap.get(this.getParent(nodeRef).getNumber());
        }
        return this.getInfector(this.getParent(nodeRef));
    }

    public AbstractCase getParentCase(NodeRef nodeRef) {
        return this.branchMap.get(this.getParent(nodeRef).getNumber());
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public int countChildrenInSameElement(NodeRef nodeRef) {
        if (this.isExternal(nodeRef)) {
            return -1;
        }
        int n = 0;
        AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
        for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
            if (this.branchMap.get(this.getChild(nodeRef, i).getNumber()) != abstractCase) continue;
            ++n;
        }
        return n;
    }

    public static NodeRef sibling(TreeModel treeModel, NodeRef nodeRef) {
        if (treeModel.isRoot(nodeRef)) {
            return null;
        }
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
            if (treeModel.getChild(nodeRef2, i) == nodeRef) continue;
            return treeModel.getChild(nodeRef2, i);
        }
        return null;
    }

    public NodeRef caseMRCA(AbstractCase abstractCase, boolean bl) {
        int[] nArray = this.allTipsForThisCase(abstractCase);
        NodeRef nodeRef = TreeUtils.getCommonAncestor(this, nArray);
        if (bl && this.branchMap.get(nodeRef.getNumber()) != abstractCase) {
            throw new BadPartitionException("A partition element is disconnected");
        }
        return nodeRef;
    }

    public NodeRef caseMRCA(AbstractCase abstractCase) {
        return this.caseMRCA(abstractCase, true);
    }

    private HashSet<NodeRef> getDescendantTips(NodeRef nodeRef) {
        HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
        if (this.isExternal(nodeRef)) {
            hashSet.add(nodeRef);
            return hashSet;
        }
        hashSet.addAll(this.getDescendantTips(this.getChild(nodeRef, 0)));
        hashSet.addAll(this.getDescendantTips(this.getChild(nodeRef, 1)));
        return hashSet;
    }

    public boolean isAncestral(NodeRef nodeRef) {
        AbstractCase abstractCase = this.branchMap.get(nodeRef.getNumber());
        for (NodeRef nodeRef2 : this.getDescendantTips(nodeRef)) {
            if (this.branchMap.get(nodeRef2.getNumber()) != abstractCase) continue;
            return true;
        }
        return false;
    }

    public boolean isRootBlockedBy(AbstractCase abstractCase, AbstractCase abstractCase2) {
        return this.directDescendant(this.caseMRCA(abstractCase), this.caseMRCA(abstractCase2));
    }

    public boolean isRootBlocked(AbstractCase abstractCase) {
        for (AbstractCase abstractCase2 : this.outbreak.getCases()) {
            if (!abstractCase2.wasEverInfected || abstractCase2 == abstractCase || !this.isRootBlockedBy(abstractCase, abstractCase2)) continue;
            return true;
        }
        return false;
    }

    private HashSet<NodeRef> getTipsInThisPartitionElement(AbstractCase abstractCase) {
        HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
        for (int i = 0; i < this.getExternalNodeCount(); ++i) {
            if (this.branchMap.get(i) != abstractCase) continue;
            hashSet.add(this.getExternalNode(i));
        }
        return hashSet;
    }

    private boolean directDescendant(NodeRef nodeRef, NodeRef nodeRef2) {
        NodeRef nodeRef3 = nodeRef;
        while (nodeRef3 != null) {
            if (nodeRef3 == nodeRef2) {
                return true;
            }
            nodeRef3 = this.getParent(nodeRef3);
        }
        return false;
    }

    private boolean directRelationship(NodeRef nodeRef, NodeRef nodeRef2) {
        return this.directDescendant(nodeRef, nodeRef2) || this.directDescendant(nodeRef2, nodeRef);
    }

    private AbstractCase[] prepareExternalNodeMap(AbstractCase[] abstractCaseArray) {
        for (int i = 0; i < this.getExternalNodeCount(); ++i) {
            TreeModel.Node node = (TreeModel.Node)this.getExternalNode(i);
            Taxon taxon = node.taxon;
            for (AbstractCase abstractCase : this.outbreak.getCases()) {
                if (!abstractCase.wasEverInfected()) continue;
                for (Taxon taxon2 : abstractCase.getAssociatedTaxa()) {
                    if (!taxon2.equals(taxon)) continue;
                    abstractCaseArray[node.getNumber()] = abstractCase;
                }
            }
        }
        return abstractCaseArray;
    }

    private void partitionAccordingToSpecificTT(String string) {
        System.out.println("Using specified starting transmission tree.");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            HashMap<AbstractCase, AbstractCase> hashMap = new HashMap<AbstractCase, AbstractCase>();
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = (string2 = string2.replace("\"", "")).split("\\,");
                if (!stringArray[1].equals("Start")) {
                    hashMap.put(this.outbreak.getCase(stringArray[0]), this.outbreak.getCase(stringArray[1]));
                } else {
                    hashMap.put(this.outbreak.getCase(stringArray[0]), null);
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.partitionAccordingToSpecificTT(hashMap);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read file: " + string);
        }
    }

    private void partitionAccordingToSpecificTT(HashMap<AbstractCase, AbstractCase> hashMap) {
        this.branchMap.setAll(this.prepareExternalNodeMap(new AbstractCase[this.getNodeCount()]), true);
        for (AbstractCase abstractCase : hashMap.keySet()) {
            if (abstractCase.wasEverInfected) continue;
            throw new RuntimeException("This starting transmission tree involves never-infected cases");
        }
        Object object = null;
        int n = 0;
        for (AbstractCase abstractCase : this.outbreak.getCases()) {
            if (!abstractCase.wasEverInfected() || hashMap.get(abstractCase) != null) continue;
            object = abstractCase;
            ++n;
        }
        if (n == 0) {
            throw new RuntimeException("Given starting transmission tree appears to have a cycle");
        }
        if (n > 1) {
            throw new RuntimeException("Given starting transmission tree appears not to be connected");
        }
        NodeRef nodeRef = this.getRoot();
        this.specificallyPartitionDownwards(nodeRef, (AbstractCase)object, hashMap);
        if (!this.checkPartitions()) {
            throw new RuntimeException("Given starting transmission tree is not compatible with the starting tree");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void specificallyPartitionDownwards(NodeRef nodeRef, AbstractCase abstractCase, HashMap<AbstractCase, AbstractCase> hashMap) {
        if (this.isExternal(nodeRef)) {
            return;
        }
        this.branchMap.set(nodeRef.getNumber(), abstractCase, true);
        if (this.isAncestral(nodeRef)) {
            for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
                this.specificallyPartitionDownwards(this.getChild(nodeRef, i), abstractCase, hashMap);
            }
        } else {
            void var6_12;
            this.branchMap.set(nodeRef.getNumber(), null, true);
            HashSet<AbstractCase> hashSet = new HashSet<AbstractCase>();
            for (AbstractCase object : this.outbreak.getCases()) {
                if (hashMap.get(object) != abstractCase) continue;
                hashSet.add(object);
            }
            HashSet<AbstractCase> hashSet2 = new HashSet(hashSet);
            for (AbstractCase abstractCase2 : hashSet) {
                NodeRef nodeRef2 = this.caseMRCA(abstractCase2);
                if (this.directDescendant(nodeRef, nodeRef2)) {
                    throw new RuntimeException("Starting transmission tree is incompatible with starting phylogeny");
                }
                if (nodeRef2 == nodeRef) {
                    hashSet2 = new HashSet<AbstractCase>();
                    hashSet2.add(abstractCase2);
                    break;
                }
                NodeRef nodeRef3 = nodeRef2;
                while (nodeRef3 != nodeRef && nodeRef3 != null) {
                    nodeRef3 = this.getParent(nodeRef3);
                }
                if (nodeRef3 != null) continue;
                hashSet2.remove(abstractCase2);
            }
            if (hashSet2.size() == 1) {
                AbstractCase abstractCase3 = (AbstractCase)hashSet2.iterator().next();
                this.branchMap.set(nodeRef.getNumber(), abstractCase3, true);
            } else {
                this.branchMap.set(nodeRef.getNumber(), abstractCase, true);
            }
            boolean bl = false;
            while (var6_12 < this.getChildCount(nodeRef)) {
                this.specificallyPartitionDownwards(this.getChild(nodeRef, (int)var6_12), this.branchMap.get(nodeRef.getNumber()), hashMap);
                ++var6_12;
            }
        }
    }

    private void partitionAccordingToRandomTT(boolean bl) {
        System.out.println("Generating a random starting partition of the tree");
        this.branchMap.setAll(this.prepareExternalNodeMap(new AbstractCase[this.getNodeCount()]), true);
        NodeRef nodeRef = this.getRoot();
        this.randomlyAssignNode(nodeRef, bl);
    }

    private AbstractCase randomlyAssignNode(NodeRef nodeRef, boolean bl) {
        int n;
        Serializable serializable;
        Serializable serializable2;
        if (this.isExternal(nodeRef)) {
            return this.branchMap.get(nodeRef.getNumber());
        }
        ArrayList<AbstractCase> arrayList = new ArrayList<AbstractCase>();
        for (AbstractCase abstractCase : this.outbreak.getCases()) {
            if (!abstractCase.wasEverInfected) continue;
            serializable2 = this.caseMRCA(abstractCase, false);
            serializable = this.getTipsInThisPartitionElement(abstractCase);
            Iterator<NodeRef> iterator = ((HashSet)serializable).iterator();
            while (iterator.hasNext()) {
                NodeRef nodeRef2 = iterator.next();
                if (!this.directDescendant(nodeRef, (NodeRef)serializable2) || !this.directDescendant(nodeRef2, nodeRef) || arrayList.contains(abstractCase)) continue;
                arrayList.add(abstractCase);
            }
        }
        if (arrayList.size() > 1) {
            throw new RuntimeException("Starting phylogeny is incompatible with this tip partition");
        }
        if (arrayList.size() == 1) {
            this.branchMap.set(nodeRef.getNumber(), (AbstractCase)arrayList.get(0), true);
            for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
                if (this.isExternal(this.getChild(nodeRef, i))) continue;
                this.randomlyAssignNode(this.getChild(nodeRef, i), bl);
            }
            return (AbstractCase)arrayList.get(0);
        }
        AbstractCase[] abstractCaseArray = new AbstractCase[2];
        for (n = 0; n < this.getChildCount(nodeRef); ++n) {
            abstractCaseArray[n] = !this.isExternal(this.getChild(nodeRef, n)) ? this.randomlyAssignNode(this.getChild(nodeRef, n), bl) : this.branchMap.get(this.getChild(nodeRef, n).getNumber());
        }
        while (this.isRoot(nodeRef) && abstractCaseArray[0] == null && abstractCaseArray[1] == null) {
            for (n = 0; n < this.getChildCount(nodeRef); ++n) {
                abstractCaseArray[n] = !this.isExternal(this.getChild(nodeRef, n)) ? this.randomlyAssignNode(this.getChild(nodeRef, n), bl) : this.branchMap.get(this.getChild(nodeRef, n).getNumber());
            }
        }
        if (this.isRoot(nodeRef)) {
            n = MathUtils.nextInt(2);
            if (abstractCaseArray[n] == null) {
                n = 1 - n;
            }
            serializable2 = abstractCaseArray[n];
            this.fillDownTree(nodeRef, (AbstractCase)serializable2);
            return serializable2;
        }
        n = MathUtils.nextInt(bl ? 3 : 2);
        if (n != 2) {
            serializable2 = abstractCaseArray[n];
            serializable = abstractCaseArray[1 - n];
            if (this.getNodeHeight(this.getChild(nodeRef, n)) > ((AbstractCase)serializable).getInfectionBranchPosition().getParameterValue(0) * this.getBranchLength(this.getChild(nodeRef, 1 - n)) + this.getNodeHeight(this.getChild(nodeRef, 1 - n))) {
                serializable2 = serializable;
            }
            if (serializable2 != null) {
                this.fillDownTree(nodeRef, (AbstractCase)serializable2);
            } else {
                this.branchMap.set(nodeRef.getNumber(), null, true);
            }
            return serializable2;
        }
        return null;
    }

    private void fillDownTree(NodeRef nodeRef, AbstractCase abstractCase) {
        if (this.branchMap.get(nodeRef.getNumber()) == null) {
            this.branchMap.set(nodeRef.getNumber(), abstractCase, true);
            for (int i = 0; i < 2; ++i) {
                this.fillDownTree(this.getChild(nodeRef, i), abstractCase);
            }
        }
    }

    public class PartitionsChangedEvent {
        private final HashSet<AbstractCase> casesToRecalculate;

        public PartitionsChangedEvent(HashSet<AbstractCase> hashSet) {
            this.casesToRecalculate = hashSet;
        }

        public HashSet<AbstractCase> getCasesToRecalculate() {
            return this.casesToRecalculate;
        }
    }
}

