/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.CoalescentTreeIntervalStatistic;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;

public class ExponentialProductPosteriorMeansLikelihood
extends Likelihood.Abstract {
    public static final boolean FIXED_TREE = false;
    public static final boolean DEBUG = false;
    private TreeModel treeModel;
    private double[] posteriorMeans;

    public ExponentialProductPosteriorMeansLikelihood(TreeModel treeModel, double[] dArray) {
        super(treeModel);
        this.treeModel = treeModel;
        this.posteriorMeans = dArray;
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        CoalescentTreeIntervalStatistic coalescentTreeIntervalStatistic = new CoalescentTreeIntervalStatistic(this.treeModel);
        int n = 0;
        for (int i = 0; i < coalescentTreeIntervalStatistic.getDimension(); ++i) {
            double d2;
            int n2 = (int)coalescentTreeIntervalStatistic.getLineageCount(i) * ((int)coalescentTreeIntervalStatistic.getLineageCount(i) - 1) / 2;
            double d3 = coalescentTreeIntervalStatistic.getStatisticValue(i);
            if (coalescentTreeIntervalStatistic.getLineageCount(i) == 1.0) continue;
            if (i == coalescentTreeIntervalStatistic.getDimension() - 1) {
                d2 = -this.posteriorMeans[n] - (double)n2 * d3 * Math.exp(-this.posteriorMeans[n]);
                d += d2;
                continue;
            }
            if (coalescentTreeIntervalStatistic.getLineageCount(i) > coalescentTreeIntervalStatistic.getLineageCount(i + 1)) {
                d2 = -this.posteriorMeans[n] - (double)n2 * d3 * Math.exp(-this.posteriorMeans[n]);
                d += d2;
                ++n;
                continue;
            }
            d2 = (double)(-n2) * d3 * Math.exp(-this.posteriorMeans[n]);
            d += d2;
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }
}

