/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evomodel.alloppnet.operators.AlloppSequenceReassignment;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AlloppSequenceReassignmentParser
extends AbstractXMLObjectParser {
    public static final String SEQUENCE_REASSIGNMENT = "sequenceReassignment";

    @Override
    public String getParserName() {
        return SEQUENCE_REASSIGNMENT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        AlloppSpeciesBindings alloppSpeciesBindings = (AlloppSpeciesBindings)xMLObject.getChild(AlloppSpeciesBindings.class);
        AlloppSpeciesNetworkModel alloppSpeciesNetworkModel = (AlloppSpeciesNetworkModel)xMLObject.getChild(AlloppSpeciesNetworkModel.class);
        double d = xMLObject.getDoubleAttribute("weight");
        return new AlloppSequenceReassignment(alloppSpeciesNetworkModel, alloppSpeciesBindings, d);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(AlloppSpeciesBindings.class), new ElementRule(AlloppSpeciesNetworkModel.class)};
    }

    @Override
    public String getParserDescription() {
        return "Operator which reassigns sequences within an allopolyploid species.";
    }

    @Override
    public Class getReturnType() {
        return AlloppSequenceReassignment.class;
    }
}

