/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.util.XHTMLable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SitePatterns
implements SiteList,
XHTMLable {
    protected SiteList siteList = null;
    protected int siteCount = 0;
    protected int patternCount = 0;
    protected int patternLength = 0;
    protected int[] sitePatternIndices;
    protected int invariantCount;
    protected double[] weights;
    protected int[][] patterns;
    protected double[][][] uncertainPatterns;
    protected int from;
    protected int to;
    protected int every;
    protected boolean strip = true;
    protected boolean unique = true;
    private boolean uncertainSites = false;
    protected String id = null;

    public SitePatterns(Alignment alignment) {
        this(alignment, null, 0, 0, 1);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList) {
        this(alignment, taxonList, 0, 0, 1);
    }

    public SitePatterns(Alignment alignment, int n, int n2, int n3) {
        this(alignment, null, n, n2, n3);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3) {
        this(alignment, taxonList, n, n2, n3, true);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl) {
        this(alignment, taxonList, n, n2, n3, bl, true);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl, boolean bl2) {
        this(alignment, taxonList, n, n2, n3, bl, bl2, null);
    }

    public SitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, boolean bl, boolean bl2, int[] nArray) {
        if (taxonList != null) {
            SimpleAlignment simpleAlignment = new SimpleAlignment();
            for (int i = 0; i < alignment.getSequenceCount(); ++i) {
                if (taxonList.getTaxonIndex(alignment.getTaxonId(i)) == -1) continue;
                simpleAlignment.addSequence(alignment.getSequence(i));
            }
            alignment = simpleAlignment;
        }
        this.strip = bl;
        this.unique = bl2;
        this.setPatterns(alignment, n, n2, n3, nArray);
    }

    public SitePatterns(SiteList siteList) {
        this(siteList, -1, -1, 1, true, true);
    }

    public SitePatterns(SiteList siteList, int n, int n2, int n3) {
        this(siteList, n, n2, n3, true, true);
    }

    public SitePatterns(SiteList siteList, int n, int n2, int n3, boolean bl) {
        this(siteList, n, n2, n3, bl, true);
    }

    public SitePatterns(SiteList siteList, int n, int n2, int n3, boolean bl, boolean bl2) {
        this.strip = bl;
        this.unique = bl2;
        this.setPatterns(siteList, n, n2, n3, null);
    }

    public SitePatterns(SiteList siteList, boolean[] blArray) {
        this(siteList, blArray, true, true);
    }

    public SitePatterns(SiteList siteList, boolean[] blArray, boolean bl) {
        this(siteList, blArray, bl, true);
    }

    public SitePatterns(SiteList siteList, boolean[] blArray, boolean bl, boolean bl2) {
        this.strip = bl;
        this.unique = bl2;
        this.setPatterns(siteList, blArray);
    }

    public SiteList getSiteList() {
        return this.siteList;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getEvery() {
        return this.every;
    }

    public void setPatterns(SiteList siteList, int n, int n2, int n3, int[] nArray) {
        int n4;
        this.siteList = siteList;
        this.from = n;
        this.to = n2;
        this.every = n3;
        if (siteList == null) {
            return;
        }
        if (n <= -1) {
            n = 0;
        }
        if (n2 <= -1) {
            n2 = siteList.getSiteCount() - 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        this.siteCount = (n2 - n) / n3 + 1;
        this.patternCount = 0;
        this.patterns = new int[this.siteCount][];
        this.sitePatternIndices = new int[this.siteCount];
        this.weights = new double[this.siteCount];
        this.invariantCount = 0;
        this.uncertainSites = siteList.areUncertain();
        if (this.uncertainSites) {
            this.uncertainPatterns = new double[this.siteCount][][];
        }
        if (nArray != null) {
            if (nArray.length != siteList.getStateCount()) {
                throw new IllegalArgumentException("Constant site count array length doesn't equal the number of states");
            }
            for (n4 = 0; n4 < siteList.getStateCount(); ++n4) {
                int[] nArray2 = new int[siteList.getPatternLength()];
                for (int i = 0; i < siteList.getPatternLength(); ++i) {
                    nArray2[i] = n4;
                }
                this.addPattern(nArray2, nArray[n4], null);
            }
        }
        n4 = 0;
        for (int i = n; i <= n2; i += n3) {
            int[] nArray3 = siteList.getSitePattern(i);
            double[][] dArray = null;
            if (this.uncertainSites) {
                dArray = siteList.getUncertainSitePattern(i);
            }
            this.sitePatternIndices[n4] = !this.strip || !this.isInvariant(nArray3) || !this.isGapped(nArray3) && !this.isAmbiguous(nArray3) && !this.isUnknown(nArray3) ? this.addPattern(nArray3, dArray) : -1;
            ++n4;
        }
    }

    public void setPatterns(SiteList siteList, boolean[] blArray) {
        this.siteList = siteList;
        if (siteList == null) {
            return;
        }
        this.from = 0;
        this.to = siteList.getSiteCount() - 1;
        this.every = 1;
        this.siteCount = siteList.getSiteCount();
        this.patternCount = 0;
        this.patterns = new int[this.siteCount][];
        this.sitePatternIndices = new int[this.siteCount];
        this.weights = new double[this.siteCount];
        this.uncertainSites = siteList.areUncertain();
        if (this.uncertainSites) {
            this.uncertainPatterns = new double[this.siteCount][][];
        }
        this.invariantCount = 0;
        int n = 0;
        for (int i = this.from; i <= this.to; i += this.every) {
            int[] nArray = siteList.getSitePattern(i);
            if (!blArray[i]) continue;
            if (!(this.strip && this.isInvariant(nArray) && (this.isGapped(nArray) || this.isAmbiguous(nArray) || this.isUnknown(nArray)))) {
                double[][] dArray = null;
                if (this.uncertainSites) {
                    dArray = siteList.getUncertainSitePattern(i);
                }
                this.sitePatternIndices[n] = this.addPattern(nArray, dArray);
            } else {
                this.sitePatternIndices[n] = -1;
            }
            ++n;
        }
    }

    private int addPattern(int[] nArray, double[][] dArray) {
        return this.addPattern(nArray, 1, dArray);
    }

    private int addPattern(int[] nArray, int n, double[][] dArray) {
        int n2;
        for (n2 = 0; n2 < this.patternCount; ++n2) {
            if (!this.unique || !this.comparePatterns(this.patterns[n2], nArray)) continue;
            int n3 = n2;
            this.weights[n3] = this.weights[n3] + (double)n;
            return n2;
        }
        if (this.isInvariant(nArray)) {
            this.invariantCount += n;
        }
        n2 = this.patternCount;
        this.patterns[n2] = nArray;
        this.weights[n2] = n;
        if (this.uncertainSites) {
            if (dArray == null) {
                this.uncertainPatterns[n2] = new double[nArray.length][];
                for (int i = 0; i < nArray.length; ++i) {
                    int[] nArray2;
                    double[] dArray2 = new double[this.getDataType().getStateCount()];
                    for (int n4 : nArray2 = this.getDataType().getStates(nArray[i])) {
                        dArray2[n4] = 1.0;
                    }
                    this.uncertainPatterns[n2][i] = dArray2;
                }
            } else {
                this.uncertainPatterns[n2] = dArray;
            }
        }
        ++this.patternCount;
        return n2;
    }

    private boolean isGapped(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isGapState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isAmbiguous(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isAmbiguousState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUnknown(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isUnknownState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isInvariant(int[] nArray) {
        int n = nArray.length;
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            if (nArray[i] == n2) continue;
            return false;
        }
        return true;
    }

    protected boolean comparePatterns(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int getInvariantCount() {
        return this.invariantCount;
    }

    @Override
    public int getSiteCount() {
        return this.siteCount;
    }

    @Override
    public int[] getSitePattern(int n) {
        int n2 = this.sitePatternIndices[n];
        return n2 >= 0 ? this.patterns[n2] : null;
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        throw new UnsupportedOperationException("getUncertainSitePattern not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return this.sitePatternIndices[n];
    }

    @Override
    public int getState(int n, int n2) {
        int n3 = this.sitePatternIndices[n2];
        return n3 >= 0 ? this.patterns[n3][n] : this.getDataType().getGapState();
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainState not implemented yet");
    }

    @Override
    public int getPatternCount() {
        return this.patternCount;
    }

    @Override
    public int getStateCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.getTaxonCount();
    }

    @Override
    public int[] getPattern(int n) {
        return this.patterns[n];
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("getUncertainPattern not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.patterns[n2][n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        return this.uncertainPatterns[n2][n];
    }

    @Override
    public double getPatternWeight(int n) {
        return this.weights[n];
    }

    @Override
    public double[] getPatternWeights() {
        return this.weights;
    }

    @Override
    public DataType getDataType() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getDataType();
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return this.unique;
    }

    @Override
    public boolean areUncertain() {
        return this.uncertainSites;
    }

    @Override
    public int getTaxonCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < SitePatterns.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return SitePatterns.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String toXHTML() {
        int n;
        int n2;
        String string = "<p><em>Pattern List</em>  pattern count = ";
        string = string + this.getPatternCount();
        string = string + "  invariant count = ";
        string = string + this.getInvariantCount();
        string = string + "</p>";
        string = string + "<pre>";
        int n3 = this.getDataType().getType();
        int n4 = this.getPatternCount();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            if (n <= n5) continue;
            n5 = n;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n6;
            for (n6 = n = Integer.toString(n2 + 1).length(); n6 < n5; ++n6) {
                string = string + " ";
            }
            string = string + Integer.toString(n2 + 1) + ": ";
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            string = string + Integer.toString((int)this.getPatternWeight(n2));
            for (n6 = n; n6 <= n5; ++n6) {
                string = string + " ";
            }
            for (n6 = 0; n6 < this.getTaxonCount(); ++n6) {
                int n7 = this.getPatternState(n6, n2);
                string = n3 == 0 ? string + Nucleotides.INSTANCE.getChar(n7) + " " : (n3 == 2 ? string + Codons.UNIVERSAL.getTriplet(n7) + " " : string + AminoAcids.INSTANCE.getChar(n7) + " ");
            }
            string = string + "\n";
        }
        string = string + "</pre>";
        return string;
    }
}

