/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.statistics;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.vikamine.kernel.KernelResources;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.SGUtils;
import org.vikamine.kernel.subgroup.quality.functions.LiftQF;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.util.VKMUtil;

public abstract class StatisticComponent {
    DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    DecimalFormat simpleFormat = new DecimalFormat("#.###");
    public static final PopulationVariance POPULATION_VARIANCE = new PopulationVariance();
    public static final SubgroupVariance SUBGROUP_VARIANCE = new SubgroupVariance();
    public static final PopulationNormalizedMean POPULATION_NORMALIZED_MEAN = new PopulationNormalizedMean();
    public static final SubgroupNormalizedMean SUBGROUP_NORMALIZED_MEAN = new SubgroupNormalizedMean();
    public static final PopulationMean POPULATION_MEAN = new PopulationMean();
    public static final PopulationMedian POPULATION_MEDIAN = new PopulationMedian();
    public static final SubgroupMedian SUBGROUP_MEDIAN = new SubgroupMedian();
    public static final SubgroupMean SUBGROUP_MEAN = new SubgroupMean();
    public static final Specificity SPECIFICITY = new Specificity();
    public static final Significance SIGNIFICANCE = new Significance();
    public static final SignificanceStrength SIGNIFICANCE_STRENGTH = new SignificanceStrength();
    public static final Sensitivity SENSITIVITY = new Sensitivity();
    public static final ChiSquared CHI_SQUARED = new ChiSquared();
    public static final RelativeGain RELATIVE_GAIN = new RelativeGain();
    public static final Lift LIFT = new Lift();
    public static final Coverage COVERAGE = new Coverage();
    public static final TPRate TPRate = new TPRate();
    public static final P0 P_0 = new P0();
    public static final P P = new P();
    public static final FP FP = new FP();
    public static final TP TP = new TP();
    public static final SubgroupSize SUBGROUP_SIZE = new SubgroupSize();
    public static final PopulationSize POPULATION_SIZE = new PopulationSize();

    public static List<StatisticComponent> createAllStatisticComponents() {
        ArrayList<StatisticComponent> result = new ArrayList<StatisticComponent>();
        result.add(POPULATION_SIZE);
        result.add(SUBGROUP_SIZE);
        result.add(TP);
        result.add(FP);
        result.add(P);
        result.add(P_0);
        result.add(TPRate);
        result.add(COVERAGE);
        result.add(LIFT);
        result.add(RELATIVE_GAIN);
        result.add(CHI_SQUARED);
        result.add(SENSITIVITY);
        result.add(SIGNIFICANCE);
        result.add(SPECIFICITY);
        result.add(SUBGROUP_MEAN);
        result.add(POPULATION_MEAN);
        result.add(SUBGROUP_MEDIAN);
        result.add(POPULATION_MEDIAN);
        result.add(SUBGROUP_VARIANCE);
        result.add(POPULATION_VARIANCE);
        return result;
    }

    public static List<StatisticComponent> getAllComponentsValidForAtLeastOneTarget(List<SGTarget> targets) {
        return StatisticComponent.removeAllInvalidComponentsForTargetList(StatisticComponent.createAllStatisticComponents(), targets);
    }

    public static List<StatisticComponent> getAllValidComponents(SGTarget target) {
        return StatisticComponent.removeAllInvalidComponentsForTargetList(StatisticComponent.createAllStatisticComponents(), Collections.singletonList(target));
    }

    public static List<StatisticComponent> getAllAlwaysValidComponents() {
        return StatisticComponent.removeAllInvalidComponentsForTargetList(StatisticComponent.createAllStatisticComponents(), Collections.EMPTY_LIST);
    }

    public static List<StatisticComponent> removeAllInvalidComponentsForTargetList(List<StatisticComponent> statComponents, List<SGTarget> targets) {
        Iterator<StatisticComponent> it = statComponents.iterator();
        while (it.hasNext()) {
            StatisticComponent stc = it.next();
            boolean isValidForAtLeastOneTarget = false;
            if (stc.isAlwaysValid()) {
                isValidForAtLeastOneTarget = true;
            } else {
                for (SGTarget target : targets) {
                    if (!stc.isValid(target)) continue;
                    isValidForAtLeastOneTarget = true;
                    break;
                }
            }
            if (isValidForAtLeastOneTarget) continue;
            it.remove();
        }
        return statComponents;
    }

    protected boolean isAlwaysValid() {
        return false;
    }

    private static String toPercentString(double d) {
        String percentage = String.valueOf(VKMUtil.getFormattedDoubleStringDependingOnLocale(Locale.getDefault(), d * 100.0, 1)) + "%";
        return d < 0.1 && !percentage.startsWith("0") ? "0" + percentage : percentage;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getClass() == o.getClass();
    }

    public abstract String getDescription();

    public abstract Object getValue(SGStatistics var1);

    public String getValueString(SGStatistics stats) {
        Object statsValue = this.getValue(stats);
        if (statsValue instanceof Double && Double.isNaN((Double)statsValue)) {
            statsValue = "-";
        }
        if (statsValue instanceof Double) {
            double absValue = Math.abs((Double)statsValue);
            if (absValue < 1.0E-5 || absValue > 100000.0) {
                return this.scientificFormat.format(statsValue);
            }
            return this.simpleFormat.format(statsValue);
        }
        return String.valueOf(statsValue);
    }

    public int hashCode() {
        assert (false);
        return 42;
    }

    public abstract boolean isValid(SGTarget var1);

    public String toString() {
        return this.getDescription();
    }

    public static class ChiSquared
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.chi2");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return SGUtils.calculateChi2OfSubgroup((SGStatisticsBinary)stats);
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class Coverage
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.subgroupShare/DataView");
        }

        @Override
        public String getValue(SGStatistics stats) {
            return StatisticComponent.toPercentString(stats.getSubgroupShareOfPopulation());
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class FP
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.fp");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return ((SGStatisticsBinary)stats).getFp();
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class Lift
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.lift");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsBinary) {
                SGStatisticsBinary binary = (SGStatisticsBinary)stats;
                return binary.getP() / binary.getP0();
            }
            if (stats instanceof SGStatisticsNumeric) {
                SGStatisticsNumeric numeric = (SGStatisticsNumeric)stats;
                return LiftQF.computeLiftNumeric(numeric.getSGMean(), numeric.getPopulationMean());
            }
            throw new IllegalStateException("Unknown SGStatistics!" + stats);
        }

        @Override
        public String getValueString(SGStatistics stats) {
            double val = this.getValue(stats);
            return VKMUtil.getFormattedDoubleString(val, 2);
        }

        @Override
        public boolean isValid(SGTarget target) {
            return target != null;
        }
    }

    public static class P
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.p");
        }

        @Override
        public Object getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return StatisticComponent.toPercentString(((SGStatisticsBinary)stats).getP());
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class P0
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.p0");
        }

        @Override
        public Object getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return StatisticComponent.toPercentString(((SGStatisticsBinary)stats).getP0());
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class PopulationMean
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.populationMeanValue");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getPopulationMean();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class PopulationMedian
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.populationMedian");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getPopulationMedian();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class PopulationNormalizedMean
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.populationNormalizedMeanValue");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getPopulationNormalizedMean();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class PopulationSize
    extends StatisticComponent {
        private PopulationSize() {
        }

        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.populationSize");
        }

        @Override
        public Integer getValue(SGStatistics stats) {
            return (int)Math.round(stats.getDefinedPopulationCount());
        }

        @Override
        public boolean isValid(SGTarget target) {
            return true;
        }

        @Override
        protected boolean isAlwaysValid() {
            return true;
        }
    }

    public static class PopulationVariance
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.populationVariance");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getPopulationVariance();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class RelativeGain
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.relativeGain");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsBinary) {
                double p = ((SGStatisticsBinary)stats).getP();
                double p0 = ((SGStatisticsBinary)stats).getP0();
                if (p0 == 1.0) {
                    return p == 1.0 ? 0.0 : Double.NEGATIVE_INFINITY;
                }
                return (p - p0) / ((1.0 - p0) * p0);
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            return target != null;
        }
    }

    public static class Sensitivity
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.sensitivity");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return ((SGStatisticsBinary)stats).getTp() / ((SGStatisticsBinary)stats).getPositives();
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class Significance
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.significance");
        }

        @Override
        public Object getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            double chi2Value = SGUtils.calculateChi2OfSubgroup((SGStatisticsBinary)stats);
            double significance = SGUtils.calculateChi2SignificanceNiveau(chi2Value, 1);
            String formattedSignificance = "";
            if (significance > 0.0) {
                formattedSignificance = SGUtils.toDiscretizedChi2SignificanceLevel(significance);
                if (significance != 1.0) {
                    formattedSignificance = String.valueOf(formattedSignificance) + " (" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(significance, 3) + ")";
                }
            } else {
                formattedSignificance = SGUtils.toDiscretizedChi2SignificanceLevel(significance);
            }
            return formattedSignificance;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class SignificanceStrength
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.significanceStrength");
        }

        @Override
        public Object getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            double chi2Value = SGUtils.calculateChi2OfSubgroup((SGStatisticsBinary)stats);
            double significance = SGUtils.calculateChi2SignificanceNiveau(chi2Value, 1);
            double signifStrength = Math.log10(1.0 / significance);
            return new DecimalFormat("#.#").format(signifStrength);
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class Specificity
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.specificity");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return ((SGStatisticsBinary)stats).getTn() / ((SGStatisticsBinary)stats).getNegatives();
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class StatisticComponentSubgroupComparator
    implements Comparator<SG> {
        StatisticComponent compStatComponent;

        public StatisticComponentSubgroupComparator(StatisticComponent statComponent) {
            this.compStatComponent = statComponent;
        }

        @Override
        public int compare(SG o1, SG o2) {
            Object value1 = this.compStatComponent.getValue(o1.getStatistics());
            Object value2 = this.compStatComponent.getValue(o2.getStatistics());
            if (value1 instanceof Double && value2 instanceof Double) {
                return Double.compare((Double)value1, (Double)value2);
            }
            if (value1 instanceof Integer && value2 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof String && value2 instanceof String) {
                return ((String)value1).compareTo((String)value2);
            }
            return 0;
        }
    }

    public static class SubgroupMean
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.sgMeanValue");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getSGMean();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class SubgroupMedian
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.sgMedian");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getSGMedian();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class SubgroupNormalizedMean
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.sgNormalizedMeanValue");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getSGNormalizedMean();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class SubgroupSize
    extends StatisticComponent {
        private SubgroupSize() {
        }

        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.subgroupSize");
        }

        @Override
        public Integer getValue(SGStatistics stats) {
            return (int)Math.round(stats.getSubgroupSize());
        }

        @Override
        public boolean isValid(SGTarget target) {
            return true;
        }

        @Override
        protected boolean isAlwaysValid() {
            return true;
        }
    }

    public static class SubgroupVariance
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.sgVariance");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (stats instanceof SGStatisticsNumeric) {
                return ((SGStatisticsNumeric)stats).getSGVariance();
            }
            return Double.NaN;
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isNumeric();
        }
    }

    public static class TP
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.tp");
        }

        @Override
        public Double getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return ((SGStatisticsBinary)stats).getTp();
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }

    public static class TPRate
    extends StatisticComponent {
        @Override
        public String getDescription() {
            return KernelResources.getInstance().getI18N().getString("vkmkernel.verbalization.subgroupStatInfoParameters.tpRate");
        }

        @Override
        public Object getValue(SGStatistics stats) {
            if (!(stats instanceof SGStatisticsBinary)) {
                return Double.NaN;
            }
            return StatisticComponent.toPercentString(((SGStatisticsBinary)stats).getSubgroupShareOfPositives());
        }

        @Override
        public boolean isValid(SGTarget target) {
            if (target == null) {
                return false;
            }
            return target.isBoolean();
        }
    }
}

