/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class GraphFactory {
    public static UndirectedGraph makeStoredUndirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType) {
        return new UndirectedGraph(model, n, nodeSetType, edgeSetType, false);
    }

    public static DirectedGraph makeStoredDirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType) {
        return new DirectedGraph(model, n, nodeSetType, edgeSetType, false);
    }

    public static UndirectedGraph makeStoredAllNodesUndirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        UndirectedGraph g = new UndirectedGraph(model, n, nodeSetType, edgeSetType, allNodesFixed);
        if (!allNodesFixed) {
            for (int i = 0; i < n; ++i) {
                g.addNode(i);
            }
        }
        return g;
    }

    public static DirectedGraph makeStoredAllNodesDirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        DirectedGraph g = new DirectedGraph(model, n, nodeSetType, edgeSetType, allNodesFixed);
        if (!allNodesFixed) {
            for (int i = 0; i < n; ++i) {
                g.addNode(i);
            }
        }
        return g;
    }

    public static UndirectedGraph makeCompleteStoredUndirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        UndirectedGraph g = GraphFactory.makeStoredAllNodesUndirectedGraph(model, n, nodeSetType, edgeSetType, allNodesFixed);
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                g.addEdge(i, j);
            }
        }
        return g;
    }

    public static DirectedGraph makeCompleteStoredDirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        int i;
        DirectedGraph g = GraphFactory.makeStoredAllNodesDirectedGraph(model, n, nodeSetType, edgeSetType, allNodesFixed);
        if (!allNodesFixed) {
            for (i = 0; i < n; ++i) {
                g.addNode(i);
            }
        }
        for (i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                g.addEdge(i, j);
                g.addEdge(j, i);
            }
        }
        return g;
    }

    public static UndirectedGraph makeStoredUndirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, int[] nodes, int[][] edges) {
        UndirectedGraph g = GraphFactory.makeStoredUndirectedGraph(model, n, nodeSetType, edgeSetType);
        for (int i : nodes) {
            g.addNode(i);
        }
        for (int[] e : edges) {
            assert (e.length == 2);
            g.addEdge(e[0], e[1]);
        }
        return g;
    }

    public static UndirectedGraph makeStoredUndirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, int[] nodes, boolean[][] adjacencyMatrix) {
        UndirectedGraph g = GraphFactory.makeStoredUndirectedGraph(model, n, nodeSetType, edgeSetType);
        for (int i : nodes) {
            g.addNode(i);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (!adjacencyMatrix[i][j]) continue;
                g.addEdge(i, j);
            }
        }
        return g;
    }

    public static DirectedGraph makeStoredDirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, int[] nodes, int[][] edges) {
        DirectedGraph g = GraphFactory.makeStoredDirectedGraph(model, n, nodeSetType, edgeSetType);
        for (int i : nodes) {
            g.addNode(i);
        }
        for (int[] e : edges) {
            assert (e.length == 2);
            g.addEdge(e[0], e[1]);
        }
        return g;
    }

    public static DirectedGraph makeStoredDirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, int[] nodes, boolean[][] adjacencyMatrix) {
        DirectedGraph g = GraphFactory.makeStoredDirectedGraph(model, n, nodeSetType, edgeSetType);
        for (int i : nodes) {
            g.addNode(i);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!adjacencyMatrix[i][j]) continue;
                g.addEdge(i, j);
            }
        }
        return g;
    }

    public static UndirectedGraph generateRandomUndirectedGraphFromNbCC(Model model, int n, SetType nodeSetType, SetType edgeSetType, int nbCC, double density, int maxSizeCC) {
        assert (nbCC <= n);
        int remaining = n;
        int next_node = 0;
        boolean[][] edges = new boolean[n][n];
        for (int cc = 0; cc < nbCC; ++cc) {
            int size = ThreadLocalRandom.current().nextInt(1, Math.min(remaining - nbCC + cc + 1, maxSizeCC));
            remaining -= size;
            boolean[][] adj = GraphFactory.generateRandomUndirectedAdjacencyMatrix(size, density);
            for (int i = 0; i < size; ++i) {
                for (int j = i; j < size; ++j) {
                    edges[i + next_node][j + next_node] = adj[i][j];
                }
            }
            next_node += size;
        }
        next_node = next_node == 0 ? 1 : next_node;
        return GraphFactory.makeStoredUndirectedGraph(model, n, nodeSetType, edgeSetType, IntStream.range(0, next_node).toArray(), edges);
    }

    public static UndirectedGraph makeUndirectedGraph(int n, SetType nodeSetType, SetType edgeSetType) {
        return new UndirectedGraph(n, nodeSetType, edgeSetType, false);
    }

    public static DirectedGraph makeDirectedGraph(int n, SetType nodeSetType, SetType edgeSetType) {
        return new DirectedGraph(n, nodeSetType, edgeSetType, false);
    }

    public static UndirectedGraph makeAllNodesUndirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        UndirectedGraph g = new UndirectedGraph(n, nodeSetType, edgeSetType, allNodesFixed);
        if (!allNodesFixed) {
            for (int i = 0; i < n; ++i) {
                g.addNode(i);
            }
        }
        return g;
    }

    public static DirectedGraph makeAllNodesDirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        DirectedGraph g = new DirectedGraph(n, nodeSetType, edgeSetType, allNodesFixed);
        if (!allNodesFixed) {
            for (int i = 0; i < n; ++i) {
                g.addNode(i);
            }
        }
        return g;
    }

    public static UndirectedGraph makeCompleteUndirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        UndirectedGraph g = GraphFactory.makeAllNodesUndirectedGraph(n, nodeSetType, edgeSetType, allNodesFixed);
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                g.addEdge(i, j);
            }
        }
        return g;
    }

    public static DirectedGraph makeCompleteDirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, boolean allNodesFixed) {
        int i;
        DirectedGraph g = GraphFactory.makeAllNodesDirectedGraph(n, nodeSetType, edgeSetType, allNodesFixed);
        if (!allNodesFixed) {
            for (i = 0; i < n; ++i) {
                g.addNode(i);
            }
        }
        for (i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                g.addEdge(i, j);
                g.addEdge(j, i);
            }
        }
        return g;
    }

    public static UndirectedGraph makeUndirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, int[] nodes, int[][] edges) {
        UndirectedGraph g = GraphFactory.makeUndirectedGraph(n, nodeSetType, edgeSetType);
        for (int i : nodes) {
            g.addNode(i);
        }
        for (int[] e : edges) {
            assert (e.length == 2);
            g.addEdge(e[0], e[1]);
        }
        return g;
    }

    public static DirectedGraph makeDirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, int[] nodes, int[][] edges) {
        DirectedGraph g = GraphFactory.makeDirectedGraph(n, nodeSetType, edgeSetType);
        for (int i : nodes) {
            g.addNode(i);
        }
        for (int[] e : edges) {
            assert (e.length == 2);
            g.addEdge(e[0], e[1]);
        }
        return g;
    }

    public static UndirectedGraph makeNodeInducedSubgraph(Model model, UndirectedGraph graph, ISet nodes, boolean exclude) {
        return new UndirectedGraph(model, graph, nodes, exclude);
    }

    public static UndirectedGraph makeNodeInducedSubgraph(Model model, UndirectedGraph graph, UndirectedGraph UB, ISet nodes, boolean exclude) {
        return new UndirectedGraph(model, graph, UB, nodes, exclude);
    }

    public static DirectedGraph makeNodeInducedSubgraph(Model model, DirectedGraph graph, ISet nodes, boolean exclude) {
        return new DirectedGraph(model, graph, nodes, exclude);
    }

    public static DirectedGraph makeNodeInducedSubgraph(Model model, DirectedGraph graph, DirectedGraph UB, ISet nodes, boolean exclude) {
        return new DirectedGraph(model, graph, UB, nodes, exclude);
    }

    public static UndirectedGraph makeEdgeInducedSubgraph(Model model, UndirectedGraph graph, int[][] edges, boolean exclude) {
        return new UndirectedGraph(model, graph, edges, exclude);
    }

    public static UndirectedGraph makeEdgeInducedSubgraph(Model model, UndirectedGraph graph, UndirectedGraph UB, int[][] edges, boolean exclude) {
        return new UndirectedGraph(model, graph, UB, edges, exclude);
    }

    public static DirectedGraph makeEdgeInducedSubgraph(Model model, DirectedGraph graph, int[][] edges, boolean exclude) {
        return new DirectedGraph(model, graph, edges, exclude);
    }

    public static DirectedGraph makeEdgeInducedSubgraph(Model model, DirectedGraph graph, DirectedGraph UB, int[][] edges, boolean exclude) {
        return new DirectedGraph(model, graph, UB, edges, exclude);
    }

    public static UndirectedGraph makeUnionGraph(Model model, UndirectedGraph ... graphs) {
        return new UndirectedGraph(model, graphs);
    }

    public static DirectedGraph makeUnionGraph(Model model, DirectedGraph ... graphs) {
        return new DirectedGraph(model, graphs);
    }

    public static boolean[][] generateRandomUndirectedAdjacencyMatrix(int n, double density) {
        assert (density >= 0.0 && density <= 1.0);
        int[] nodes = IntStream.range(0, n).toArray();
        boolean[][] edges = new boolean[n][n];
        for (int i : nodes) {
            for (int j : nodes) {
                double r = Math.random();
                if (!(r < density)) continue;
                edges[i][j] = true;
                edges[j][i] = true;
            }
        }
        return edges;
    }
}

