/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.languagemodel;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.languagemodel.LanguageModel;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.ngram.NGramUtils;
import opennlp.tools.util.StringList;

public class NGramLanguageModel
extends NGramModel
implements LanguageModel {
    private static final int DEFAULT_N = 3;
    private final int n;

    public NGramLanguageModel() {
        this(3);
    }

    public NGramLanguageModel(int n) {
        this.n = n;
    }

    public NGramLanguageModel(InputStream in) throws IOException {
        this(in, 3);
    }

    public NGramLanguageModel(InputStream in, int n) throws IOException {
        super(in);
        this.n = n;
    }

    @Override
    public double calculateProbability(StringList sample) {
        double probability = 0.0;
        if (this.size() > 0) {
            for (StringList ngram : NGramUtils.getNGrams(sample, this.n)) {
                double score = this.stupidBackoff(ngram);
                if (!Double.isNaN(probability += Math.log(score))) continue;
                probability = 0.0;
            }
            probability = Math.exp(probability);
        }
        return probability;
    }

    @Override
    public StringList predictNextTokens(StringList tokens) {
        double maxProb = Double.NEGATIVE_INFINITY;
        StringList token = null;
        for (StringList ngram : this) {
            int i;
            String[] sequence = new String[ngram.size() + tokens.size()];
            for (i = 0; i < tokens.size(); ++i) {
                sequence[i] = tokens.getToken(i);
            }
            for (i = 0; i < ngram.size(); ++i) {
                sequence[i + tokens.size()] = ngram.getToken(i);
            }
            StringList sample = new StringList(sequence);
            double v = this.calculateProbability(sample);
            if (!(v > maxProb)) continue;
            maxProb = v;
            token = ngram;
        }
        return token;
    }

    private double stupidBackoff(StringList ngram) {
        int count = this.getCount(ngram);
        StringList nMinusOneToken = NGramUtils.getNMinusOneTokenFirst(ngram);
        if (nMinusOneToken == null || nMinusOneToken.size() == 0) {
            return (double)count / (double)this.size();
        }
        if (count > 0) {
            double countM1 = this.getCount(nMinusOneToken);
            if (countM1 == 0.0) {
                countM1 = this.size();
            }
            return (double)count / countM1;
        }
        return 0.4 * this.stupidBackoff(NGramUtils.getNMinusOneTokenLast(ngram));
    }
}

