/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes;

import fr.inria.optimization.cmaes.CMAOptions;
import fr.inria.optimization.cmaes.CMAParameters;
import fr.inria.optimization.cmaes.CMASolution;
import fr.inria.optimization.cmaes.ISolutionPoint;
import fr.inria.optimization.cmaes.IntDouble;
import fr.inria.optimization.cmaes.PrintfFormat;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;

public class CMAEvolutionStrategy
implements Serializable {
    private static final long serialVersionUID = 2918241407634253526L;
    public final String versionNumber = new String("0.99.40");
    public CMAOptions options = new CMAOptions();
    private CMAParameters sp;
    public CMAParameters parameters = this.sp = new CMAParameters();
    public StopCondition stopConditions = new StopCondition();
    int N;
    long seed = System.currentTimeMillis();
    Random rand = new Random(this.seed);
    final MyMath math = new MyMath();
    double axisratio;
    long counteval;
    long countiter;
    long bestever_eval;
    double[] bestever_x;
    double bestever_fit = Double.NaN;
    double sigma = 0.0;
    double[] typicalX;
    double[] initialX;
    double[] LBound;
    double[] UBound;
    double[] xmean;
    double xmean_fit = Double.NaN;
    double[] pc;
    double[] ps;
    double[][] C;
    double maxsqrtdiagC;
    double minsqrtdiagC;
    double[][] B;
    double[] diagD;
    boolean flgdiag;
    double[] startsigma;
    double maxstartsigma;
    double minstartsigma;
    boolean iniphase;
    double state = -1.0;
    long citerlastwritten = 0L;
    long countwritten = 0L;
    int lockDimension = 0;
    int mode = 0;
    final int SINGLE_MODE = 1;
    final int PARALLEL_MODE = 2;
    long countCupdatesSinceEigenupdate;
    protected FitnessCollector fit = new FitnessCollector();
    double recentFunctionValue;
    double recentMaxFunctionValue;
    double recentMinFunctionValue;
    int idxRecentOffspring;
    double[][] arx;
    public double[][] population;
    double[] xold;
    double[] BDz;
    double[] artmp;
    String propertiesFileName = new String("CMAEvolutionStrategy.properties");
    Properties properties = new Properties();
    Timing timings = new Timing();
    private String[] fileswritten = new String[]{""};

    void testAndCorrectNumerics() {
        if ((this.getCountIter() > 1L || this.getCountIter() == 1L && this.state >= 3.0) && this.fit.fitness[0].val == this.fit.fitness[Math.min((int)(this.sp.getLambda() - 1), (int)(this.sp.getLambda() / 2 + 1)) - 1].val) {
            this.warning("flat fitness landscape, consider reformulation of fitness, step-size increased");
            this.sigma *= Math.exp(0.2 + this.sp.getCs() / this.sp.getDamps());
        }
        double fac = 1.0;
        if (this.math.max(this.diagD) < 1.0E-6) {
            fac = 1.0 / this.math.max(this.diagD);
        } else if (this.math.min(this.diagD) > 10000.0) {
            fac = 1.0 / this.math.min(this.diagD);
        }
        if (fac != 1.0) {
            this.sigma /= fac;
            int i = 0;
            while (i < this.N) {
                int n = i;
                this.pc[n] = this.pc[n] * fac;
                int n2 = i;
                this.diagD[n2] = this.diagD[n2] * fac;
                int j = 0;
                while (j <= i) {
                    double[] dArray = this.C[i];
                    int n3 = j++;
                    dArray[n3] = dArray[n3] * (fac * fac);
                }
                ++i;
            }
        }
    }

    public int getStopConditionNumber() {
        return this.stopConditions.getNumber();
    }

    public String[] getStopConditionMessages() {
        return this.stopConditions.getMessages();
    }

    public void setOptionsStopMaxFunEvals(long s) {
        this.options.stopMaxFunEvals = s;
    }

    public void setOptionsStopTolFun(double d) {
        this.options.stopTolFun = d;
    }

    public void setOptionsStopFitness(double d) {
        this.options.stopFitness = d;
    }

    public double getState() {
        return this.state;
    }

    public int getPopulationSize() {
        return this.sp.getPopulationSize();
    }

    public void setPopulationSize(int p) {
        this.sp.setPopulationSize(p);
    }

    public CMAEvolutionStrategy() {
        this.state = -1.0;
    }

    public CMAEvolutionStrategy(Properties properties) {
        this.setFromProperties(properties);
        this.state = -1.0;
    }

    public CMAEvolutionStrategy(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
        this.state = -1.0;
    }

    public CMAEvolutionStrategy(int dimension) {
        this.setDimension(dimension);
        this.state = -1.0;
    }

    public double[] init(int dimension, double[] initialX, double[] initialStandardDeviations) {
        this.setInitialX(initialX);
        this.setInitialStandardDeviations(initialStandardDeviations);
        return this.init(dimension);
    }

    private double[] getArrayOf(double x, int dim) {
        double[] res = new double[dim];
        int i = 0;
        while (i < dim) {
            res[i] = x;
            ++i;
        }
        return res;
    }

    private double[] expandToDimension(double[] x, int dim) {
        if (x == null) {
            return null;
        }
        if (x.length == dim) {
            return x;
        }
        if (x.length != 1) {
            this.error("x must have length one or length dimension");
        }
        return this.getArrayOf(x[0], dim);
    }

    public double[] init(int dimension) {
        this.setDimension(dimension);
        return this.init();
    }

    public double[] init() {
        if (this.N <= 0) {
            this.error("dimension needs to be determined, use eg. setDimension() or setInitialX()");
        }
        if (this.state >= 0.0) {
            this.error("init() cannot be called twice");
        }
        if (this.state == 0.0) {
            return new double[this.sp.getLambda()];
        }
        if (this.state > 0.0) {
            this.error("init() cannot be called after the first population was sampled");
        }
        this.sp = this.parameters;
        if (this.sp.supplemented == 0) {
            this.sp.supplementRemainders(this.N, this.options);
        }
        this.sp.locked = 1;
        this.diagD = new double[this.N];
        int i = 0;
        while (i < this.N) {
            this.diagD[i] = 1.0;
            ++i;
        }
        this.LBound = this.expandToDimension(this.LBound, this.N);
        if (this.LBound == null) {
            this.LBound = new double[this.N];
            i = 0;
            while (i < this.N) {
                this.LBound[i] = Double.NEGATIVE_INFINITY;
                ++i;
            }
        }
        this.UBound = this.expandToDimension(this.UBound, this.N);
        if (this.UBound == null) {
            this.UBound = new double[this.N];
            i = 0;
            while (i < this.N) {
                this.UBound[i] = Double.POSITIVE_INFINITY;
                ++i;
            }
        }
        if (this.startsigma != null) {
            if (this.startsigma.length == 1) {
                this.sigma = this.startsigma[0];
            } else if (this.startsigma.length == this.N) {
                this.sigma = this.math.max(this.startsigma);
                if (this.sigma <= 0.0) {
                    this.error("initial standard deviation sigma must be positive");
                }
                i = 0;
                while (i < this.N) {
                    this.diagD[i] = this.startsigma[i] / this.sigma;
                    ++i;
                }
            } else assert (false);
        } else {
            this.error("no initial standard deviation specified, use setInitialStandardDeviations()");
            this.sigma = 0.5;
        }
        if (this.sigma <= 0.0 || this.math.min(this.diagD) <= 0.0) {
            this.error("initial standard deviations not specified or non-positive, use setInitialStandarddeviations()");
            this.sigma = 1.0;
        }
        if (this.startsigma == null || this.startsigma.length == 1) {
            this.startsigma = new double[this.N];
            i = 0;
            while (i < this.N) {
                this.startsigma[i] = this.sigma * this.diagD[i];
                ++i;
            }
        }
        this.maxstartsigma = this.math.max(this.startsigma);
        this.minstartsigma = this.math.min(this.startsigma);
        this.axisratio = this.maxstartsigma / this.minstartsigma;
        this.typicalX = this.expandToDimension(this.typicalX, this.N);
        this.xmean = this.expandToDimension(this.xmean, this.N);
        if (this.xmean == null) {
            if (this.typicalX != null) {
                this.xmean = (double[])this.typicalX.clone();
                i = 0;
                while (i < this.N) {
                    int n = i;
                    this.xmean[n] = this.xmean[n] + this.sigma * this.diagD[i] * this.rand.nextGaussian();
                    ++i;
                }
            } else if (this.math.max(this.UBound) < Double.MAX_VALUE && this.math.min(this.LBound) > -1.7976931348623157E308) {
                this.error("no initial search point (solution) X or typical X specified");
                this.xmean = new double[this.N];
                i = 0;
                while (i < this.N) {
                    double offset = this.sigma * this.diagD[i];
                    double range = this.UBound[i] - this.LBound[i] - 2.0 * this.sigma * this.diagD[i];
                    if (offset > 0.4 * (this.UBound[i] - this.LBound[i])) {
                        offset = 0.4 * (this.UBound[i] - this.LBound[i]);
                        range = 0.2 * (this.UBound[i] - this.LBound[i]);
                    }
                    this.xmean[i] = this.LBound[i] + offset + this.rand.nextDouble() * range;
                    ++i;
                }
            } else {
                this.error("no initial search point (solution) X or typical X specified");
                this.xmean = new double[this.N];
                i = 0;
                while (i < this.N) {
                    this.xmean[i] = this.rand.nextDouble();
                    ++i;
                }
            }
        }
        assert (this.xmean != null);
        assert (this.sigma > 0.0);
        if (this.options.diagonalCovarianceMatrix < 0L) {
            this.options.diagonalCovarianceMatrix = 150 * this.N / this.sp.lambda;
        }
        this.pc = new double[this.N];
        this.ps = new double[this.N];
        this.B = new double[this.N][this.N];
        this.C = new double[this.N][this.N];
        this.xold = new double[this.N];
        this.BDz = new double[this.N];
        this.bestever_x = (double[])this.xmean.clone();
        this.artmp = new double[this.N];
        this.fit.deltaFitHist = new double[5];
        this.fit.idxDeltaFitHist = -1;
        i = 0;
        while (i < this.fit.deltaFitHist.length) {
            this.fit.deltaFitHist[i] = 1.0;
            ++i;
        }
        this.fit.fitness = new IntDouble[this.sp.getLambda()];
        this.fit.raw = new IntDouble[this.sp.getLambda()];
        this.fit.history = new double[10 + 30 * this.N / this.sp.getLambda()];
        this.arx = new double[this.sp.getLambda()][this.N];
        this.population = new double[this.sp.getLambda()][this.N];
        i = 0;
        while (i < this.sp.getLambda()) {
            this.fit.fitness[i] = new IntDouble();
            this.fit.raw[i] = new IntDouble();
            ++i;
        }
        i = 0;
        while (i < this.N) {
            this.pc[i] = 0.0;
            this.ps[i] = 0.0;
            int j = 0;
            while (j < this.N) {
                this.B[i][j] = 0.0;
                ++j;
            }
            j = 0;
            while (j < i) {
                this.C[i][j] = 0.0;
                ++j;
            }
            this.B[i][i] = 1.0;
            this.C[i][i] = this.diagD[i] * this.diagD[i];
            ++i;
        }
        this.maxsqrtdiagC = Math.sqrt(this.math.max(this.math.diag(this.C)));
        this.minsqrtdiagC = Math.sqrt(this.math.min(this.math.diag(this.C)));
        this.countCupdatesSinceEigenupdate = 0L;
        this.iniphase = false;
        i = 0;
        while (i < this.N) {
            if (this.LBound[i] > this.UBound[i]) {
                this.error("lower bound is greater than upper bound");
            }
            if (this.typicalX != null) {
                if (this.LBound[i] > this.typicalX[i]) {
                    this.error("lower bound '" + this.LBound[i] + "'is greater than typicalX" + this.typicalX[i]);
                }
                if (this.UBound[i] < this.typicalX[i]) {
                    this.error("upper bound '" + this.UBound[i] + "' is smaller than typicalX " + this.typicalX[i]);
                }
            }
            ++i;
        }
        String[] s = this.stopConditions.getMessages();
        if (!s[0].equals("")) {
            this.warning("termination condition satisfied at initialization: \n  " + s[0]);
        }
        this.initialX = (double[])this.xmean.clone();
        this.timings.start = System.currentTimeMillis();
        this.timings.starteigen = System.currentTimeMillis();
        this.state = 0.0;
        if (this.options.verbosity > -1) {
            this.printlnHelloWorld();
        }
        return new double[this.sp.getLambda()];
    }

    public CMAParameters getParameterDefaults() {
        return this.sp.getDefaults(this.N);
    }

    public CMAParameters getParameterDefaults(int N) {
        return this.sp.getDefaults(N);
    }

    public Properties readProperties() {
        return this.readProperties(this.propertiesFileName);
    }

    public Properties readProperties(String fileName) {
        this.propertiesFileName = fileName;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            this.warning("File '" + fileName + "' not found, no options read");
        }
        this.setFromProperties(this.properties);
        return this.properties;
    }

    public void setFromProperties(Properties properties) {
        this.options.setOptions(properties);
        if (this.state >= 0.0) {
            return;
        }
        String s = properties.getProperty("typicalX");
        if (s != null) {
            this.setTypicalX(this.options.parseDouble(this.options.getAllToken(s)));
        }
        if ((s = properties.getProperty("initialX")) != null) {
            this.setInitialX(this.options.parseDouble(this.options.getAllToken(s)));
        }
        if ((s = properties.getProperty("initialStandardDeviations")) != null) {
            this.setInitialStandardDeviations(this.options.parseDouble(this.options.getAllToken(s)));
        }
        if ((s = properties.getProperty("dimension")) != null) {
            this.setDimension(Integer.parseInt(this.options.getFirstToken(s)));
        }
        if ((s = properties.getProperty("randomSeed")) != null) {
            this.setSeed(Long.parseLong(this.options.getFirstToken(s)));
        }
        if ((s = properties.getProperty("populationSize")) != null) {
            this.sp.setPopulationSize(Integer.parseInt(this.options.getFirstToken(s)));
        }
        if ((s = properties.getProperty("cCov")) != null) {
            this.sp.setCcov(Double.parseDouble(this.options.getFirstToken(s)));
        }
    }

    private void warning(String s) {
        this.println(" CMA-ES warning: " + s);
    }

    private void error(String s) {
        this.println(" CMA-ES error: " + s);
        throw new CMAException(" CMA-ES error: " + s);
    }

    void eigendecomposition(int flgforce) {
        if (this.countCupdatesSinceEigenupdate == 0L && flgforce < 2) {
            return;
        }
        if (!this.flgdiag && flgforce <= 0 && ((double)this.timings.eigendecomposition > 1000.0 + this.options.maxTimeFractionForEigendecomposition * (double)(System.currentTimeMillis() - this.timings.starteigen) || (double)this.countCupdatesSinceEigenupdate < 1.0 / this.sp.getCcov() / (double)this.N / 5.0)) {
            return;
        }
        if (this.flgdiag) {
            int i = 0;
            while (i < this.N) {
                this.diagD[i] = Math.sqrt(this.C[i][i]);
                ++i;
            }
            this.countCupdatesSinceEigenupdate = 0L;
            this.timings.starteigen = System.currentTimeMillis();
            this.timings.eigendecomposition = 0L;
        } else {
            int i = 0;
            while (i < this.N) {
                int j = 0;
                while (j <= i) {
                    double d = this.C[i][j];
                    this.B[j][i] = d;
                    this.B[i][j] = d;
                    ++j;
                }
                ++i;
            }
            double[] offdiag = new double[this.N];
            long firsttime = System.currentTimeMillis();
            this.tred2(this.N, this.B, this.diagD, offdiag);
            this.tql2(this.N, this.diagD, offdiag, this.B);
            this.timings.eigendecomposition += System.currentTimeMillis() - firsttime;
            if (this.options.checkEigenSystem > 0) {
                this.checkEigenSystem(this.N, this.C, this.diagD, this.B);
            }
            i = 0;
            while (i < this.N) {
                if (this.diagD[i] < 0.0) {
                    this.error("an eigenvalue has become negative");
                }
                this.diagD[i] = Math.sqrt(this.diagD[i]);
                ++i;
            }
            this.countCupdatesSinceEigenupdate = 0L;
        }
        this.axisratio = this.math.min(this.diagD) == 0.0 ? Double.POSITIVE_INFINITY : this.math.max(this.diagD) / this.math.min(this.diagD);
    }

    int checkEigenSystem(int N, double[][] C, double[] diag, double[][] Q) {
        int res = 0;
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < N) {
                String s;
                double cc = 0.0;
                double dd = 0.0;
                int k = 0;
                while (k < N) {
                    cc += diag[k] * Q[i][k] * Q[j][k];
                    dd += Q[i][k] * Q[j][k];
                    ++k;
                }
                double[] dArray = C[i > j ? i : j];
                int n = i > j ? j : i;
                if (Math.abs(cc - dArray[n]) / Math.sqrt(C[i][i] * C[j][j]) > 1.0E-10) {
                    double[] dArray2 = C[i > j ? i : j];
                    int n2 = i > j ? j : i;
                    if (Math.abs(cc - dArray2[n2]) > 1.0E-9) {
                        s = " " + i + " " + j + " " + cc + " " + C[i > j ? i : j][i > j ? j : i] + " " + (cc - C[i > j ? i : j][i > j ? j : i]);
                        this.warning("cmaes_t:Eigen(): imprecise result detected " + s);
                        ++res;
                    }
                }
                boolean bl = i == j;
                if (Math.abs(dd - (double)bl) > 1.0E-10) {
                    s = String.valueOf(i) + " " + j + " " + dd;
                    this.warning("cmaes_t:Eigen(): imprecise result detected (Q not orthog.) " + s);
                    ++res;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private void tred2(int n, double[][] V, double[] d, double[] e) {
        int j = 0;
        while (j < n) {
            d[j] = V[n - 1][j];
            ++j;
        }
        int i = n - 1;
        while (i > 0) {
            double scale = 0.0;
            double h = 0.0;
            int k = 0;
            while (k < i) {
                scale += Math.abs(d[k]);
                ++k;
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                int j2 = 0;
                while (j2 < i) {
                    d[j2] = V[i - 1][j2];
                    V[i][j2] = 0.0;
                    V[j2][i] = 0.0;
                    ++j2;
                }
            } else {
                k = 0;
                while (k < i) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                    ++k;
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                int j3 = 0;
                while (j3 < i) {
                    e[j3] = 0.0;
                    ++j3;
                }
                j3 = 0;
                while (j3 < i) {
                    V[j3][i] = f = d[j3];
                    g = e[j3] + V[j3][j3] * f;
                    int k2 = j3 + 1;
                    while (k2 <= i - 1) {
                        g += V[k2][j3] * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V[k2][j3] * f;
                        ++k2;
                    }
                    e[j3] = g;
                    ++j3;
                }
                f = 0.0;
                j3 = 0;
                while (j3 < i) {
                    int n4 = j3;
                    e[n4] = e[n4] / h;
                    f += e[j3] * d[j3];
                    ++j3;
                }
                double hh = f / (h + h);
                int j4 = 0;
                while (j4 < i) {
                    int n5 = j4;
                    e[n5] = e[n5] - hh * d[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < i) {
                    f = d[j4];
                    g = e[j4];
                    int k3 = j4;
                    while (k3 <= i - 1) {
                        double[] dArray = V[k3];
                        int n6 = j4;
                        dArray[n6] = dArray[n6] - (f * e[k3] + g * d[k3]);
                        ++k3;
                    }
                    d[j4] = V[i - 1][j4];
                    V[i][j4] = 0.0;
                    ++j4;
                }
            }
            d[i] = h;
            --i;
        }
        i = 0;
        while (i < n - 1) {
            V[n - 1][i] = V[i][i];
            V[i][i] = 1.0;
            double h = d[i + 1];
            if (h != 0.0) {
                int k = 0;
                while (k <= i) {
                    d[k] = V[k][i + 1] / h;
                    ++k;
                }
                int j5 = 0;
                while (j5 <= i) {
                    double g = 0.0;
                    int k4 = 0;
                    while (k4 <= i) {
                        g += V[k4][i + 1] * V[k4][j5];
                        ++k4;
                    }
                    k4 = 0;
                    while (k4 <= i) {
                        double[] dArray = V[k4];
                        int n7 = j5;
                        dArray[n7] = dArray[n7] - g * d[k4];
                        ++k4;
                    }
                    ++j5;
                }
            }
            int k = 0;
            while (k <= i) {
                V[k][i + 1] = 0.0;
                ++k;
            }
            ++i;
        }
        j = 0;
        while (j < n) {
            d[j] = V[n - 1][j];
            V[n - 1][j] = 0.0;
            ++j;
        }
        V[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    private void tql2(int n, double[] d, double[] e, double[][] V) {
        int i = 1;
        while (i < n) {
            e[i - 1] = e[i];
            ++i;
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        int l = 0;
        while (l < n) {
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            int m = l;
            while (m < n) {
                if (Math.abs(e[m]) <= eps * tst1) break;
                ++m;
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = d[l];
                    double p = (d[l + 1] - g) / (2.0 * e[l]);
                    double r = this.math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i2 = l + 2;
                    while (i2 < n) {
                        int n2 = i2++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    int i3 = m - 1;
                    while (i3 >= l) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i3];
                        h = c * p;
                        r = this.math.hypot(p, e[i3]);
                        e[i3 + 1] = s * r;
                        s = e[i3] / r;
                        c = p / r;
                        p = c * d[i3] - s * g;
                        d[i3 + 1] = h + s * (c * g + s * d[i3]);
                        int k = 0;
                        while (k < n) {
                            h = V[k][i3 + 1];
                            V[k][i3 + 1] = s * V[k][i3] + c * h;
                            V[k][i3] = c * V[k][i3] - s * h;
                            ++k;
                        }
                        --i3;
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > eps * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
            ++l;
        }
        int i4 = 0;
        while (i4 < n - 1) {
            int k = i4;
            double p = d[i4];
            int j = i4 + 1;
            while (j < n) {
                if (d[j] < p) {
                    k = j;
                    p = d[j];
                }
                ++j;
            }
            if (k != i4) {
                d[k] = d[i4];
                d[i4] = p;
                j = 0;
                while (j < n) {
                    p = V[j][i4];
                    V[j][i4] = V[j][k];
                    V[j][k] = p;
                    ++j;
                }
            }
            ++i4;
        }
    }

    double[][] genoPhenoTransformation(double[][] popx, double[][] popy) {
        if (popy == null || popy == popx || ((double[][])popy).length != popx.length) {
            popy = new double[popx.length][];
        }
        int i = 0;
        while (i < ((double[][])popy).length) {
            popy[i] = this.genoPhenoTransformation(popx[i], popy[i]);
            ++i;
        }
        return popy;
    }

    double[][] phenoGenoTransformation(double[][] popx, double[][] popy) {
        if (popy == null || popy == popx || ((double[][])popy).length != popx.length) {
            popy = new double[popx.length][];
        }
        int i = 0;
        while (i < ((double[][])popy).length) {
            popy[i] = this.phenoGenoTransformation(popx[i], popy[i]);
            ++i;
        }
        return popy;
    }

    double[] genoPhenoTransformation(double[] x, double[] y) {
        if (y == null || y == x || y.length != x.length) {
            y = (double[])x.clone();
            return y;
        }
        int i = 0;
        while (i < this.N) {
            y[i] = x[i];
            ++i;
        }
        return y;
    }

    double[] phenoGenoTransformation(double[] x, double[] y) {
        if (y == null || y == x || y.length != x.length) {
            y = (double[])x.clone();
            return y;
        }
        int i = 0;
        while (i < this.N) {
            y[i] = x[i];
            ++i;
        }
        return y;
    }

    public double[][] samplePopulation() {
        double d;
        int i;
        if (this.state < 0.0) {
            this.init();
        } else if (this.state < 3.0 && this.state > 2.0) {
            this.error("mixing of calls to updateSingle() and samplePopulation() is not possible");
        } else {
            this.eigendecomposition(0);
        }
        if (this.state != 1.0) {
            ++this.countiter;
        }
        this.state = 1.0;
        this.idxRecentOffspring = this.sp.getLambda() - 1;
        if (this.options.lowerStandardDeviations != null && this.options.lowerStandardDeviations.length > 0) {
            i = 0;
            while (i < this.N) {
                d = this.options.lowerStandardDeviations[Math.min(i, this.options.lowerStandardDeviations.length - 1)];
                if (d > this.sigma * this.minsqrtdiagC) {
                    this.sigma = d / this.minsqrtdiagC;
                }
                ++i;
            }
        }
        if (this.options.upperStandardDeviations != null && this.options.upperStandardDeviations.length > 0) {
            i = 0;
            while (i < this.N) {
                d = this.options.upperStandardDeviations[Math.min(i, this.options.upperStandardDeviations.length - 1)];
                if (d < this.sigma * this.maxsqrtdiagC) {
                    this.sigma = d / this.maxsqrtdiagC;
                }
                ++i;
            }
        }
        this.testAndCorrectNumerics();
        int iNk = 0;
        while (iNk < this.sp.getLambda()) {
            if (this.flgdiag) {
                i = 0;
                while (i < this.N) {
                    this.arx[iNk][i] = this.xmean[i] + this.sigma * this.diagD[i] * this.rand.nextGaussian();
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.N) {
                    this.artmp[i] = this.diagD[i] * this.rand.nextGaussian();
                    ++i;
                }
                i = 0;
                while (i < this.N) {
                    int j = 0;
                    double sum = 0.0;
                    while (j < this.N) {
                        sum += this.B[i][j] * this.artmp[j];
                        ++j;
                    }
                    this.arx[iNk][i] = this.xmean[i] + this.sigma * sum;
                    ++i;
                }
            }
            ++iNk;
        }
        this.population = this.genoPhenoTransformation(this.arx, this.population);
        return this.population;
    }

    public double[] resampleSingle(int index) {
        if (this.state != 1.0) {
            this.error("call samplePopulation before calling resampleSingle(int index)");
        }
        if (this.flgdiag) {
            int i = 0;
            while (i < this.N) {
                this.arx[index][i] = this.xmean[i] + this.sigma * this.diagD[i] * this.rand.nextGaussian();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.N) {
                this.artmp[i] = this.diagD[i] * this.rand.nextGaussian();
                ++i;
            }
            i = 0;
            while (i < this.N) {
                int j = 0;
                double sum = 0.0;
                while (j < this.N) {
                    sum += this.B[i][j] * this.artmp[j];
                    ++j;
                }
                this.arx[index][i] = this.xmean[i] + this.sigma * sum;
                ++i;
            }
        }
        this.population[index] = this.genoPhenoTransformation(this.arx[index], this.population[index]);
        return this.population[index];
    }

    public double mahalanobisNorm(double[] x, double[] mean) {
        double snorm = 0.0;
        int i = 0;
        while (i < this.N) {
            int j = 0;
            double yi = 0.0;
            while (j < this.N) {
                yi += this.B[j][i] * (x[j] - mean[j]);
                ++j;
            }
            snorm += yi * yi / this.diagD[i] / this.diagD[i];
            ++i;
        }
        return Math.sqrt(snorm) / this.sigma;
    }

    public void updateDistribution(double[][] population, double[] functionValues) {
        this.updateDistribution(population, functionValues, 0);
    }

    public void updateDistribution(double[][] population, double[] functionValues, int nInjected) {
        this.arx = this.phenoGenoTransformation(population, null);
        int i = 0;
        while (i < nInjected) {
            this.warning("TODO: checking of injected solution has not yet been tested");
            double upperLength = Math.sqrt(this.N) + 2.0 * (double)this.N / ((double)this.N + 2.0);
            double fac = upperLength / this.mahalanobisNorm(this.arx[i], this.xmean);
            if (fac < 1.0) {
                int j = 0;
                while (j < this.N) {
                    this.arx[i][j] = this.xmean[j] + fac * (this.arx[i][j] - this.xmean[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.updateDistribution(functionValues);
    }

    public void updateDistribution(double[] functionValues) {
        if (this.state == 3.0) {
            this.error("updateDistribution() was already called");
        }
        if (functionValues.length != this.sp.getLambda()) {
            this.error("argument double[] funcionValues.length=" + functionValues.length + "!=" + "lambda=" + this.sp.getLambda());
        }
        int i = 0;
        while (i < this.sp.getLambda()) {
            this.fit.raw[i].val = functionValues[i];
            this.fit.raw[i].i = i;
            ++i;
        }
        this.counteval += (long)this.sp.getLambda();
        this.recentFunctionValue = this.math.min((IntDouble[])this.fit.raw).val;
        this.recentMaxFunctionValue = this.math.max((IntDouble[])this.fit.raw).val;
        this.recentMinFunctionValue = this.math.min((IntDouble[])this.fit.raw).val;
        this.updateDistribution();
    }

    private void updateDistribution() {
        int j;
        if (this.state == 3.0) {
            this.error("updateDistribution() was already called");
        }
        Arrays.sort(this.fit.raw, this.fit.raw[0]);
        int iNk = 0;
        while (iNk < this.sp.getLambda()) {
            this.fit.fitness[iNk].val = this.fit.raw[iNk].val;
            this.fit.fitness[iNk].i = this.fit.raw[iNk].i;
            ++iNk;
        }
        int i = this.fit.history.length - 1;
        while (i > 0) {
            this.fit.history[i] = this.fit.history[i - 1];
            --i;
        }
        this.fit.history[0] = this.fit.raw[0].val;
        this.updateBestEver(this.arx[this.fit.raw[0].i], this.fit.raw[0].val, this.counteval - (long)this.sp.getLambda() + (long)this.fit.raw[0].i + 1L);
        boolean bl = this.flgdiag = this.options.diagonalCovarianceMatrix == 1L || this.options.diagonalCovarianceMatrix >= this.countiter;
        if (this.options.diagonalCovarianceMatrix == -1L) {
            this.flgdiag = this.countiter <= (long)(150 * this.N / this.sp.lambda);
        }
        i = 0;
        while (i < this.N) {
            this.xold[i] = this.xmean[i];
            this.xmean[i] = 0.0;
            iNk = 0;
            while (iNk < this.sp.getMu()) {
                int n = i;
                this.xmean[n] = this.xmean[n] + this.sp.getWeights()[iNk] * this.arx[this.fit.fitness[iNk].i][i];
                ++iNk;
            }
            this.BDz[i] = Math.sqrt(this.sp.getMueff()) * (this.xmean[i] - this.xold[i]) / this.sigma;
            ++i;
        }
        if (this.flgdiag) {
            i = 0;
            while (i < this.N) {
                this.ps[i] = (1.0 - this.sp.getCs()) * this.ps[i] + Math.sqrt(this.sp.getCs() * (2.0 - this.sp.getCs())) * this.BDz[i] / this.diagD[i];
                ++i;
            }
        } else {
            double sum;
            i = 0;
            while (i < this.N) {
                j = 0;
                sum = 0.0;
                while (j < this.N) {
                    sum += this.B[j][i] * this.BDz[j];
                    ++j;
                }
                this.artmp[i] = sum / this.diagD[i];
                ++i;
            }
            i = 0;
            while (i < this.N) {
                j = 0;
                sum = 0.0;
                while (j < this.N) {
                    sum += this.B[i][j] * this.artmp[j];
                    ++j;
                }
                this.ps[i] = (1.0 - this.sp.getCs()) * this.ps[i] + Math.sqrt(this.sp.getCs() * (2.0 - this.sp.getCs())) * sum;
                ++i;
            }
        }
        double psxps = 0.0;
        i = 0;
        while (i < this.N) {
            psxps += this.ps[i] * this.ps[i];
            ++i;
        }
        int hsig = 0;
        if (Math.sqrt(psxps) / Math.sqrt(1.0 - Math.pow(1.0 - this.sp.getCs(), 2.0 * (double)this.countiter)) / this.sp.chiN < 1.4 + 2.0 / ((double)this.N + 1.0)) {
            hsig = 1;
        }
        i = 0;
        while (i < this.N) {
            this.pc[i] = (1.0 - this.sp.getCc()) * this.pc[i] + (double)hsig * Math.sqrt(this.sp.getCc() * (2.0 - this.sp.getCc())) * this.BDz[i];
            ++i;
        }
        if (this.iniphase && (double)this.countiter > Math.min(1.0 / this.sp.getCs(), 1.0 + (double)this.N / this.sp.getMucov()) && psxps / this.sp.getDamps() / (1.0 - Math.pow(1.0 - this.sp.getCs(), this.countiter)) < (double)this.N * 1.05) {
            this.iniphase = false;
        }
        if (this.sp.getCcov() > 0.0 && !this.iniphase) {
            ++this.countCupdatesSinceEigenupdate;
            i = 0;
            while (i < this.N) {
                j = this.flgdiag ? i : 0;
                while (j <= i) {
                    this.C[i][j] = (1.0 - this.sp.getCcov(this.flgdiag)) * this.C[i][j] + this.sp.getCcov() * (1.0 / this.sp.getMucov()) * (this.pc[i] * this.pc[j] + (double)(1 - hsig) * this.sp.getCc() * (2.0 - this.sp.getCc()) * this.C[i][j]);
                    int k = 0;
                    while (k < this.sp.getMu()) {
                        double[] dArray = this.C[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.sp.getCcov() * (1.0 - 1.0 / this.sp.getMucov()) * this.sp.getWeights()[k] * (this.arx[this.fit.fitness[k].i][i] - this.xold[i]) * (this.arx[this.fit.fitness[k].i][j] - this.xold[j]) / this.sigma / this.sigma;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.maxsqrtdiagC = Math.sqrt(this.math.max(this.math.diag(this.C)));
            this.minsqrtdiagC = Math.sqrt(this.math.min(this.math.diag(this.C)));
        }
        this.sigma *= Math.exp((Math.sqrt(psxps) / this.sp.chiN - 1.0) * this.sp.getCs() / this.sp.getDamps());
        this.state = 3.0;
    }

    double[] assignNew(double[] rhs, double[] lhs) {
        assert (rhs != null);
        if (lhs != null && lhs != rhs && lhs.length == rhs.length) {
            int i = 0;
            while (i < lhs.length) {
                lhs[i] = rhs[i];
                ++i;
            }
        } else {
            lhs = (double[])rhs.clone();
        }
        return lhs;
    }

    void updateBestEver(double[] x, double fitness, long eval) {
        if (fitness < this.bestever_fit || Double.isNaN(this.bestever_fit)) {
            this.bestever_fit = fitness;
            this.bestever_eval = eval;
            this.bestever_x = this.assignNew(x, this.bestever_x);
        }
    }

    public void setBestEver(double[] x, double fitness, long eval) {
        this.bestever_fit = fitness;
        this.bestever_eval = eval;
        this.bestever_x = this.assignNew(x, this.bestever_x);
    }

    public double getAxisRatio() {
        return this.axisratio;
    }

    public CMASolution getBestSolution() {
        return new CMASolution(this.bestever_x, this.bestever_fit, this.bestever_eval);
    }

    public CMASolution setFitnessOfMeanX(double fitness) {
        this.xmean_fit = fitness;
        ++this.counteval;
        this.updateBestEver(this.xmean, fitness, this.counteval);
        return new CMASolution(this.bestever_x, this.bestever_fit, this.bestever_eval);
    }

    public double[] getBestX() {
        if (this.state < 0.0) {
            return null;
        }
        return (double[])this.bestever_x.clone();
    }

    public double getBestFunctionValue() {
        if (this.state < 0.0) {
            return Double.NaN;
        }
        return this.bestever_fit;
    }

    public long getBestEvaluationNumber() {
        return this.bestever_eval;
    }

    public ISolutionPoint getBestRecentSolution() {
        return new CMASolution(this.genoPhenoTransformation(this.arx[this.fit.raw[0].i], null), this.fit.raw[0].val, this.counteval - (long)this.sp.getLambda() + (long)this.fit.raw[0].i + 1L);
    }

    public double[] getBestRecentX() {
        return this.genoPhenoTransformation(this.arx[this.fit.raw[0].i], null);
    }

    public double getBestRecentFunctionValue() {
        return this.recentMinFunctionValue;
    }

    public double getWorstRecentFunctionValue() {
        return this.recentMaxFunctionValue;
    }

    public double[] getMeanX() {
        return (double[])this.xmean.clone();
    }

    public int getDimension() {
        return this.N;
    }

    public long getCountEval() {
        return this.counteval;
    }

    public long getCountIter() {
        return this.countiter;
    }

    public double[] getInitialX() {
        if (this.state < 0.0) {
            this.error("initiaX not yet available, init() must be called first");
        }
        return (double[])this.initialX.clone();
    }

    public Random getRand() {
        return this.rand;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public long getSeed() {
        return this.seed;
    }

    public long setCountEval(long c) {
        this.counteval = c;
        return this.counteval;
    }

    public void setDimension(int n) {
        if ((this.lockDimension > 0 || this.state >= 0.0) && this.N != n) {
            this.error("dimension cannot be changed anymore or contradicts to initialX");
        }
        this.N = n;
    }

    public void setTypicalX(double x) {
        if (this.state >= 0.0) {
            this.error("typical x cannot be set anymore");
        }
        this.typicalX = new double[]{x};
    }

    public void setTypicalX(double[] x) {
        if (this.state >= 0.0) {
            this.error("typical x cannot be set anymore");
        }
        if (x.length == 1) {
            this.setTypicalX(x[0]);
            return;
        }
        if (this.N < 1) {
            this.setDimension(x.length);
        }
        if (this.N != x.length) {
            this.error("dimensions N=" + this.N + " and input x.length=" + x.length + "do not agree");
        }
        this.typicalX = new double[this.N];
        int i = 0;
        while (i < this.N) {
            this.typicalX[i] = x[i];
            ++i;
        }
        this.lockDimension = 1;
    }

    public void setInitialStandardDeviation(double startsigma) {
        if (this.state >= 0.0) {
            this.error("standard deviations cannot be set anymore");
        }
        this.startsigma = new double[]{startsigma};
    }

    public void setInitialStandardDeviations(double[] startsigma) {
        if (this.state >= 0.0) {
            this.error("standard deviations cannot be set anymore");
        }
        if (startsigma.length == 1) {
            this.setInitialStandardDeviation(startsigma[0]);
            return;
        }
        if (this.N > 0 && this.N != startsigma.length) {
            this.error("dimensions N=" + this.N + " and input startsigma.length=" + startsigma.length + "do not agree");
        }
        if (this.N == 0) {
            this.setDimension(startsigma.length);
        }
        assert (this.N == startsigma.length);
        this.startsigma = (double[])startsigma.clone();
        this.lockDimension = 1;
    }

    public void setInitialX(double x) {
        if (this.state >= 0.0) {
            this.error("initial x cannot be set anymore");
        }
        this.xmean = new double[]{x};
    }

    public void setInitialX(double l, double u) {
        if (this.state >= 0.0) {
            this.error("initial x cannot be set anymore");
        }
        if (this.N < 1) {
            this.error("dimension must have been specified before");
        }
        this.xmean = new double[this.N];
        int i = 0;
        while (i < this.xmean.length) {
            this.xmean[i] = l + (u - l) * this.rand.nextDouble();
            ++i;
        }
        this.lockDimension = 1;
    }

    public void setInitialX(double[] l, double[] u) {
        if (this.state >= 0.0) {
            this.error("initial x cannot be set anymore");
        }
        if (l.length != u.length) {
            this.error("length of lower and upper values disagree");
        }
        this.setDimension(l.length);
        this.xmean = new double[this.N];
        int i = 0;
        while (i < this.xmean.length) {
            this.xmean[i] = l[i] + (u[i] - l[i]) * this.rand.nextDouble();
            ++i;
        }
        this.lockDimension = 1;
    }

    public void setInitialX(double[] x) {
        if (this.state >= 0.0) {
            this.error("initial x cannot be set anymore");
        }
        if (x.length == 1) {
            this.setInitialX(x[0]);
            return;
        }
        if (this.N > 0 && this.N != x.length) {
            this.error("dimensions do not match");
        }
        if (this.N == 0) {
            this.setDimension(x.length);
        }
        assert (this.N == x.length);
        this.xmean = new double[this.N];
        int i = 0;
        while (i < this.N) {
            this.xmean[i] = x[i];
            ++i;
        }
        this.lockDimension = 1;
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }

    public void setSeed(long seed) {
        if (this.state >= 0.0) {
            this.warning("setting seed has no effect at this point");
        } else {
            if (seed <= 0L) {
                seed = System.currentTimeMillis();
            }
            this.seed = seed;
            this.rand.setSeed(seed);
        }
    }

    public String getPrintLine() {
        String s = this.state < 0.0 ? new String(String.valueOf(new PrintfFormat(Locale.US, " %4d").sprintf(this.countiter)) + new PrintfFormat(Locale.US, "(%2d), ").sprintf(0) + new PrintfFormat(Locale.US, "%6.0d: ").sprintf(this.counteval)) : new String(String.valueOf(new PrintfFormat(Locale.US, " %4d").sprintf(this.countiter)) + new PrintfFormat(Locale.US, "(%2d), ").sprintf(this.idxRecentOffspring + 1) + new PrintfFormat(Locale.US, "%6.0d: ").sprintf(this.counteval) + new PrintfFormat(Locale.US, "%.16e ").sprintf(this.recentFunctionValue) + new PrintfFormat(Locale.US, "(%+.0e,").sprintf(this.getBestFunctionValue() - this.recentFunctionValue) + new PrintfFormat(Locale.US, "%.0e) | ").sprintf(this.recentMaxFunctionValue - this.recentFunctionValue) + new PrintfFormat(Locale.US, "%2d:").sprintf(this.math.maxidx(this.math.diag(this.C))) + new PrintfFormat(Locale.US, "%8.1e ").sprintf(this.sigma * this.maxsqrtdiagC) + new PrintfFormat(Locale.US, "%2d:").sprintf(this.math.minidx(this.math.diag(this.C))) + new PrintfFormat(Locale.US, "%8.1e ").sprintf(this.sigma * this.minsqrtdiagC) + new PrintfFormat(Locale.US, "| %6.1e ").sprintf(this.sigma * this.math.min(this.diagD)) + new PrintfFormat(Locale.US, "%6.1e ").sprintf(this.sigma) + new PrintfFormat(Locale.US, "%6.2f").sprintf(this.axisratio) + new PrintfFormat(Locale.US, "   | %4.1f ").sprintf((double)(System.currentTimeMillis() - this.timings.start) / 1000.0) + new PrintfFormat(Locale.US, "%4.1f ").sprintf((double)this.timings.eigendecomposition / 1000.0));
        return s;
    }

    public String getPrintAnnotation() {
        String s = new String("Iteration,#Fevals: rb Function Value Delta( best ,worst) |idx: Max SD idx: Min SD  | minsigD  sigma Axisratio | time, in eig");
        return s;
    }

    public String helloWorld() {
        String s = new String("(" + this.sp.getMu() + "," + this.sp.getLambda() + ")-CMA-ES(mu_eff=" + (double)Math.round(10.0 * this.sp.getMueff()) / 10.0 + "), Ver=\"" + this.versionNumber + "\", dimension=" + this.N + ", " + this.options.diagonalCovarianceMatrix + " diagonal iter." + ", randomSeed=" + this.seed + " (" + new Date().toString() + ")");
        return s;
    }

    public void println(String s) {
        System.out.println(s);
        if (this.options.writeDisplayToFile > 0) {
            this.writeToFile(String.valueOf(this.options.outputFileNamesPrefix) + "disp" + ".dat", s, 1);
        }
    }

    public void println() {
        this.println(this.getPrintLine());
    }

    public void printlnAnnotation() {
        this.println(this.getPrintAnnotation());
    }

    public void printlnHelloWorld() {
        this.println(this.helloWorld());
    }

    public String getDataRowFitness() {
        String s = new String();
        s = String.valueOf(this.countiter) + " " + this.counteval + " " + this.sigma + " " + this.axisratio + " " + this.bestever_fit + " ";
        if (this.mode == 1) {
            s = String.valueOf(s) + this.recentFunctionValue + " ";
        } else {
            s = String.valueOf(s) + this.fit.raw[0].val + " ";
            s = String.valueOf(s) + this.fit.raw[this.sp.getLambda() / 2].val + " ";
            s = String.valueOf(s) + this.fit.raw[this.sp.getLambda() - 1].val + " ";
            s = String.valueOf(s) + this.math.min(this.diagD) + " " + (this.math.maxidx(this.math.diag(this.C)) + 1) + " " + this.sigma * this.maxsqrtdiagC + " " + (this.math.minidx(this.math.diag(this.C)) + 1) + " " + this.sigma * this.minsqrtdiagC;
        }
        return s;
    }

    public String getDataRowXRecentBest() {
        int idx = 0;
        if (this.mode == 1) {
            idx = this.idxRecentOffspring;
        }
        String s = new String();
        s = String.valueOf(this.countiter) + " " + this.counteval + " " + this.sigma + " 0 " + (this.state == 1.0 ? Double.NaN : this.fit.raw[idx].val) + " ";
        int i = 0;
        while (i < this.N) {
            s = String.valueOf(s) + this.arx[this.fit.raw[idx].i][i] + " ";
            ++i;
        }
        return s;
    }

    public String getDataRowXMean() {
        String s = new String();
        s = String.valueOf(this.countiter) + " " + this.counteval + " " + this.sigma + " 0 0 ";
        int i = 0;
        while (i < this.N) {
            s = String.valueOf(s) + this.xmean[i] + " ";
            ++i;
        }
        return s;
    }

    public String getDataRowAxlen() {
        String s = new String();
        s = String.valueOf(this.countiter) + " " + this.counteval + " " + this.sigma + " " + this.axisratio + " " + this.maxsqrtdiagC / this.minsqrtdiagC + " ";
        double[] tmp = (double[])this.diagD.clone();
        Arrays.sort(tmp);
        int i = 0;
        while (i < this.N) {
            s = String.valueOf(s) + tmp[i] + " ";
            ++i;
        }
        return s;
    }

    public String getDataRowStddev() {
        String s = new String();
        s = String.valueOf(this.countiter) + " " + this.counteval + " " + this.sigma + " " + (1 + this.math.maxidx(this.math.diag(this.C))) + " " + (1 + this.math.minidx(this.math.diag(this.C))) + " ";
        int i = 0;
        while (i < this.N) {
            s = String.valueOf(s) + this.sigma * Math.sqrt(this.C[i][i]) + " ";
            ++i;
        }
        return s;
    }

    public String getDataC() {
        String s = new String();
        s = "%# " + this.countiter + " " + this.counteval + " " + this.sigma + "\n";
        int i = 0;
        while (i < this.N) {
            int j = 0;
            while (j < i) {
                s = String.valueOf(s) + this.C[i][j] / Math.sqrt(this.C[i][i] * this.C[j][j]) + " ";
                ++j;
            }
            j = i;
            while (j < this.N) {
                s = String.valueOf(s) + this.sigma * this.sigma * this.C[i][j] + " ";
                ++j;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        return s;
    }

    public void writeToFile(String filename, String data, int flgAppend) {
        block14: {
            boolean appendflag;
            block13: {
                appendflag = flgAppend > 0;
                int i = 0;
                while (!appendflag && i < this.fileswritten.length) {
                    if (filename.equals(this.fileswritten[i])) {
                        appendflag = true;
                    }
                    ++i;
                }
                PrintWriter out = null;
                try {
                    out = new PrintWriter(new FileWriter(filename, appendflag));
                    out.println(data);
                    out.flush();
                    out.close();
                }
                catch (FileNotFoundException e) {
                    this.warning("Could not find file '" + filename + "'(FileNotFoundException)");
                    if (out != null) {
                        out.close();
                    }
                    break block13;
                }
                catch (IOException e) {
                    try {
                        this.warning("Could not open/write to file " + filename);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                if (out != null) {
                    out.close();
                }
            }
            if (appendflag) break block14;
            String[] s = this.fileswritten;
            this.fileswritten = new String[this.fileswritten.length + 1];
            int i = 0;
            while (i < s.length) {
                this.fileswritten[i] = s[i];
                ++i;
            }
            this.fileswritten[this.fileswritten.length - 1] = new String(filename);
        }
    }

    public void writeToDefaultFiles() {
        this.writeToDefaultFiles(this.options.outputFileNamesPrefix);
    }

    public void writeToDefaultFiles(int flgForce) {
        if (flgForce > 0 && this.countiter != this.citerlastwritten) {
            this.citerlastwritten = -1L;
        }
        if (flgForce >= 2) {
            this.citerlastwritten = -1L;
        }
        this.writeToDefaultFiles(this.options.outputFileNamesPrefix);
    }

    public void writeToDefaultFiles(String fileNamePrefix) {
        if (this.options.maxTimeFractionForWriteToDefaultFiles < 0.0) {
            return;
        }
        if (this.citerlastwritten >= 0L) {
            if (this.state < 1.0) {
                return;
            }
            if (this.countiter == this.citerlastwritten) {
                return;
            }
            if (this.options.maxTimeFractionForWriteToDefaultFiles <= 0.0) {
                return;
            }
            if (this.countiter > 4L && this.stopConditions.index == 0 && (double)(this.countiter - this.citerlastwritten - 1L) < 2.0 * ((double)(this.countiter - this.countwritten) + 1.0) / ((double)this.countwritten + 1.0) && (double)this.timings.writedefaultfiles > this.options.maxTimeFractionForWriteToDefaultFiles * (double)(System.currentTimeMillis() - this.timings.start)) {
                return;
            }
        }
        long firsttime = System.currentTimeMillis();
        this.writeToFile(String.valueOf(fileNamePrefix) + "fit.dat", this.getDataRowFitness(), 1);
        this.writeToFile(String.valueOf(fileNamePrefix) + "xmean.dat", this.getDataRowXMean(), 1);
        this.writeToFile(String.valueOf(fileNamePrefix) + "xrecentbest.dat", this.getDataRowXRecentBest(), 1);
        this.writeToFile(String.valueOf(fileNamePrefix) + "stddev.dat", this.getDataRowStddev(), 1);
        this.writeToFile(String.valueOf(fileNamePrefix) + "axlen.dat", this.getDataRowAxlen(), 1);
        this.timings.writedefaultfiles += System.currentTimeMillis() - firsttime;
        if (this.countiter < 3L) {
            this.timings.writedefaultfiles = 0L;
        }
        ++this.countwritten;
        this.citerlastwritten = this.countiter;
    }

    public void writeToDefaultFilesHeaders(int flgAppend) {
        this.writeToDefaultFilesHeaders(this.options.outputFileNamesPrefix, flgAppend);
    }

    public void writeToDefaultFilesHeaders(String fileNamePrefix, int flgAppend) {
        if (this.options.maxTimeFractionForWriteToDefaultFiles < 0.0) {
            return;
        }
        String s = "(randomSeed=" + this.seed + ", " + new Date().toString() + ")\n";
        this.writeToFile(String.valueOf(fileNamePrefix) + "fit.dat", "%# iteration evaluations sigma axisratio fitness_of(bestever best median worst) mindii idxmaxSD maxSD idxminSD minSD " + s, flgAppend);
        this.writeToFile(String.valueOf(fileNamePrefix) + "xmean.dat", "%# iteration evaluations sigma void void mean(1...dimension) " + s, flgAppend);
        if (this.state == 0.0) {
            this.writeToFile(String.valueOf(fileNamePrefix) + "xmean.dat", this.getDataRowXMean(), 1);
        }
        this.writeToFile(String.valueOf(fileNamePrefix) + "xrecentbest.dat", "%# iteration evaluations sigma void fitness_of_recent_best x_of_recent_best(1...dimension) " + s, flgAppend);
        this.writeToFile(String.valueOf(fileNamePrefix) + "stddev.dat", "%# iteration evaluations sigma idxmaxSD idxminSD SDs=sigma*sqrt(diag(C)) " + s, flgAppend);
        if (this.state == 0.0) {
            this.writeToFile(String.valueOf(fileNamePrefix) + "stddev.dat", this.getDataRowStddev(), 1);
        }
        this.writeToFile(String.valueOf(fileNamePrefix) + "axlen.dat", "%# iteration evaluations sigma axisratio stddevratio sort(diag(D)) (square roots of eigenvalues of C) " + s, flgAppend);
        if (this.state == 0.0) {
            this.writeToFile(String.valueOf(fileNamePrefix) + "axlen.dat", this.getDataRowAxlen(), 1);
        }
    }

    public class CMAException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CMAException(String s) {
            super(s);
        }
    }

    class FitnessCollector {
        double[] history;
        IntDouble[] fitness;
        IntDouble[] raw;
        double[] deltaFitHist = new double[5];
        int idxDeltaFitHist = 0;

        FitnessCollector() {
        }
    }

    class MyMath {
        int itest;

        MyMath() {
        }

        double square(double d) {
            return d * d;
        }

        double prod(double[] ar) {
            double res = 1.0;
            int i = 0;
            while (i < ar.length) {
                res *= ar[i];
                ++i;
            }
            return res;
        }

        public double median(double[] ar) {
            double[] ar2 = new double[ar.length];
            int i = 0;
            while (i < ar.length) {
                ar2[i] = ar[i];
                ++i;
            }
            Arrays.sort(ar2);
            if (ar2.length % 2 == 0) {
                return (ar2[ar.length / 2] + ar2[ar.length / 2 - 1]) / 2.0;
            }
            return ar2[ar.length / 2];
        }

        public double max(double[] ar) {
            double m = ar[0];
            int i = 1;
            while (i < ar.length) {
                if (m < ar[i]) {
                    m = ar[i];
                }
                ++i;
            }
            return m;
        }

        public double hypot(double a, double b) {
            double r = 0.0;
            if (Math.abs(a) > Math.abs(b)) {
                r = b / a;
                r = Math.abs(a) * Math.sqrt(1.0 + r * r);
            } else if (b != 0.0) {
                r = a / b;
                r = Math.abs(b) * Math.sqrt(1.0 + r * r);
            }
            return r;
        }

        public int minidx(double[] ar) {
            return this.minidx(ar, ar.length - 1);
        }

        public int minidx(double[] ar, int maxidx) {
            int idx = 0;
            int i = 1;
            while (i < maxidx) {
                if (ar[idx] > ar[i]) {
                    idx = i;
                }
                ++i;
            }
            return idx;
        }

        protected int minidx(IntDouble[] ar, int maxidx) {
            int idx = 0;
            int i = 1;
            while (i < maxidx) {
                if (ar[idx].val > ar[i].val) {
                    idx = i;
                }
                ++i;
            }
            return idx;
        }

        public int maxidx(double[] ar) {
            int idx = 0;
            int i = 1;
            while (i < ar.length) {
                if (ar[idx] < ar[i]) {
                    idx = i;
                }
                ++i;
            }
            return idx;
        }

        public double min(double[] ar) {
            double m = ar[0];
            int i = 1;
            while (i < ar.length) {
                if (m > ar[i]) {
                    m = ar[i];
                }
                ++i;
            }
            return m;
        }

        public Double max(Double[] ar, Comparator<Double> c) {
            Double m = ar[0];
            int i = 1;
            while (i < ar.length) {
                if (c.compare(m, ar[i]) > 0) {
                    m = ar[i];
                }
                ++i;
            }
            return m;
        }

        public IntDouble max(IntDouble[] ar) {
            IntDouble m = ar[0];
            int i = 1;
            while (i < ar.length) {
                if (m.compare(m, ar[i]) < 0) {
                    m = ar[i];
                }
                ++i;
            }
            return m;
        }

        public IntDouble min(IntDouble[] ar) {
            IntDouble m = ar[0];
            int i = 1;
            while (i < ar.length) {
                if (m.compare(m, ar[i]) > 0) {
                    m = ar[i];
                }
                ++i;
            }
            return m;
        }

        public Double min(Double[] ar, Comparator<Double> c) {
            Double m = ar[0];
            int i = 1;
            while (i < ar.length) {
                if (c.compare(m, ar[i]) < 0) {
                    m = ar[i];
                }
                ++i;
            }
            return m;
        }

        public double[] diag(double[][] ar) {
            double[] diag = new double[ar.length];
            int i = 0;
            while (i < ar.length && i < ar[i].length) {
                diag[i] = ar[i][i];
                ++i;
            }
            return diag;
        }

        public double[] abs(double[] v) {
            double[] res = new double[v.length];
            int i = 0;
            while (i < v.length) {
                res[i] = Math.abs(v[i]);
                ++i;
            }
            return res;
        }
    }

    public class StopCondition {
        int index = 0;
        String[] messages = new String[]{""};
        double lastcounteval;

        public boolean isTrue() {
            return this.test() > 0;
        }

        public boolean isFalse() {
            return !this.isTrue();
        }

        public int getNumber() {
            return this.test();
        }

        public String[] getMessages() {
            this.test();
            return this.messages;
        }

        public void clear() {
            this.messages = new String[]{""};
            this.index = 0;
        }

        private void appendMessage(String s) {
            String[] mold = this.messages;
            this.messages = new String[this.index + 1];
            int i = 0;
            while (i < this.index) {
                this.messages[i] = mold[i];
                ++i;
            }
            this.messages[this.index++] = String.valueOf(s) + " (iter=" + CMAEvolutionStrategy.this.countiter + ",eval=" + CMAEvolutionStrategy.this.counteval + ")";
        }

        int test() {
            double tolx;
            if (CMAEvolutionStrategy.this.state < 0.0) {
                return 0;
            }
            if (this.index > 0 && ((double)CMAEvolutionStrategy.this.counteval == this.lastcounteval || (double)CMAEvolutionStrategy.this.counteval == this.lastcounteval + 1.0)) {
                return this.index;
            }
            this.lastcounteval = CMAEvolutionStrategy.this.counteval;
            if ((CMAEvolutionStrategy.this.countiter > 1L || CMAEvolutionStrategy.this.state >= 3.0) && CMAEvolutionStrategy.this.bestever_fit <= CMAEvolutionStrategy.this.options.stopFitness) {
                this.appendMessage("Fitness: Objective function value dropped below the target function value " + CMAEvolutionStrategy.this.options.stopFitness);
            }
            if (CMAEvolutionStrategy.this.counteval >= CMAEvolutionStrategy.this.options.stopMaxFunEvals) {
                this.appendMessage("MaxFunEvals: maximum number of function evaluations " + CMAEvolutionStrategy.this.options.stopMaxFunEvals + " reached");
            }
            if (CMAEvolutionStrategy.this.countiter >= CMAEvolutionStrategy.this.options.stopMaxIter) {
                this.appendMessage("MaxIter: maximum number of iterations reached");
            }
            if ((CMAEvolutionStrategy.this.countiter > 1L || CMAEvolutionStrategy.this.state >= 3.0) && Math.max(CMAEvolutionStrategy.this.math.max(CMAEvolutionStrategy.this.fit.history), CMAEvolutionStrategy.this.fit.fitness[CMAEvolutionStrategy.this.fit.fitness.length - 1].val) - Math.min(CMAEvolutionStrategy.this.math.min(CMAEvolutionStrategy.this.fit.history), CMAEvolutionStrategy.this.fit.fitness[0].val) <= CMAEvolutionStrategy.this.options.stopTolFun) {
                this.appendMessage("TolFun: function value changes below stopTolFun=" + CMAEvolutionStrategy.this.options.stopTolFun);
            }
            if (CMAEvolutionStrategy.this.options.stopTolFunHist >= 0.0 && CMAEvolutionStrategy.this.countiter > (long)CMAEvolutionStrategy.this.fit.history.length && CMAEvolutionStrategy.this.math.max(CMAEvolutionStrategy.this.fit.history) - CMAEvolutionStrategy.this.math.min(CMAEvolutionStrategy.this.fit.history) <= CMAEvolutionStrategy.this.options.stopTolFunHist) {
                this.appendMessage("TolFunHist: history of function value changes below stopTolFunHist=" + CMAEvolutionStrategy.this.options.stopTolFunHist);
            }
            if (CMAEvolutionStrategy.this.sigma * CMAEvolutionStrategy.this.maxsqrtdiagC < (tolx = Math.max(CMAEvolutionStrategy.this.options.stopTolX, CMAEvolutionStrategy.this.options.stopTolXFactor * CMAEvolutionStrategy.this.minstartsigma)) && CMAEvolutionStrategy.this.sigma * CMAEvolutionStrategy.this.math.max(CMAEvolutionStrategy.this.math.abs(CMAEvolutionStrategy.this.pc)) < tolx) {
                this.appendMessage("TolX or TolXFactor: standard deviation below " + tolx);
            }
            if (CMAEvolutionStrategy.this.sigma * CMAEvolutionStrategy.this.maxsqrtdiagC > CMAEvolutionStrategy.this.options.stopTolUpXFactor * CMAEvolutionStrategy.this.maxstartsigma) {
                this.appendMessage("TolUpX: standard deviation increased by more than stopTolUpXFactor=" + CMAEvolutionStrategy.this.options.stopTolUpXFactor + ", larger initial standard deviation recommended");
            }
            if (CMAEvolutionStrategy.this.options.stopnow) {
                this.appendMessage("Manual: flag Options.stopnow set or stop now in .properties file");
            }
            int iAchse = 0;
            while (iAchse < CMAEvolutionStrategy.this.N) {
                int l = CMAEvolutionStrategy.this.flgdiag ? iAchse : 0;
                int u = CMAEvolutionStrategy.this.flgdiag ? iAchse + 1 : CMAEvolutionStrategy.this.N;
                double fac = 0.1 * CMAEvolutionStrategy.this.sigma * CMAEvolutionStrategy.this.diagD[iAchse];
                int iKoo = l;
                while (iKoo < u) {
                    if (CMAEvolutionStrategy.this.xmean[iKoo] != CMAEvolutionStrategy.this.xmean[iKoo] + fac * CMAEvolutionStrategy.this.B[iKoo][iAchse]) break;
                    ++iKoo;
                }
                if (iKoo == u) {
                    this.appendMessage("NoEffectAxis: Mutation " + 0.1 * CMAEvolutionStrategy.this.sigma * CMAEvolutionStrategy.this.diagD[iAchse] + " in a principal axis " + iAchse + " has no effect");
                }
                ++iAchse;
            }
            int iKoo = 0;
            while (iKoo < CMAEvolutionStrategy.this.N) {
                if (CMAEvolutionStrategy.this.xmean[iKoo] == CMAEvolutionStrategy.this.xmean[iKoo] + 0.2 * CMAEvolutionStrategy.this.sigma * Math.sqrt(CMAEvolutionStrategy.this.C[iKoo][iKoo])) {
                    this.appendMessage("NoEffectCoordinate: Mutation of size " + 0.2 * CMAEvolutionStrategy.this.sigma * Math.sqrt(CMAEvolutionStrategy.this.C[iKoo][iKoo]) + " in coordinate " + iKoo + " has no effect");
                }
                ++iKoo;
            }
            if (CMAEvolutionStrategy.this.math.min(CMAEvolutionStrategy.this.diagD) <= 0.0) {
                this.appendMessage("ConditionNumber: smallest eigenvalue smaller or equal zero");
            } else if (CMAEvolutionStrategy.this.math.max(CMAEvolutionStrategy.this.diagD) / CMAEvolutionStrategy.this.math.min(CMAEvolutionStrategy.this.diagD) > 1.0E7) {
                this.appendMessage("ConditionNumber: condition number of the covariance matrix exceeds 1e14");
            }
            return this.index;
        }
    }

    class Timing {
        long birth;
        long start = this.birth = System.currentTimeMillis();
        long starteigen;
        long eigendecomposition = 0L;
        long writedefaultfiles = 0L;

        Timing() {
        }
    }
}

