# qwraps2 0.6.0

## General Improvements

* Unit testing is done in base R, moved away from testthat.
* Updating roxygen dependencies to correctly document the package.
* Extend documentation and testing of `set_diff`
* The default value for `conf_int` in `qacf` has been modified from `0.05` to `1 - getOption("qwraps2_alpha", 0.05)`
* `ggplot2_extract_legend` is now and S3 method
* `qable` is now and S3 method and has gained a new argument `kable_args` to
  make it clear what values are used by `qable` and which are passed to
  `knitr::kable` (#84)
* `summary_table` has gained two arguments, `qable_args` and `kable_args` to
  help with passing through arguments and being able to use the features of
  knitr::kable (#84)
* vignettes have been renamed to have a consistent "qwraps2-<topic>" structure.
* `summary_table` has it's own vignette.

## New Features

* `mean_se` to provide the mean and standard error of the mean in the same
  format as the `mean_sd` function.

* Add Precision-Recall curve, `qprc`, to complement ROC, `qroc`.

* Add quick "restricted mean survival time," `qrmst` method.

* Binary Operators:

  * `%s%` for "adding" strings together, e.g.,  `"A" %s% "B" %s% "C"` is
    equivalent to `paste0("A", "B", "C")`

* add `append` argument to `frmt`

## User Visible Changes

* `qable` has been modified to return a character matrix with the S3 class
  `qwraps2_qable`. A `print` method has been added as a wrapper to
  `knitr::kable` to generate the table with the wanted markup.  This change will
  allow end users to modify the matrix generated by `qable` and print the markup
  results with ease. This will be particularly useful when using `summary_table`
  and added bespoke p-values to the rows in a "table 1."

* `spin_comments` returns `TRUE` or `FALSE` with the notes on the
  matching/mismatched comments as an attribute of the return object.

* Extend the S3 methods provided for `qroc_build_data_frame`

* **Potentially breaking Change** `confusion_matrix` has been undergone a major
  refactor.  If nothing else, the return object is now a data.frame with more
  output than before.  The inputs are hopefully easier for end users as well.
  This change includes the addition of the function `auc` and major refactor of
  `qroc` and `qprc`.

## Deprecated / Removed

* `summary_table_042` and `tab_summary`, the tidyverse versions of summary table
  that had been deprecated have been removed from the package. (#96)

* `qroc_build_data_frame` as been deprecated in favor of `auc`


# qwraps2 0.5.2

## Bug Fixes

* Correct error in summary table cbind (#104)

# qwraps2 0.5.1

## Bug Fixes

* Correct error in output of bootstrapped results for confusion matrices (#102)

# qwraps2 0.5.0

## New Features

* `set_diff`
* `spin_comments` - a tool to identify opening and closing pairs of comments in
  a .R file expected to go through knitr::spin.  Built to help resolve the
  "comments must be put in pair of start and end delimiters" error that can be
  thrown by knitr::spin.
* `mtcars2` is a fully documented data set provided as part of the qwraps2 package.
* `summary_table` has a `by` argument and supports summaries by more than one
  variable.

* The example data set `mtcars2` is now exported as part of the package.  The
  construction of this data set is documented in a new vignette,
  `vignette("qwraps2-data-sets")`

* A data set `pefr` for peak expiratory flow rate data from Martin and Altman
  (1986) has been added to the package.  Documentation of the data set is found
  in the `vignette("qwraps2-data-sets")`

* Examples, and extended details, for graphics have been added to new vignette
  `vignette("qwraps2-graphics")`

## Bug Fixes

* Scoping issue (#85) in the confusion matrix call
* Long object names passed to `summary_table` no longer generate an error (#90)

## Improvements

* confusion matrix returns additional statistics (#87)
  * F1
  * MCC

* `...` passes values arguments to `stats::predict` via `qroc` and
  `qroc_build_data_frame`

* reduced the use of non-base R, specifically tidyverse and magrittr, within the
  base code of qwraps2. Focus on base R methods instead.  This will, hopefully,
  improve long term stability of the package and reduce warnings and error
  generated by an ever changing tidyverse api.  This includes a `by` argument
  (#100), and other notes related to #96, #98, and #71.

* deprecated the transform argument in `mean_ci` -- to easy to have bad results
  come out of that option.  Think about the delta method.

# qwraps2 0.4.2

## New Features

* If the a variable in a data.frame has an attributed called "label" then that
  label will be used in the rgroup for `qsummary` and `summary_table`, (#74)

* `backtick` is provided as a work around for a `knitr::spin` issue.  The
  function wraps text in backticks so that backticks do not need to be
  explicitly used in a .R file expected to be spun to .Rmd.

# qwraps2 0.4.1

Comment out a test due to the change in random number generating for `sample`.
(#72)

# qwraps2 0.4.0

## New Features

* `rbind.qwraps2_summary_table` (#55, #56)
* formatting options for package names and urls to CRAN, gitlab, and github.
  (#68)

## Improvements:

* `cbind.qwrap2_summary_table` check attributes of objects to be combined
  together. (#56)
* Added example to vignette to address the use `tab_summary` with more than one
  variable, e.g., in a `sapply` call. (#53)
* `qsummary` will return the first (min) and last (max) for variables where
  `inherit(var, "Date")` is `TRUE`.

## Deprecation

* `tab_summary` has been deprecated, use `qsummary` instead.  A warning message
  will be given to the user at this time.  `tab_summary` will be removed
  completely in a later version.

* `create_pkg` has been deprecated and removed from the package.  The function
  was going to need a massive rewrite to deal with changes to
  [devtools](https://cran.r-project.org/package=devtools) and
  [usethis](https://cran.r-project.org/package=usethis).   Effectively, the
  function would no longer work and this deprecation is just being pragmatic.

# qwraps2 0.3.0

## New Features
* Added `lazyload_cache_dir` and `lazyload_cache_labels` for (lazy)loading of
  cached chunks.  Very useful for loading cached `knitr` code chunks into an
  interactive R session.

* Added `traprule` for a quick way to integrate a numeric vector

* Added `create_pkg`: a wrapper about `devtools::create` with more defaults that
  I prefer.

* Added a `file_check` (#50) to check for read access and optionally md5sum of files.

* Added a `pkg_check` (#51) to check if a list of packages are available.

* Added functions for geometric mean, variance, and standard deviation.  (#52)
  See the summary-statistics vignette for details.

## Improvements:
* Extended the documentation for `logit` and `invlogit` to reference bases R
  methods.

* Added to the examples for `summary_table` showing how to add a caption to a
  LaTeX table (#39)

* step ribbon used in `qkmplot` (#45)

## Bug Fixes
* Factor levels as characters in `summary_table` (#48)

* `qkmplot` works for intercept only models (#38)


# qwraps2 0.2.4

## New Features
* `frmtci.data.frame` method added.
* for the `tab_summary` methods to new arguments: `n_perc_args` and `envir`.
  The former gives the end user control over the formatting options passed to
  `n_perc` and the latter controls the `environment` associated with the
  generated formulae.

## Bug Fixes:
* `frmtci.matrix` using the `est` arg correctly

## Improvements
* extended documentation and examples for `summary_table`

# qwraps2 0.2.3

## New features
* `qacf` plot (#11)
* `ll` an improved version of `ls()`
* `rtitle` option added to `qable` (#35)

## Bug Fixes:
* `perc_n` reports the strings in the correct order.

## Improvements:
* Extended documentation for `qable`
* Minor edits and extensions to the summary-statistics vignette.

# qwraps2 0.2.2

## New Features:
* `summary_table` and `tab_summary` added (#33)
* New vignette `vignette("summary-statistics, package = "qwraps2")`

## Bug Fixes:
* boot strapped statistics in confusion matrices

# qwraps 0.2.1

## New Features:
* `logit` and `invlogit` functions added.  Using Rcpp so they are fast.

## Bug Fixes:
* `format` is correctly passed from `qwraps2::qable` to `knitr::kable`'s
  `format` argument.

# qwraps 0.2.0
This is a long over due version bump.  Many new features and bug fixes have been
made since 0.1.0.

## Bug Fixes:
* `confusion_matrix` produces the correct confusion matrix.  Prior version could
  transpose the result.
* `gmean_sd` displays the correct geometric standard deviation

## Improvements
* `mean_sd` and `gmean_sd` have better `show_n` handling.

## New Features
* `print.confusion_matrix` provides more detail to make it clear which variable
  is the Truth and which is the Prediction.
* `ggplot2_extract_legend` added (#6)
* `show_n` functionality for `median_iqr` implemented.  (closes #24)
* `frmtci` added (#32)
* `mean_ci` added

# qwraps 0.1.4

## Bug Fixes:
* `confusion_matrix.formula` no longer uses named columns.  The function only
  worked when called from `confusion_matrix.default`.  Fix allows the function
  to be used as intended.

# qwraps 0.1.3

## New features
* `gmean_sd` returns the geometric mean and standard deviation

## Notable Changes
* The `confusion_matrix` method has been modified.  Please read the
  documentation.  If you used version 0.1.2 these changes will affect your work.
  The `confusion_matrix` is now an S3 generic.

# qwraps 0.1.2

## New features

* methods for finding the sensitivity and specificity of confusion matrices
  (contingency tables) added.
* `median_iqr` returns a formatted string with the median and IQR of a data vector.
* `perc_n` similar to the `n_perc` but returns a string of the form `p% (n = N)`.
* `n_perc` has option to suppress the percent symbol
* `n_perc0` added in 0.1.1.9004 sets defaults which may be preferred for tables.
* `qkmplot` for plotting Kaplan Meier curves
* `qable` creates `knitr::kable` tables with row groups and names similar to
  `hmisc::latex` or `htmlTable::htmlTable`.

# qwraps 0.1.1
Pushed to CRAN on 20 April 2015.

## New features

* `extract_fstat` extracts the F-statistic from `lm`
* `extract_fpvalue` extracts and formats the omnibus F-test p-value from `lm`
* P-value formatting for [Obstetrics & Gynecology](https://www.editorialmanager.com/ong/default.aspx)

## New vignettes

* none

## Minor improvements

* Set R dependence to 3.0.2 to match the dependence noted for dplyr
* Default setting for the qwraps2_frmtp_digits is 4 instead of 2.
* Spelling and grammar fixes in documentation (#21)

## Bug fixes

* `mean_sd` passes the `digits` option to `frmt` correctly (#20)

# qwraps2 0.1

Initial release.
