/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public final class FastColumnBuilder
extends ColumnBuilder {
    public FastColumnBuilder(int nrows, boolean forceConversion, boolean takeCached, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, String dateTimeFormat) {
        super(nrows, forceConversion, takeCached, evaluator, onErrorCell, dateTimeFormat);
    }

    @Override
    protected void handleCell(Cell c, CellValue cv) {
        switch (cv.getCellType()) {
            case BLANK: {
                this.addMissing();
                break;
            }
            case BOOLEAN: {
                this.addValue(c, cv, DataType.Boolean);
                break;
            }
            case NUMERIC: {
                this.addValue(c, cv, DataType.Numeric);
                break;
            }
            case STRING: {
                this.addValue(c, cv, DataType.String);
                break;
            }
            case FORMULA: {
                this.cellError("Formula detected in already evaluated cell " + CellUtils.formatAsString(c) + "!");
                break;
            }
            case ERROR: {
                this.cellError("Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(cv.getErrorValue()));
                break;
            }
            default: {
                this.cellError("Unexpected cell type detected for cell " + CellUtils.formatAsString(c) + "!");
            }
        }
    }
}

