---
title: "Rdistance NEWS"
---

Changes in version 3.0.0 (2023-06-12)
==============
Version 3.0.0 is a substantial change and upgrade. 

* ***BIGGEST CHANGE***: Measurement units are now required on all distances
(e.g., off-transect distances, strip widths, study area size, etc.),
and it is possible to specify output units.
Unit conversion makes use of the `units` package, is internal, and automatic. 
* ***One-sided Transects***: Added the ability to analyze single-sided transects 
by setting `singleSided` = TRUE in call to `abundEstim`. 
* ***User Requested***: Added computation of bootstrap confidence intervals 
for effective sampling distances (ESW and EDR). 
* ***NA Length Transects***: NA length transects are now allowed. Observations 
on NA length transects are used to estimate distance functions, but are dropped
when estimating density.  This allows, for example, off-transect distance observations
from one study area or year to estimate a distance function which is then applied 
to the observations from another study area or year. 
* Added calculation of target density (number per unit area) 
to `abundEstim`, and it is included in bootstrapping.
* Allowed expansion terms and covariates in the same distance function.
* Renamed `uniform` likelihood to `logistic`. Uniform is now deprecated.
* Added covariates to Gamma likelihood estimation.
* ***Change in default parameter***: Changed default value of `area` in
`abundEstim` from 1 to NULL. NULL now translates to 1 square output 
unit.  
* Added color to print methods.  Results are in green, if the R terminal 
allows it (i.e., in Rstudio, but not R gui).  Errors are in red.
* Reformatted default output to include target density and abundance when 
printing an `abund` object.
* Fixed bug in `F.gx.estim` that occasionally popped up when sighting 
function was monotonically decreasing.
* Updated starting values for faster estimation.
* Decreased lower limit of `negexp` likelihood parameter to achieve more valid
fits. 
* Warning messages now report which parameters are at their boundary, 
and which boundary (lower or upper).
* Bug fixes:
  + Fixed issue with contrasts in `model.matrix`
  + Fixed issue of no observations during bootstrapping
  + Fixed issues with changing scale locations (i.e., `x.scl` and `g.x.sxl`)
  + Fixed `ESW` for `w.lo` > 0
  + Restricted likelihood values to be positive
* Substantial documentation updates
* Substantial testing facilities added. 


Changes in version 2.1.5 (2020-06-17)
==============
* Fixed bug when bootstrap iteration selects zero targets 
* Many updates to vignettes
* Updates to testthat files
* Added descriptive error for case when bySite==T and detection level covariates are present (Issue #72)

Changes in version 2.1.4 (2019-06-11)
==============
* Fixed bug caused by empty factor levels
* Included automated testing (testthat)

Changes in version 2.1.3 (2019-01-02)
==============
* Fixed scaling error in the Gamma likelihood causing mode to be less than 1.0
* Fixed inverted plots that occurred when w.lo > 0 (left-truncatation)
* Fixed bug in 'autoDistSamp' when 'bySite=TRUE'
* Fixed bug causing bootstrap failure of point transect surveys when 'siteData' contained only one column


Changes in version 2.1.2 (2018-08-23)
==============
* Included methods for point transects. Previous version (v1.3.2) allowed only line transects.
* Implemented covariates in the detection functions.
* Implemented non-parametric (smoothed) distance functions
* Enhanced plotting abilities
* Enhanced vignettes
* Many bug fixes
