/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.C45Rules;

import keel.Algorithms.Rule_Learning.C45Rules.Classification;
import keel.Algorithms.Rule_Learning.C45Rules.Cut;
import keel.Algorithms.Rule_Learning.C45Rules.Itemset;
import keel.Algorithms.Rule_Learning.C45Rules.MyDataset;
import keel.Algorithms.Rule_Learning.C45Rules.SelectCut;

public class Tree {
    public static int NumberOfNodes;
    public static int NumberOfLeafs;
    protected SelectCut model;
    protected Cut nodeModel;
    protected Tree[] sons;
    protected boolean isLeaf;
    protected boolean isEmpty;
    protected MyDataset train;
    protected boolean prune = false;
    protected float confidence = 0.25f;

    public Tree(SelectCut selectNodeModel, boolean pruneTree, float cf) {
        this.model = selectNodeModel;
        this.prune = pruneTree;
        this.confidence = cf;
        NumberOfNodes = 0;
        NumberOfLeafs = 0;
    }

    public void buildNode(MyDataset data) throws Exception {
        this.train = data;
        this.isLeaf = false;
        this.isEmpty = false;
        this.sons = null;
        this.nodeModel = this.model.selectModel(data);
        if (this.nodeModel.numSubsets() > 1) {
            MyDataset[] localItemsets = this.nodeModel.cutDataset(data);
            data = null;
            this.sons = new Tree[this.nodeModel.numSubsets()];
            for (int i = 0; i < this.sons.length; ++i) {
                this.sons[i] = this.getNewTree(localItemsets[i]);
                localItemsets[i] = null;
            }
        } else {
            this.isLeaf = true;
            if (data.sumOfWeights() == 0.0) {
                this.isEmpty = true;
            }
            data = null;
        }
    }

    public void buildTree(MyDataset data) throws Exception {
        data = new MyDataset(data);
        data.deleteWithMissing(data.getClassIndex());
        this.buildNode(data);
        this.collapse();
        if (this.prune) {
            this.prune();
        }
    }

    public final void collapse() {
        if (!this.isLeaf) {
            double errorsOfTree;
            double errorsOfSubtree = this.getErrors();
            if (errorsOfSubtree >= (errorsOfTree = this.nodeModel.classification().numIncorrect()) - 0.001) {
                this.sons = null;
                this.isLeaf = true;
                this.nodeModel = new Cut(this.nodeModel.classification());
            } else {
                for (int i = 0; i < this.sons.length; ++i) {
                    this.son(i).collapse();
                }
            }
        }
    }

    public void prune() throws Exception {
        if (!this.isLeaf) {
            double errorsTree;
            for (int i = 0; i < this.sons.length; ++i) {
                this.son(i).prune();
            }
            int indexOfLargestBranch = this.nodeModel.classification().maxValue();
            double errorsLargestBranch = this.son(indexOfLargestBranch).getEstimatedErrorsForBranch(this.train);
            double errorsLeaf = this.getEstimatedErrorsForLeaf(this.nodeModel.classification());
            if (errorsLeaf <= (errorsTree = this.getEstimatedErrors()) + 0.1 && errorsLeaf <= errorsLargestBranch + 0.1) {
                this.sons = null;
                this.isLeaf = true;
                this.nodeModel = new Cut(this.nodeModel.classification());
                return;
            }
            if (errorsLargestBranch <= errorsTree + 0.1) {
                Tree largestBranch = this.son(indexOfLargestBranch);
                this.sons = largestBranch.sons;
                this.nodeModel = largestBranch.nodeModel;
                this.isLeaf = largestBranch.isLeaf;
                this.newClassification(this.train);
                this.prune();
            }
        }
    }

    public final double[] classificationForItemset(Itemset itemset) throws Exception {
        double[] doubles = new double[itemset.numClasses()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = this.getProbabilities(i, itemset, 1.0);
        }
        return doubles;
    }

    private double getProbabilities(int classIndex, Itemset itemset, double weight) throws Exception {
        double prob = 0.0;
        if (this.isLeaf) {
            return weight * this.nodeModel.classProbability(classIndex, itemset, -1);
        }
        int treeIndex = this.nodeModel.whichSubset(itemset);
        if (treeIndex == -1) {
            double[] weights = this.nodeModel.weights(itemset);
            for (int i = 0; i < this.sons.length; ++i) {
                if (this.son((int)i).isEmpty) continue;
                prob += this.son(i).getProbabilities(classIndex, itemset, weights[i] * weight);
            }
            return prob;
        }
        if (this.son((int)treeIndex).isEmpty) {
            return weight * this.nodeModel.classProbability(classIndex, itemset, treeIndex);
        }
        return this.son(treeIndex).getProbabilities(classIndex, itemset, weight);
    }

    public String toString() {
        try {
            StringBuffer text = new StringBuffer();
            if (!this.isLeaf) {
                ++NumberOfNodes;
                this.printTree(0, text);
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Cannot print the tree.";
        }
    }

    private void printTree(int depth, StringBuffer text) throws Exception {
        String aux = "";
        for (int k = 0; k < depth; ++k) {
            aux = aux + "\t";
        }
        for (int i = 0; i < this.sons.length; ++i) {
            text.append(aux);
            if (i == 0) {
                text.append("if ( " + this.nodeModel.leftSide(this.train) + this.nodeModel.rightSide(i, this.train) + " ) then\n" + aux + "{\n");
            } else {
                text.append("elseif ( " + this.nodeModel.leftSide(this.train) + this.nodeModel.rightSide(i, this.train) + " ) then\n" + aux + "{\n");
            }
            if (this.sons[i].isLeaf) {
                ++NumberOfLeafs;
                text.append(aux + "\t" + this.train.getClassAttribute().name() + " = \"" + this.nodeModel.label(i, this.train) + "\"\n");
            } else {
                ++NumberOfNodes;
                this.sons[i].printTree(depth + 1, text);
            }
            text.append(aux + "}\n");
        }
    }

    private Tree son(int index) {
        return this.sons[index];
    }

    protected Tree getNewTree(MyDataset data) throws Exception {
        Tree newNode = new Tree(this.model, this.prune, this.confidence);
        newNode.buildNode(data);
        return newNode;
    }

    private double getEstimatedErrors() {
        double errors = 0.0;
        if (this.isLeaf) {
            return this.getEstimatedErrorsForLeaf(this.nodeModel.classification());
        }
        for (int i = 0; i < this.sons.length; ++i) {
            errors += this.son(i).getEstimatedErrors();
        }
        return errors;
    }

    private double getEstimatedErrorsForBranch(MyDataset data) throws Exception {
        double errors = 0.0;
        if (this.isLeaf) {
            return this.getEstimatedErrorsForLeaf(new Classification(data));
        }
        Classification savedDist = this.nodeModel.classification;
        this.nodeModel.resetClassification(data);
        MyDataset[] localItemsets = this.nodeModel.cutDataset(data);
        this.nodeModel.classification = savedDist;
        for (int i = 0; i < this.sons.length; ++i) {
            errors += this.son(i).getEstimatedErrorsForBranch(localItemsets[i]);
        }
        return errors;
    }

    private double getEstimatedErrorsForLeaf(Classification theClassification) {
        if (theClassification.getTotal() == 0.0) {
            return 0.0;
        }
        return theClassification.numIncorrect() + Tree.errors(theClassification.getTotal(), theClassification.numIncorrect(), this.confidence);
    }

    private double getErrors() {
        double errors = 0.0;
        if (this.isLeaf) {
            return this.nodeModel.classification().numIncorrect();
        }
        for (int i = 0; i < this.sons.length; ++i) {
            errors += this.son(i).getErrors();
        }
        return errors;
    }

    private void newClassification(MyDataset data) throws Exception {
        this.nodeModel.resetClassification(data);
        this.train = data;
        if (!this.isLeaf) {
            MyDataset[] localItemsets = this.nodeModel.cutDataset(data);
            for (int i = 0; i < this.sons.length; ++i) {
                this.son(i).newClassification(localItemsets[i]);
            }
        }
    }

    private static double errors(double N, double e, float CF) {
        double[] Val = new double[]{0.0, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 5.0E-5, 1.0E-4, 5.0E-4, 0.001, 0.005, 0.01, 0.05, 0.1, 0.2, 0.4, 1.0};
        double[] Dev = new double[]{100.0, 6.0, 5.61, 5.2, 4.75, 4.26, 3.89, 3.72, 3.29, 3.09, 2.58, 2.33, 1.65, 1.28, 0.84, 0.25, 0.0};
        double Coeff = 0.0;
        int i = 0;
        while ((double)CF > Val[i]) {
            ++i;
        }
        Coeff = Dev[i - 1] + (Dev[i] - Dev[i - 1]) * ((double)CF - Val[i - 1]) / (Val[i] - Val[i - 1]);
        Coeff *= Coeff;
        if (e == 0.0) {
            return N * (1.0 - Math.exp(Math.log(CF) / N));
        }
        if (e < 0.9999) {
            double Val0 = N * (1.0 - Math.exp(Math.log(CF) / N));
            return Val0 + e * (Tree.errors(N, 1.0, CF) - Val0);
        }
        if (e + 0.5 >= N) {
            return 0.67 * (N - e);
        }
        double Pr = (e + 0.5 + Coeff / 2.0 + Math.sqrt(Coeff * ((e + 0.5) * (1.0 - (e + 0.5) / N) + Coeff / 4.0))) / (N + Coeff);
        return N * Pr - e;
    }

    public int getNChildren() {
        return this.sons.length;
    }

    public Tree getChild(int i) {
        return this.sons[i];
    }
}

