/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray.rec;

import net.sourceforge.jclec.realarray.RealArrayIndividual;
import net.sourceforge.jclec.realarray.UniformCrossover;
import org.apache.commons.lang.builder.EqualsBuilder;

public class LinearCrossover
extends UniformCrossover {
    private static final long serialVersionUID = -1076990295779312238L;

    public boolean equals(Object other) {
        if (other instanceof LinearCrossover) {
            LinearCrossover o = (LinearCrossover)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.locusRecProb, o.locusRecProb);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 3;
    }

    @Override
    public void recombineNext() {
        double[] p0_genome = (double[])((RealArrayIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        double[] p1_genome = (double[])((RealArrayIndividual)this.parentsBuffer.get(this.parentsCounter + 1)).getGenotype();
        double[] s0_genome = new double[this.genotypeLength];
        double[] s1_genome = new double[this.genotypeLength];
        double[] s2_genome = new double[this.genotypeLength];
        int i = 0;
        while (i < this.genotypeLength) {
            if (this.randgen.coin(this.locusRecProb)) {
                s0_genome[i] = this.genotypeSchema[i].nearestOf(0.5 * p0_genome[i] + 0.5 * p1_genome[i]);
                s1_genome[i] = this.genotypeSchema[i].nearestOf(1.5 * p0_genome[i] - 0.5 * p1_genome[i]);
                s2_genome[i] = this.genotypeSchema[i].nearestOf(-0.5 * p0_genome[i] + 1.5 * p1_genome[i]);
            } else {
                s0_genome[i] = p0_genome[i];
                s1_genome[i] = p0_genome[i];
                s2_genome[i] = p1_genome[i];
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(s0_genome));
        this.sonsBuffer.add(this.species.createIndividual(s1_genome));
        this.sonsBuffer.add(this.species.createIndividual(s2_genome));
    }

    @Override
    protected double defaultLocusRecProb() {
        return 0.6;
    }
}

