/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.Serializable;
import java.util.Enumeration;
import keel.Algorithms.Decision_Trees.M5.M5Attribute;
import keel.Algorithms.Decision_Trees.M5.M5Instance;

public class M5Vector
implements Serializable {
    private Object[] m_Objects;
    private int m_Size;
    private int m_CapacityIncrement;
    private double m_CapacityMultiplier;

    public M5Vector() {
        this.m_Objects = new Object[0];
        this.m_Size = 0;
        this.m_CapacityIncrement = 1;
        this.m_CapacityMultiplier = 2.0;
    }

    public M5Vector(int capacity) {
        this.m_Objects = new Object[capacity];
        this.m_Size = 0;
        this.m_CapacityIncrement = 1;
        this.m_CapacityMultiplier = 2.0;
    }

    public M5Vector(int capacity, int capIncrement, double capMultiplier) {
        this.m_Objects = new Object[capacity];
        this.m_Size = 0;
        this.m_CapacityIncrement = capIncrement;
        this.m_CapacityMultiplier = capMultiplier;
    }

    public final void addElement(Object element) {
        if (this.m_Size == this.m_Objects.length) {
            Object[] newObjects = new Object[(int)this.m_CapacityMultiplier * (this.m_Objects.length + this.m_CapacityIncrement)];
            System.arraycopy(this.m_Objects, 0, newObjects, 0, this.m_Size);
            this.m_Objects = newObjects;
        }
        this.m_Objects[this.m_Size] = element;
        ++this.m_Size;
    }

    public final int capacity() {
        return this.m_Objects.length;
    }

    public final Object copy() {
        M5Vector copy = new M5Vector(this.m_Objects.length, this.m_CapacityIncrement, this.m_CapacityMultiplier);
        copy.m_Size = this.m_Size;
        System.arraycopy(this.m_Objects, 0, copy.m_Objects, 0, this.m_Size);
        return copy;
    }

    public final Object copyElements() {
        M5Vector copy = new M5Vector(this.m_Objects.length, this.m_CapacityIncrement, this.m_CapacityMultiplier);
        copy.m_Size = this.m_Size;
        for (int i = 0; i < this.m_Size; ++i) {
            if (this.m_Objects[i] instanceof M5Attribute) {
                copy.m_Objects[i] = ((M5Attribute)this.m_Objects[i]).copy();
                continue;
            }
            if (!(this.m_Objects[i] instanceof M5Instance)) continue;
            copy.m_Objects[i] = ((M5Instance)this.m_Objects[i]).copy();
        }
        return copy;
    }

    public final Object elementAt(int index) {
        return this.m_Objects[index];
    }

    public final Enumeration elements() {
        return new FastVectorEnumeration(this);
    }

    public final Enumeration elements(int index) {
        return new FastVectorEnumeration(this, index);
    }

    public final Object firstElement() {
        return this.m_Objects[0];
    }

    public final int indexOf(Object element) {
        for (int i = 0; i < this.m_Size; ++i) {
            if (!element.equals(this.m_Objects[i])) continue;
            return i;
        }
        return -1;
    }

    public final void insertElementAt(Object element, int index) {
        if (this.m_Size < this.m_Objects.length) {
            System.arraycopy(this.m_Objects, index, this.m_Objects, index + 1, this.m_Size - index);
            this.m_Objects[index] = element;
        } else {
            Object[] newObjects = new Object[(int)this.m_CapacityMultiplier * (this.m_Objects.length + this.m_CapacityIncrement)];
            System.arraycopy(this.m_Objects, 0, newObjects, 0, index);
            newObjects[index] = element;
            System.arraycopy(this.m_Objects, index, newObjects, index + 1, this.m_Size - index);
            this.m_Objects = newObjects;
        }
        ++this.m_Size;
    }

    public final Object lastElement() {
        return this.m_Objects[this.m_Size - 1];
    }

    public final void removeElementAt(int index) {
        System.arraycopy(this.m_Objects, index + 1, this.m_Objects, index, this.m_Size - index - 1);
        --this.m_Size;
    }

    public final void removeAllElements() {
        this.m_Objects = new Object[this.m_Objects.length];
        this.m_Size = 0;
    }

    public final void appendElements(M5Vector toAppend) {
        this.setCapacity(this.size() + toAppend.size());
        System.arraycopy(toAppend.m_Objects, 0, this.m_Objects, this.size(), toAppend.size());
        this.m_Size = this.m_Objects.length;
    }

    public final Object[] toArray() {
        Object[] newObjects = new Object[this.size()];
        System.arraycopy(this.m_Objects, 0, newObjects, 0, this.size());
        return newObjects;
    }

    public final void setCapacity(int capacity) {
        Object[] newObjects = new Object[capacity];
        System.arraycopy(this.m_Objects, 0, newObjects, 0, Math.min(capacity, this.m_Size));
        this.m_Objects = newObjects;
        if (this.m_Objects.length < this.m_Size) {
            this.m_Size = this.m_Objects.length;
        }
    }

    public final void setElementAt(Object element, int index) {
        this.m_Objects[index] = element;
    }

    public final int size() {
        return this.m_Size;
    }

    public final void swap(int first, int second) {
        Object help = this.m_Objects[first];
        this.m_Objects[first] = this.m_Objects[second];
        this.m_Objects[second] = help;
    }

    public final void trimToSize() {
        Object[] newObjects = new Object[this.m_Size];
        System.arraycopy(this.m_Objects, 0, newObjects, 0, this.m_Size);
        this.m_Objects = newObjects;
    }

    public class FastVectorEnumeration
    implements Enumeration {
        private int m_Counter;
        private M5Vector m_Vector;
        private int m_SpecialElement;

        public FastVectorEnumeration(M5Vector vector) {
            this.m_Counter = 0;
            this.m_Vector = vector;
            this.m_SpecialElement = -1;
        }

        public FastVectorEnumeration(M5Vector vector, int special) {
            this.m_Vector = vector;
            this.m_SpecialElement = special;
            this.m_Counter = special == 0 ? 1 : 0;
        }

        @Override
        public final boolean hasMoreElements() {
            return this.m_Counter < this.m_Vector.size();
        }

        public final Object nextElement() {
            Object result = this.m_Vector.elementAt(this.m_Counter);
            ++this.m_Counter;
            if (this.m_Counter == this.m_SpecialElement) {
                ++this.m_Counter;
            }
            return result;
        }
    }
}

