/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;
import keel.Algorithms.Decision_Trees.M5.SimpleStatistics;

public class M5AttrStats {
    public int intCount = 0;
    public int realCount = 0;
    public int missingCount = 0;
    public int distinctCount = 0;
    public int uniqueCount = 0;
    public int totalCount = 0;
    public SimpleStatistics numericStats;
    public int[] nominalCounts;

    protected void addDistinct(double value, int count) {
        if (count > 0) {
            if (count == 1) {
                ++this.uniqueCount;
            }
            if (M5StaticUtils.eq(value, (int)value)) {
                this.intCount += count;
            } else {
                this.realCount += count;
            }
            if (this.nominalCounts != null) {
                this.nominalCounts[(int)value] = count;
            }
            if (this.numericStats != null) {
                this.numericStats.add(value, count);
                this.numericStats.calculateDerived();
            }
        }
        ++this.distinctCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(M5StaticUtils.padLeft("Type", 4)).append(M5StaticUtils.padLeft("Nom", 5));
        sb.append(M5StaticUtils.padLeft("Int", 5)).append(M5StaticUtils.padLeft("Real", 5));
        sb.append(M5StaticUtils.padLeft("Missing", 12));
        sb.append(M5StaticUtils.padLeft("Unique", 12));
        sb.append(M5StaticUtils.padLeft("Dist", 6));
        if (this.nominalCounts != null) {
            sb.append(' ');
            for (int i = 0; i < this.nominalCounts.length; ++i) {
                sb.append(M5StaticUtils.padLeft("C[" + i + "]", 5));
            }
        }
        sb.append('\n');
        long percent = Math.round(100.0 * (double)this.intCount / (double)this.totalCount);
        if (this.nominalCounts != null) {
            sb.append(M5StaticUtils.padLeft("Nom", 4)).append(' ');
            sb.append(M5StaticUtils.padLeft("" + percent, 3)).append("% ");
            sb.append(M5StaticUtils.padLeft("0", 3)).append("% ");
        } else {
            sb.append(M5StaticUtils.padLeft("Num", 4)).append(' ');
            sb.append(M5StaticUtils.padLeft("0", 3)).append("% ");
            sb.append(M5StaticUtils.padLeft("" + percent, 3)).append("% ");
        }
        percent = Math.round(100.0 * (double)this.realCount / (double)this.totalCount);
        sb.append(M5StaticUtils.padLeft("" + percent, 3)).append("% ");
        sb.append(M5StaticUtils.padLeft("" + this.missingCount, 5)).append(" /");
        percent = Math.round(100.0 * (double)this.missingCount / (double)this.totalCount);
        sb.append(M5StaticUtils.padLeft("" + percent, 3)).append("% ");
        sb.append(M5StaticUtils.padLeft("" + this.uniqueCount, 5)).append(" /");
        percent = Math.round(100.0 * (double)this.uniqueCount / (double)this.totalCount);
        sb.append(M5StaticUtils.padLeft("" + percent, 3)).append("% ");
        sb.append(M5StaticUtils.padLeft("" + this.distinctCount, 5)).append(' ');
        if (this.nominalCounts != null) {
            for (int i = 0; i < this.nominalCounts.length; ++i) {
                sb.append(M5StaticUtils.padLeft("" + this.nominalCounts[i], 5));
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

