/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.falco;

import java.util.Comparator;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractEvaluator;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import net.sourceforge.jclec.fitness.ValueFitnessComparator;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;

public class FalcoEvaluator
extends AbstractEvaluator
implements IConfigure {
    private static final long serialVersionUID = 3613350191235561000L;
    protected SyntaxTreeClassificationRule rule;
    protected IDataset dataset;
    private boolean maximize = false;
    protected IRandGen randgen;
    protected int maxDerivSize;
    protected double alpha;
    protected int classifiedClass;
    protected transient ValueFitnessComparator comparator;

    public IDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(IDataset dataset) {
        this.dataset = dataset;
    }

    public void setRandGen(IRandGen randgen) {
        this.randgen = randgen;
    }

    public IRandGen getRandGen() {
        return this.randgen;
    }

    public int getMaxDerivSize() {
        return this.maxDerivSize;
    }

    public void setMaxDerivSize(int maxDerivSize) {
        this.maxDerivSize = maxDerivSize;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public int getClassifiedClass() {
        return this.classifiedClass;
    }

    public void setClassifiedClass(int classifiedClass) {
        this.classifiedClass = classifiedClass;
    }

    @Override
    public void configure(Configuration settings) {
        double alpha = settings.getDouble("alpha");
        this.setAlpha(alpha);
    }

    @Override
    protected void evaluate(IIndividual ind) {
        Individual find = (Individual)ind;
        this.rule = (SyntaxTreeClassificationRule)find.getPhenotype();
        int fails = 0;
        IMetadata metadata = this.getDataset().getMetadata();
        IDataset.IInstance[] instances = this.getDataset().getInstances();
        int numInstances = instances.length;
        int j = 0;
        while (j < numInstances) {
            IDataset.IInstance instance = instances[j];
            double value = instance.getValue(metadata.getClassIndex());
            if (this.rule.covers(instance)) {
                if (value != (double)this.classifiedClass) {
                    ++fails;
                }
            } else if (value == (double)this.classifiedClass) {
                ++fails;
            }
            ++j;
        }
        int numnodes = ((SyntaxTree)((Individual)ind).getGenotype()).derivSize();
        ind.setFitness(new SimpleValueFitness((double)(2 * fails) + this.getAlpha() * (double)numnodes));
    }

    @Override
    public Comparator<IFitness> getComparator() {
        if (this.comparator == null) {
            this.comparator = new ValueFitnessComparator(!this.maximize);
        }
        return this.comparator;
    }
}

