/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.Lists;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MODENAR.myDataset;
import org.core.Randomize;

public class MODENARProcess {
    myDataset ds;
    private String paretos;
    private ArrayList<Chromosome> bestRules;
    private ArrayList<AssociationRule> assoc_rules_Pareto;
    int nGeneration;
    private int nEvaluations;
    private int nRealEvaluations;
    int popSize;
    double CR;
    int threshold;
    double[] Wk;
    private double[] allow_ampl;
    int max_rank;

    public MODENARProcess() {
    }

    public MODENARProcess(myDataset ds, int nEvaluations, int popSize, double cr, int threshold, double[] wk, double AF) {
        this.ds = ds;
        this.popSize = popSize;
        this.CR = cr;
        this.threshold = threshold;
        this.Wk = wk;
        this.nEvaluations = nEvaluations;
        this.paretos = new String("");
        this.allow_ampl = new double[this.ds.getnVars()];
        for (int i = 0; i < this.allow_ampl.length; ++i) {
            this.allow_ampl[i] = (this.ds.getMax(i) - this.ds.getMin(i)) / AF;
        }
    }

    public void run() {
        ArrayList<Chromosome> pop_new = new ArrayList<Chromosome>();
        this.paretos = new String("");
        this.nRealEvaluations = 0;
        int nGen = 0;
        System.out.println("Initialization");
        ArrayList<Chromosome> pop = this.initialize();
        while (!this.terminate()) {
            System.out.println("Generation: " + nGen);
            int count = 0;
            pop = this.remove_dominate_solut(pop);
            if (pop.size() > this.threshold) {
                pop = this.filtrating(pop);
            }
            pop_new = new ArrayList();
            while (pop_new.size() < this.popSize) {
                ArrayList<Chromosome> mutate_parentChromo = this.mutate(pop);
                Chromosome parentChromo = mutate_parentChromo.get(0).copy();
                Chromosome chromo_mutate = mutate_parentChromo.get(1).copy();
                chromo_mutate = this.reparing(chromo_mutate).copy();
                Chromosome chromo_trial = new Chromosome();
                chromo_trial = this.crossover(chromo_mutate.copy(), parentChromo.copy()).copy();
                Chromosome chromo_select = this.select(chromo_trial, parentChromo).copy();
                if (pop_new.size() != 0) {
                    if (!this.equalChromotoPop(chromo_select, pop_new)) {
                        pop_new.add(chromo_select.copy());
                    } else {
                        ++count;
                    }
                    if (count <= 15 || this.equalChromotoPop(chromo_select = chromo_trial.copy(), pop_new)) continue;
                    pop_new.add(chromo_select.copy());
                    continue;
                }
                pop_new.add(chromo_select.copy());
            }
            pop = this.AdjustIntervalPop(pop_new);
            ++nGen;
        }
        this.bestRules = pop;
        this.assign_rank(this.bestRules);
        this.genRules();
        this.printPareto(this.assoc_rules_Pareto);
    }

    public boolean terminate() {
        return this.nRealEvaluations >= this.nEvaluations;
    }

    private ArrayList<Chromosome> initialize() {
        Chromosome c;
        ArrayList<Chromosome> popInit = new ArrayList<Chromosome>();
        int count = 0;
        while (popInit.size() < this.popSize && count < 100) {
            c = this.generateRandomChromo().copy();
            if (popInit.size() != 0) {
                if (!this.equalChromotoPop(c, popInit) && c.getFitness()[0] > 0.0) {
                    popInit.add(c);
                    count = 0;
                    continue;
                }
                ++count;
                continue;
            }
            if (c.getFitness()[0] > 0.0) {
                popInit.add(c);
                count = 0;
                continue;
            }
            ++count;
        }
        while (popInit.size() < this.popSize) {
            c = this.generateChromoWithSupport().copy();
            popInit.add(c);
        }
        return popInit;
    }

    private Chromosome generateRandomChromo() {
        int nVars = this.ds.getnVars();
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (int g = 0; g < nVars; ++g) {
            double ub;
            double lb;
            Gene gen = new Gene();
            int attr = g;
            gen.setAttr(attr);
            gen.setType(this.ds.getAttributeType(attr));
            gen.setCa(Randomize.RandintClosed(0, 2));
            double max_attr = this.ds.getMax(attr);
            double min_attr = this.ds.getMin(attr);
            if (gen.getType() != 0) {
                if (gen.getType() == 2) {
                    lb = Randomize.RanddoubleClosed(min_attr, max_attr);
                    ub = Randomize.RanddoubleClosed(min_attr, max_attr);
                } else {
                    lb = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                    ub = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                }
            } else {
                lb = ub = (double)Randomize.RandintClosed((int)min_attr, (int)max_attr);
            }
            if (lb <= ub) {
                gen.setL(lb);
                gen.setU(ub);
            } else {
                gen.setL(ub);
                gen.setU(lb);
            }
            genes.add(gen.copy());
        }
        int set_antec = Randomize.Randint(0, genes.size());
        int set_cons = Randomize.Randint(0, genes.size());
        while (set_antec == set_cons) {
            set_cons = Randomize.Randint(0, genes.size());
        }
        ((Gene)genes.get(set_antec)).setCa(0);
        ((Gene)genes.get(set_cons)).setCa(1);
        Chromosome c = new Chromosome(genes);
        c.setFitness(this.evaluate_chromosome(c));
        return c;
    }

    private Chromosome generateChromoWithSupport() {
        int nVars = this.ds.getnVars();
        ArrayList<Gene> genes = new ArrayList<Gene>();
        double[][] trans = this.ds.getRealTransactions();
        int tr = Randomize.Randint(0, this.ds.getnTrans());
        for (int g = 0; g < nVars; ++g) {
            double ub;
            double lb;
            Gene gen = new Gene();
            int attr = g;
            gen.setAttr(attr);
            gen.setType(this.ds.getAttributeType(attr));
            gen.setCa(Randomize.RandintClosed(0, 2));
            double max_attr = this.ds.getMax(attr);
            double min_attr = this.ds.getMin(attr);
            if (gen.getType() != 0) {
                if (gen.getType() == 2) {
                    lb = Math.max(trans[tr][attr] - this.allow_ampl[attr] / 2.0, min_attr);
                    ub = Math.min(trans[tr][attr] + this.allow_ampl[attr] / 2.0, max_attr);
                } else {
                    lb = Math.max(trans[tr][attr] - (double)((int)this.allow_ampl[attr] / 2), min_attr);
                    ub = Math.min(trans[tr][attr] + (double)((int)this.allow_ampl[attr] / 2), max_attr);
                }
            } else {
                lb = ub = trans[tr][attr];
            }
            gen.setL(lb);
            gen.setU(ub);
            genes.add(gen.copy());
        }
        int set_antec = Randomize.Randint(0, genes.size() - 1);
        ((Gene)genes.get(set_antec)).setCa(0);
        int set_cons = Randomize.Randint(0, genes.size() - 1);
        while (set_antec == set_cons) {
            set_cons = Randomize.Randint(0, genes.size() - 1);
        }
        ((Gene)genes.get(set_cons)).setCa(1);
        Chromosome c = new Chromosome(genes);
        c.setFitness(this.evaluate_chromosome(c));
        return c;
    }

    private Chromosome select(Chromosome trialChromo, Chromosome parentChromo) {
        Chromosome dominChromo = new Chromosome();
        int dominanc = this.Dominance(trialChromo, parentChromo);
        dominChromo = dominanc != 0 ? (dominanc == 1 ? trialChromo.copy() : parentChromo.copy()) : this.SelectByWeightedFitness(trialChromo, parentChromo);
        return dominChromo;
    }

    private Chromosome crossover(Chromosome mutateChromo, Chromosome parentChromo) {
        int nVars = this.ds.getnVars();
        Chromosome trialChromo = new Chromosome();
        boolean trialchromo_ok = false;
        int count = 0;
        while (!trialchromo_ok) {
            ArrayList<Gene> genes = new ArrayList<Gene>();
            for (int j = 0; j < nVars; ++j) {
                Gene gen = new Gene();
                gen = Randomize.Rand() < this.CR || j == Randomize.Randint(1, nVars) ? mutateChromo.getGenes().get(j).copy() : parentChromo.getGenes().get(j).copy();
                genes.add(gen);
            }
            trialChromo = new Chromosome(genes);
            int set_antec = Randomize.Randint(0, genes.size() - 1);
            genes.get(set_antec).setCa(0);
            int set_cons = Randomize.Randint(0, genes.size() - 1);
            while (set_antec == set_cons) {
                set_cons = Randomize.Randint(0, genes.size() - 1);
            }
            genes.get(set_cons).setCa(1);
            trialChromo.setFitness(this.evaluate_chromosome(trialChromo));
            if (trialChromo.getFitness()[0] > 0.0) {
                trialchromo_ok = true;
            } else {
                ++count;
            }
            if (count <= 20) continue;
            trialchromo_ok = true;
            trialChromo = this.generateChromoWithSupport();
        }
        return trialChromo;
    }

    private ArrayList<Chromosome> mutate(ArrayList<Chromosome> pop) {
        ArrayList<Chromosome> parent_mutate = new ArrayList<Chromosome>();
        boolean mutatechromo_ok = false;
        int count = 0;
        while (!mutatechromo_ok) {
            Chromosome mutateXi;
            int pos_b;
            int pos_a;
            int pos_i;
            boolean allowmutate = false;
            boolean allowmutateXb = false;
            boolean allowmutateXc = false;
            Chromosome Xi = new Chromosome();
            Chromosome Xa = new Chromosome();
            Chromosome Xb = new Chromosome();
            Chromosome Xc = new Chromosome();
            if (pop.size() < 4) {
                if (pop.size() == 3) {
                    while (!allowmutate) {
                        pos_i = Randomize.Randint(0, pop.size());
                        if (pos_i == (pos_a = Randomize.Randint(0, pop.size()))) continue;
                        Xi = pop.get(pos_i).copy();
                        Xa = pop.get(pos_a).copy();
                        allowmutate = true;
                        while (!allowmutateXb) {
                            pos_b = Randomize.Randint(0, pop.size());
                            if (pos_i == pos_b || pos_a == pos_b) continue;
                            allowmutateXb = true;
                            Xb = pop.get(pos_b).copy();
                            while (!allowmutateXc) {
                                Xc = this.generateChromoWithSupport().copy();
                                if (Xi.equals(Xc) || Xa.equals(Xc) || Xb.equals(Xc)) continue;
                                allowmutateXc = true;
                            }
                        }
                    }
                }
                if (pop.size() == 2) {
                    while (!allowmutate) {
                        pos_i = Randomize.Randint(0, pop.size());
                        if (pos_i == (pos_a = Randomize.Randint(0, pop.size()))) continue;
                        Xi = pop.get(pos_i).copy();
                        Xa = pop.get(pos_a).copy();
                        allowmutate = true;
                        while (!allowmutateXb) {
                            Xb = this.generateChromoWithSupport().copy();
                            if (Xi.equals(Xb) || Xa.equals(Xb)) continue;
                            allowmutateXb = true;
                            while (!allowmutateXc) {
                                Xc = this.generateChromoWithSupport().copy();
                                if (Xi.equals(Xc) || Xa.equals(Xc) || Xb.equals(Xc)) continue;
                                allowmutateXc = true;
                            }
                        }
                    }
                }
                if (pop.size() == 1) {
                    while (!allowmutate) {
                        Xi = pop.get(0).copy();
                        if (Xi.equals(Xa = this.generateChromoWithSupport().copy())) continue;
                        allowmutate = true;
                        while (!allowmutateXb) {
                            Xb = this.generateChromoWithSupport().copy();
                            if (Xi.equals(Xb) || Xa.equals(Xb)) continue;
                            allowmutateXb = true;
                            while (!allowmutateXc) {
                                Xc = this.generateChromoWithSupport().copy();
                                if (Xi.equals(Xc) || Xa.equals(Xc) || Xb.equals(Xc)) continue;
                                allowmutateXc = true;
                            }
                        }
                    }
                }
            } else {
                while (!allowmutate) {
                    pos_i = Randomize.Randint(0, pop.size());
                    if (pos_i == (pos_a = Randomize.Randint(0, pop.size()))) continue;
                    Xi = pop.get(pos_i).copy();
                    Xa = pop.get(pos_a).copy();
                    allowmutate = true;
                    while (!allowmutateXb) {
                        pos_b = Randomize.Randint(0, pop.size());
                        if (pos_i == pos_b || pos_a == pos_b) continue;
                        allowmutateXb = true;
                        Xb = pop.get(pos_b).copy();
                        while (!allowmutateXc) {
                            int pos_c = Randomize.Randint(0, pop.size());
                            if (pos_i == pos_c || pos_a == pos_c || pos_b == pos_c) continue;
                            allowmutateXc = true;
                            Xc = pop.get(pos_c).copy();
                        }
                    }
                }
            }
            if ((mutateXi = this.generateMutanteRandDE(Xi, Xa, Xb, Xc)).getFitness()[0] > 0.0) {
                parent_mutate.add(Xi.copy());
                parent_mutate.add(mutateXi.copy());
                mutatechromo_ok = true;
                count = 0;
            } else {
                ++count;
            }
            if (count <= 15) continue;
            count = 0;
            Xi = new Chromosome();
            boolean allowmutateXi = false;
            while (!allowmutateXi) {
                Xi = this.generateChromoWithSupport().copy();
                if (Xc.equals(Xi) || Xa.equals(Xi) || Xb.equals(Xi)) continue;
                allowmutateXi = true;
            }
            mutateXi = this.generateMutanteRandDE(Xi, Xa, Xb, Xc);
            parent_mutate.add(Xi.copy());
            parent_mutate.add(mutateXi.copy());
            mutatechromo_ok = true;
        }
        return parent_mutate;
    }

    private Chromosome reparing(Chromosome chromo) {
        for (int i = 0; i < chromo.getGenes().size(); ++i) {
            Gene gen = chromo.getGenes().get(i);
            if (gen.getL() > gen.getU()) {
                double aux = gen.getL();
                gen.setL(gen.getU());
                gen.setU(aux);
            }
            if (gen.getL() < this.ds.getMin(i)) {
                double L = (gen.getL() + this.ds.getMin(i)) / 2.0;
                gen.setL(L);
            }
            if (gen.getU() > this.ds.getMax(i)) {
                double U = (gen.getU() + this.ds.getMax(i)) / 2.0;
                gen.setU(U);
            }
            chromo.getGenes().set(i, gen);
        }
        return chromo;
    }

    private ArrayList<Chromosome> filtrating(ArrayList<Chromosome> pop) {
        ArrayList<Double> distEucAveList = new ArrayList<Double>();
        ArrayList<Integer> posChromo = new ArrayList<Integer>();
        ArrayList<Chromosome> chromo_List = new ArrayList<Chromosome>();
        double distEuclid_x = 0.0;
        double distEuclidAve_x = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            Chromosome chromo_x = pop.get(i);
            double minDist_i = this.DistanceEuclidea(pop.get(i), pop.get(1));
            double minDist_j = this.DistanceEuclidea(pop.get(i), pop.get(2));
            for (int j = i + 1; j < pop.size(); ++j) {
                Chromosome chromo_j = pop.get(j);
                distEuclid_x = this.DistanceEuclidea(chromo_x, chromo_j);
                if (distEuclid_x < minDist_i) {
                    minDist_i = distEuclid_x;
                    continue;
                }
                if (!(distEuclid_x < minDist_j)) continue;
                minDist_j = distEuclid_x;
            }
            distEuclidAve_x = (minDist_i + minDist_j) / 2.0;
            boolean insert = false;
            int k = 0;
            if (distEucAveList.size() == 0) {
                distEucAveList.add(0, distEuclidAve_x);
                insert = true;
            }
            while (!insert && k < distEucAveList.size()) {
                if (distEuclidAve_x < (Double)distEucAveList.get(k)) {
                    distEucAveList.add(k, distEuclidAve_x);
                    chromo_List.add(k, chromo_x);
                    posChromo.add(k, i);
                    insert = true;
                } else {
                    distEucAveList.add(distEuclidAve_x);
                    posChromo.add(i);
                    chromo_List.add(chromo_x);
                    insert = true;
                }
                ++k;
            }
        }
        int l = 0;
        while (pop.size() > this.threshold) {
            pop.remove(chromo_List.get(l));
            ++l;
        }
        return pop;
    }

    private double[] evaluate_chromosome(Chromosome chromo) {
        double[] fitness = new double[4];
        double comprehensibility = 0.0;
        double amplitudeInterv = 0.0;
        AssociationRule rule = this.getRule(chromo);
        fitness[0] = rule.getAll_support();
        fitness[1] = rule.getConfidence();
        fitness[2] = comprehensibility = Math.log10(1 + rule.getAntecedent().size()) / Math.log10(1 + rule.getAntecedent().size() + rule.getConsequent().size());
        int countAttbRule = rule.getAntecedent().size() + rule.getConsequent().size();
        double sumInterv = 0.0;
        for (int i = 0; i < chromo.getGenes().size(); ++i) {
            Gene gen = chromo.getGenes().get(i);
            if (gen.getCa() == 2 || this.ds.getMax(i) - this.ds.getMin(i) == 0.0) continue;
            sumInterv += (gen.getU() - gen.getL()) / (this.ds.getMax(i) - this.ds.getMin(i));
        }
        double div_countAttbRule = 1.0 / (double)countAttbRule;
        fitness[3] = amplitudeInterv = Math.abs(1.0 - div_countAttbRule * sumInterv);
        chromo.setRuleSupport(rule.getAll_support());
        chromo.setRuleConfidence(rule.getConfidence());
        ++this.nRealEvaluations;
        return fitness;
    }

    private ArrayList<Chromosome> remove_dominate_solut(ArrayList<Chromosome> pop) {
        for (int j = 0; j < pop.size(); ++j) {
            for (int k = j + 1; k < pop.size(); ++k) {
                if (this.Dominance(pop.get(j), pop.get(k)) == 1) {
                    pop.remove(k);
                    continue;
                }
                if (this.Dominance(pop.get(j), pop.get(k)) != -1) continue;
                pop.remove(j);
            }
        }
        return pop;
    }

    private int Dominance(Chromosome chromo_a, Chromosome chromo_b) {
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = 0; i < chromo_a.getFitness().length; ++i) {
            if (chromo_a.getFitness()[i] > chromo_b.getFitness()[i]) {
                flag1 = true;
                continue;
            }
            if (!(chromo_a.getFitness()[i] < chromo_b.getFitness()[i])) continue;
            flag2 = true;
        }
        if (flag1 && !flag2) {
            return 1;
        }
        if (!flag1 && flag2) {
            return -1;
        }
        return 0;
    }

    private Chromosome SelectByWeightedFitness(Chromosome chromo1, Chromosome chromo2) {
        if (this.calculate_WeightedFitness(chromo1) > this.calculate_WeightedFitness(chromo2)) {
            return chromo1;
        }
        return chromo2;
    }

    private double calculate_WeightedFitness(Chromosome chromo) {
        double weightChromo = 0.0;
        for (int i = 0; i < chromo.getFitness().length; ++i) {
            weightChromo += this.Wk[i] * chromo.getFitness()[i];
        }
        return weightChromo;
    }

    private ArrayList<Chromosome> AdjustIntervalPop(ArrayList<Chromosome> pop) {
        for (int i = 0; i < pop.size(); ++i) {
            pop.set(i, this.AdjustIntervalChromo(pop.get(i)));
        }
        return pop;
    }

    private Chromosome AdjustIntervalChromo(Chromosome chromo) {
        ArrayList<Object> tid_list = new ArrayList();
        double[][] examples = this.ds.getRealTransactions();
        tid_list = this.countSupport(chromo.getGenes());
        if (tid_list.size() != 0) {
            for (int g = 0; g < chromo.getGenes().size(); ++g) {
                int attr = chromo.getGenes().get(g).getAttr();
                double minlb = examples[(Integer)tid_list.get(0)][attr];
                double maxub = examples[(Integer)tid_list.get(0)][attr];
                for (int t = 1; t < tid_list.size(); ++t) {
                    if (examples[(Integer)tid_list.get(t)][attr] < minlb) {
                        minlb = examples[t][attr];
                    }
                    if (!(examples[t][attr] > maxub)) continue;
                    maxub = examples[t][attr];
                }
                chromo.getGenes().get(g).setL(minlb);
                chromo.getGenes().get(g).setU(maxub);
            }
        }
        return chromo;
    }

    private Chromosome generateMutanteRandDE(Chromosome Xi, Chromosome Xa, Chromosome Xb, Chromosome Xc) {
        double genL = 0.0;
        double genU = 0.0;
        Chromosome mutateChromo = new Chromosome();
        mutateChromo = Xi.copy();
        for (int i = 0; i < this.ds.getnVars(); ++i) {
            Gene gen = mutateChromo.getGenes().get(i);
            boolean allowed_gen = false;
            int count = 0;
            while (!allowed_gen) {
                if (gen.getType() != 0) {
                    if (gen.getType() == 2) {
                        genL = Math.abs(Xa.getGenes().get(i).getL() + Randomize.RandGaussian() * (Xb.getGenes().get(i).getL() - Xc.getGenes().get(i).getL()));
                        genU = Math.abs(Xa.getGenes().get(i).getU() + Randomize.RandGaussian() * (Xb.getGenes().get(i).getU() - Xc.getGenes().get(i).getU()));
                    }
                    if (gen.getType() == 1) {
                        genL = Math.abs(Xa.getGenes().get(i).getL() + (double)Math.round(Randomize.RandGaussian() * (Xb.getGenes().get(i).getL() - Xc.getGenes().get(i).getL())));
                        genU = Math.abs(Xa.getGenes().get(i).getU() + (double)Math.round(Randomize.RandGaussian() * (Xb.getGenes().get(i).getU() - Xc.getGenes().get(i).getU())));
                    }
                } else {
                    genL = genU = (double)Randomize.RandintClosed((int)this.ds.getMin(Xa.getGenes().get(i).getAttr()), (int)this.ds.getMax(Xa.getGenes().get(i).getAttr()));
                }
                if (genL > genU) {
                    double aux = genL;
                    genL = genU;
                    genU = aux;
                }
                if (genL >= this.ds.getMin(i) && genU <= this.ds.getMax(i)) {
                    allowed_gen = true;
                } else {
                    ++count;
                }
                if (count > 15) {
                    allowed_gen = true;
                    if (gen.getL() < this.ds.getMin(i)) {
                        genL = (gen.getL() + this.ds.getMin(i)) / 2.0;
                    }
                    if (gen.getU() > this.ds.getMax(i)) {
                        genU = (gen.getU() + this.ds.getMax(i)) / 2.0;
                    }
                }
                mutateChromo.getGenes().get(i).setL(genL);
                mutateChromo.getGenes().get(i).setU(genU);
            }
        }
        mutateChromo.setFitness(this.evaluate_chromosome(mutateChromo));
        return mutateChromo;
    }

    private AssociationRule getRule(Chromosome chromo) {
        double nData = this.ds.getnTrans();
        AssociationRule rule = new AssociationRule();
        ArrayList<Gene> genes_ant = new ArrayList<Gene>();
        ArrayList<Gene> genes_cons = new ArrayList<Gene>();
        ArrayList<Gene> genes_all = new ArrayList<Gene>();
        for (int j = 0; j < this.ds.getnVars(); ++j) {
            if (chromo.getGenes().get(j).getCa() == 0) {
                rule.addAntecedent(chromo.getGenes().get(j).copy());
                genes_ant.add(chromo.getGenes().get(j));
                genes_all.add(chromo.getGenes().get(j));
            }
            if (chromo.getGenes().get(j).getCa() != 1) continue;
            rule.addConsequent(chromo.getGenes().get(j).copy());
            genes_cons.add(chromo.getGenes().get(j));
            genes_all.add(chromo.getGenes().get(j));
        }
        ArrayList<Integer> tid_lst_all = this.countSupport(genes_all);
        double all_sup = (double)tid_lst_all.size() / nData;
        ArrayList<Integer> tid_lst_ant = this.countSupport(genes_ant);
        double ant_sup = (double)tid_lst_ant.size() / nData;
        ArrayList<Integer> tid_lst_cons = this.countSupport(genes_cons);
        double cons_sup = (double)tid_lst_cons.size() / nData;
        double confidance = ant_sup == 0.0 || all_sup == 0.0 ? 0.0 : all_sup / ant_sup;
        rule.setSupport(ant_sup);
        rule.setAll_support(all_sup);
        rule.setSupport_consq(cons_sup);
        rule.setConfidence(confidance);
        return rule;
    }

    private int numCoveredRecords() {
        int i;
        int nTrans = this.ds.getnTrans();
        boolean[] marked = new boolean[nTrans];
        for (i = 0; i < nTrans; ++i) {
            marked[i] = false;
        }
        for (i = 0; i < this.bestRules.size(); ++i) {
            Chromosome chromo = this.bestRules.get(i);
            ArrayList<Gene> genes_all = new ArrayList<Gene>();
            for (int k = 0; k < this.ds.getnVars(); ++k) {
                if (chromo.getGenes().get(k).getCa() == 2) continue;
                genes_all.add(chromo.getGenes().get(k));
            }
            if (chromo.rank >= 2) continue;
            ArrayList<Integer> tidCovered = this.countSupport(genes_all);
            for (int j = 0; j < tidCovered.size(); ++j) {
                marked[tidCovered.get((int)j).intValue()] = true;
            }
        }
        int covered = 0;
        for (i = 0; i < nTrans; ++i) {
            if (!marked[i]) continue;
            ++covered;
        }
        return covered;
    }

    private void genRules() {
        double nData = this.ds.getnTrans();
        this.assoc_rules_Pareto = new ArrayList();
        for (int i = 0; i < this.bestRules.size(); ++i) {
            Chromosome chromo = this.bestRules.get(i);
            if (chromo.rank >= 2) continue;
            AssociationRule rule = new AssociationRule();
            ArrayList<Gene> genes_ant = new ArrayList<Gene>();
            ArrayList<Gene> genes_cons = new ArrayList<Gene>();
            ArrayList<Gene> genes_all = new ArrayList<Gene>();
            for (int j = 0; j < this.ds.getnVars(); ++j) {
                if (chromo.getGenes().get(j).getCa() == 0) {
                    rule.addAntecedent(chromo.getGenes().get(j).copy());
                    genes_ant.add(chromo.getGenes().get(j));
                    genes_all.add(chromo.getGenes().get(j));
                }
                if (chromo.getGenes().get(j).getCa() != 1) continue;
                rule.addConsequent(chromo.getGenes().get(j).copy());
                genes_cons.add(chromo.getGenes().get(j));
                genes_all.add(chromo.getGenes().get(j));
            }
            ArrayList<Integer> tid_lst_all = this.countSupport(genes_all);
            double all_sup = (double)tid_lst_all.size() / nData;
            ArrayList<Integer> tid_lst_cons = this.countSupport(genes_cons);
            double cons_sup = (double)tid_lst_cons.size() / nData;
            ArrayList<Integer> tid_lst_ant = this.countSupport(genes_ant);
            double ant_sup = (double)tid_lst_ant.size() / nData;
            rule.setSupport(ant_sup);
            rule.setSupport_consq(cons_sup);
            rule.setAll_support(all_sup);
            double confidance = all_sup != 0.0 ? all_sup / ant_sup : 0.0;
            double lift = cons_sup == 0.0 || ant_sup == 0.0 ? 1.0 : all_sup / (ant_sup * cons_sup);
            double conv = cons_sup == 1.0 || ant_sup == 0.0 ? 1.0 : ant_sup * (1.0 - cons_sup) / (ant_sup - all_sup);
            double netConf = ant_sup == 0.0 || ant_sup == 1.0 || Math.abs(ant_sup * (1.0 - ant_sup)) <= 0.001 ? 0.0 : (all_sup - ant_sup * cons_sup) / (ant_sup * (1.0 - ant_sup));
            double numeratorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) - (ant_sup - all_sup) * (cons_sup - all_sup);
            double denominatorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) + (ant_sup - all_sup) * (cons_sup - all_sup);
            double yulesQ = ant_sup == 0.0 || ant_sup == 1.0 || cons_sup == 0.0 || cons_sup == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
            double CF = 0.0;
            if (confidance > cons_sup) {
                CF = (confidance - cons_sup) / (1.0 - cons_sup);
            } else if (confidance < cons_sup) {
                CF = (confidance - cons_sup) / cons_sup;
            }
            rule.setConfidence(confidance);
            rule.setLift(lift);
            rule.setConv(conv);
            rule.setCF(CF);
            rule.setNetConf(netConf);
            rule.setYulesQ(yulesQ);
            rule.setComprehensibility(chromo.getFitness()[2]);
            rule.setAmplitudeInterv(chromo.getFitness()[3]);
            this.assoc_rules_Pareto.add(rule);
        }
    }

    private ArrayList<Integer> countSupport(ArrayList<Gene> genes) {
        ArrayList<Integer> tid_list = new ArrayList<Integer>();
        double[][] trans = this.ds.getRealTransactions();
        int nTrans = this.ds.getnTrans();
        for (int t = 0; t < nTrans; ++t) {
            boolean ok = true;
            for (int g = 0; g < genes.size() && ok; ++g) {
                int attr = genes.get(g).getAttr();
                double lb = genes.get(g).getL();
                double ub = genes.get(g).getU();
                if (!(trans[t][attr] < lb) && !(trans[t][attr] > ub)) continue;
                ok = false;
            }
            if (!ok) continue;
            tid_list.add(t);
        }
        return tid_list;
    }

    private double DistanceEuclidea(Chromosome chromo_a, Chromosome chromo_b) {
        double suma_lb_ub = 0.0;
        double suma = 0.0;
        for (int i = 0; i < chromo_a.getGenes().size(); ++i) {
            double lb_a = chromo_a.getGenes().get(i).getL();
            double ub_a = chromo_a.getGenes().get(i).getU();
            double lb_b = chromo_b.getGenes().get(i).getL();
            double ub_b = chromo_b.getGenes().get(i).getU();
            double resta_lb = lb_a - lb_b;
            double resta_ub = ub_a - ub_b;
            suma_lb_ub = resta_lb + resta_ub;
            suma += Math.pow(suma_lb_ub, 2.0);
        }
        double DistEuclidea = Math.sqrt(suma);
        return DistEuclidea;
    }

    private boolean equalChromotoPop(Chromosome chromo_a, ArrayList<Chromosome> pop) {
        boolean equal_chr = false;
        for (int i = 0; !equal_chr && i < pop.size(); ++i) {
            if (!chromo_a.equals(pop.get(i))) continue;
            equal_chr = true;
        }
        return equal_chr;
    }

    public ArrayList<Chromosome> getBestrules() {
        return this.bestRules;
    }

    public void setBestrules(ArrayList<Chromosome> bestrules) {
        this.bestRules = bestrules;
    }

    public double getCR() {
        return this.CR;
    }

    public void setCR(double cr) {
        this.CR = cr;
    }

    public myDataset getDs() {
        return this.ds;
    }

    public void setDs(myDataset ds) {
        this.ds = ds;
    }

    public int getPopSize() {
        return this.popSize;
    }

    public void setPopSize(int popSize) {
        this.popSize = popSize;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public double[] getWk() {
        return this.Wk;
    }

    public void setWk(double[] wk) {
        this.Wk = wk;
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        int length = 0;
        int countRules = 0;
        double avg_netConf = 0.0;
        double avg_CF = 0.0;
        double avg_conv = 0.0;
        double avg_lift = 0.0;
        double avg_conf = 0.0;
        double avg_sup = 0.0;
        double avg_yulesQ = 0.0;
        for (int i = 0; i < rules.size(); ++i) {
            AssociationRule rule = rules.get(i);
            ++countRules;
            length += rule.getLengthAntecedent() + rule.getLengthConsequent();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        w.println("\nNumber of Frequent Itemsets found: -");
        System.out.println("\nNumber of Frequent Itemsets found: -");
        w.println("\nNumber of Association Rules generated: " + countRules);
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            w.println("Average Support: " + MODENARProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average SupportRules: " + MODENARProcess.roundDouble(avg_sup / (double)countRules, 2));
            w.println("Average Confidence: " + MODENARProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Confidence: " + MODENARProcess.roundDouble(avg_conf / (double)countRules, 2));
            w.println("Average Lift: " + MODENARProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Lift: " + MODENARProcess.roundDouble(avg_lift / (double)countRules, 2));
            w.println("Average Conviction: " + MODENARProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Conviction: " + MODENARProcess.roundDouble(avg_conv / (double)countRules, 2));
            w.println("Average Certain Factor: " + MODENARProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + MODENARProcess.roundDouble(avg_CF / (double)countRules, 2));
            w.println("Average Netconf: " + MODENARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average Netconf: " + MODENARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            w.println("Average YulesQ: " + MODENARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average yulesQ: " + MODENARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            w.println("Average Number of Antecedents: " + MODENARProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Average Number of Antecedents: " + MODENARProcess.roundDouble((double)length / (double)countRules, 2));
            w.println("Number of Covered Records (%): " + MODENARProcess.roundDouble(100.0 * (double)this.numCoveredRecords() / (double)this.ds.getnTrans(), 2));
            System.out.println("Number of Covered Records (%): " + MODENARProcess.roundDouble(100.0 * (double)this.numCoveredRecords() / (double)this.ds.getnTrans(), 2));
        } else {
            System.out.println("No Statistics.");
        }
    }

    public void printPareto(ArrayList<AssociationRule> rulesPareto) {
        this.paretos = this.paretos + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < this.assoc_rules_Pareto.size(); ++i) {
            AssociationRule rule = this.assoc_rules_Pareto.get(i);
            this.paretos = this.paretos + "" + MODENARProcess.roundDouble(rule.getAll_support(), 2) + "\t" + MODENARProcess.roundDouble(rule.getSupport(), 2) + "\t" + MODENARProcess.roundDouble(rule.getSupport_consq(), 2) + "\t" + MODENARProcess.roundDouble(rule.getConfidence(), 2) + "\t" + MODENARProcess.roundDouble(rule.getLift(), 2) + "\t" + MODENARProcess.roundDouble(rule.getConv(), 2) + "\t" + MODENARProcess.roundDouble(rule.getCF(), 2) + "\t" + MODENARProcess.roundDouble(rule.getNetConf(), 2) + "\t" + MODENARProcess.roundDouble(rule.getYulesQ(), 2) + "\t" + (rule.getLengthAntecedent() + rule.getLengthConsequent()) + "\n";
        }
    }

    public String getParetos() {
        return this.paretos;
    }

    public ArrayList<AssociationRule> getAssoc_rules_Pareto() {
        return this.assoc_rules_Pareto;
    }

    private void assign_rank(ArrayList<Chromosome> new_pop) {
        int rank = 1;
        Lists orig = new Lists();
        Lists cur = new Lists();
        int front_size = 0;
        Lists temp1 = orig;
        for (int i = 0; i < new_pop.size(); ++i) {
            temp1.insert(temp1, i);
            temp1 = temp1.child;
        }
        do {
            if (orig.child.child == null) {
                new_pop.get((int)orig.child.index).rank = rank;
                break;
            }
            temp1 = orig.child;
            temp1.insert(cur, temp1.index);
            front_size = 1;
            Lists temp2 = cur.child;
            temp1 = temp1.del(temp1);
            temp1 = temp1.child;
            do {
                int flag;
                boolean end;
                temp2 = cur.child;
                do {
                    end = false;
                    flag = this.Dominance(new_pop.get(temp1.index), new_pop.get(temp2.index));
                    if (flag == 1) {
                        temp1.insert(orig, temp2.index);
                        temp2 = temp2.del(temp2);
                        --front_size;
                        temp2 = temp2.child;
                    }
                    if (flag == 0) {
                        temp2 = temp2.child;
                    }
                    if (flag != -1) continue;
                    end = true;
                } while (!end && temp2 != null);
                if (flag != 0 && flag != 1) continue;
                temp1.insert(cur, temp1.index);
                ++front_size;
                temp1 = temp1.del(temp1);
            } while ((temp1 = temp1.child) != null);
            temp2 = cur.child;
            do {
                new_pop.get((int)temp2.index).rank = rank;
            } while ((temp2 = temp2.child) != null);
            temp2 = cur.child;
            do {
                temp2 = temp2.del(temp2);
                temp2 = temp2.child;
            } while (cur.child != null);
            ++rank;
        } while (orig.child != null);
        this.max_rank = rank;
    }
}

