/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree.mut;

import net.sf.jclec.IPopulation;
import net.sf.jclec.syntaxtree.ISyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.NonTerminalNode;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sf.jclec.syntaxtree.SyntaxTreeMutator;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandNTMutator<I extends SyntaxTreeIndividual>
extends SyntaxTreeMutator<I> {
    private static final long serialVersionUID = -2706522794304044852L;

    public ExpandNTMutator() {
    }

    public ExpandNTMutator(IPopulation<I> context) {
        this.contextualize(context);
    }

    public boolean equals(Object other) {
        if (other instanceof ExpandNTMutator) {
            ExpandNTMutator o = (ExpandNTMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.targetTreeIndex, o.targetTreeIndex);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected SyntaxTree mutateTree(SyntaxTree parent, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        SyntaxTree son = new SyntaxTree();
        int p0_branchStart = this.selectSymbol(parent, schema);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            return son;
        }
        NonTerminalNode selectedSymbol = (NonTerminalNode)parent.getNode(p0_branchStart);
        int p0_branchEnd = parent.subTree(p0_branchStart);
        int p0_branchDepth = parent.derivSize();
        int p0_swapBranch = 0;
        int i = p0_branchStart;
        while (i < p0_branchEnd) {
            if (parent.getNode(i).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i;
        }
        i = 0;
        while (i < p0_branchStart) {
            son.addNode(parent.getNode(i).copy());
            ++i;
        }
        int nMaxOfDer = schema.getMaxDerivSize() - p0_branchDepth + p0_swapBranch;
        int nOfDer = this.randgen.choose(p0_swapBranch + 1, nMaxOfDer);
        schema.fillSyntaxBranch(son, selectedSymbol.getSymbol(), nOfDer, this.randgen);
        int i2 = p0_branchEnd;
        while (i2 < parent.size()) {
            son.addNode(parent.getNode(i2).copy());
            ++i2;
        }
        return son;
    }

    private final int selectSymbol(SyntaxTree tree, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = this.randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!schema.isTerminal(tree.getNode(actPos).getSymbol())) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

