/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes;

import java.util.Vector;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes.Genotype;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.Node;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeAdd;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeExp;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeExprArit;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeExprHold;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeLog;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeMinus;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeProduct;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeSquareRoot;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeValue;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeVariable;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyAlphaCut;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyInterval;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRIANG;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzySingleton;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import org.core.Randomize;

public class GenotypeFuzzyGPRegSym
extends Genotype {
    static int MAXH;
    static int LENCADENA;
    Node rootNode;
    Vector theNodes;
    Vector theParents;
    Vector theDepthAtEachNode;
    static double KMAX;
    static double KMIN;
    static int nInputs;
    static int typeOfValue;
    FuzzyAlphaCut[] fsChain;

    public GenotypeFuzzyGPRegSym(double kmin, double kmax, int pNInputs, int cteType, int vChainLength, int mh, Randomize r) {
        super(r);
        this.theNodes = new Vector();
        this.theParents = new Vector();
        this.theDepthAtEachNode = new Vector();
        this.rootNode = new NodeExprHold(new NodeExprArit[0]);
        KMIN = kmin;
        KMAX = kmax;
        nInputs = pNInputs;
        typeOfValue = cteType;
        LENCADENA = vChainLength;
        MAXH = mh;
        this.fsChain = new FuzzyAlphaCut[LENCADENA];
        this.RandomCadena();
    }

    public GenotypeFuzzyGPRegSym(GenotypeFuzzyGPRegSym p) {
        super(rand);
        this.rootNode = p.rootNode.clone();
        this.fsChain = new FuzzyAlphaCut[LENCADENA];
        for (int i = 0; i < p.fsChain.length; ++i) {
            this.fsChain[i] = (FuzzyAlphaCut)p.fsChain[i].clone();
        }
        this.buildNodeLists();
    }

    public void setTree(GenotypeFuzzyGPRegSym p) {
        this.rootNode = p.rootNode.clone();
        this.fsChain = new FuzzyAlphaCut[LENCADENA];
        for (int i = 0; i < p.fsChain.length; ++i) {
            this.fsChain[i] = (FuzzyAlphaCut)p.fsChain[i].clone();
        }
        this.buildNodeLists();
    }

    @Override
    public boolean isRelated(Genotype g) {
        if (!(g instanceof GenotypeFuzzyGPRegSym)) {
            return false;
        }
        GenotypeFuzzyGPRegSym p = (GenotypeFuzzyGPRegSym)g;
        return this.rootNode.compatible(p.rootNode);
    }

    @Override
    public Genotype clone() {
        return new GenotypeFuzzyGPRegSym(this);
    }

    public void rebuild(Genotype g) {
    }

    public int getNumInputs() {
        return nInputs;
    }

    @Override
    public void mutation(double AMPL, int mutationID) throws invalidMutation {
        if (mutationID != 1003 && mutationID != 1004) {
            throw new invalidMutation();
        }
        if (mutationID == 1003) {
            GenotypeFuzzyGPRegSym randomGenotype = new GenotypeFuzzyGPRegSym(KMIN, KMAX, nInputs, typeOfValue, LENCADENA, MAXH, rand);
            randomGenotype.RandomCadena();
            double alpha = AMPL * (-0.1 + 0.6 * rand.Rand());
            for (int i = 0; i < this.fsChain.length; ++i) {
                this.fsChain[i].linearComb(this.fsChain[i], randomGenotype.fsChain[i], alpha);
            }
        } else {
            int mutationPoint = 0;
            mutationPoint = (int)(rand.Rand() * (double)(this.theNodes.size() - 1)) + 1;
            Node tmp = (Node)this.theNodes.elementAt(mutationPoint);
            int typeOfValue = tmp.type();
            int nh = -1;
            tmp = (Node)this.theParents.elementAt(mutationPoint);
            for (int i = 0; i < tmp.nChildren(); ++i) {
                Node tmp1 = (Node)this.theParents.elementAt(mutationPoint);
                Node tmp2 = (Node)this.theNodes.elementAt(mutationPoint);
                if (tmp1.child(i) != tmp2) continue;
                nh = i;
                break;
            }
            tmp = (Node)this.theNodes.elementAt(mutationPoint);
            int T = tmp.type();
            int TN = 10;
            int val = (int)(rand.Rand() * 8.0);
            if (val == 0) {
                TN = 0;
            } else if (val == 1) {
                TN = 10;
            } else if (val == 2) {
                TN = 11;
            } else if (val == 3) {
                TN = 12;
            } else if (val == 4) {
                TN = 13;
            } else if (val == 5) {
                TN = 14;
            } else if (val == 6) {
                TN = 16;
            } else if (val == 7) {
                TN = 15;
            }
            int par = (int)(rand.Rand() * (double)this.getNumInputs());
            tmp = (Node)this.theParents.elementAt(mutationPoint);
            Integer itmp = (Integer)this.theDepthAtEachNode.elementAt(mutationPoint);
            tmp.changeChild(this.RandomTree(TN, MAXH - itmp, par), nh);
            this.buildNodeLists();
        }
    }

    @Override
    public void crossover(Genotype p2, Genotype p3, Genotype p4, int crossoverID) throws invalidCrossover {
        if (crossoverID != 1001 && crossoverID != 1002) {
            throw new invalidCrossover();
        }
        GenotypeFuzzyGPRegSym f2 = (GenotypeFuzzyGPRegSym)p2;
        GenotypeFuzzyGPRegSym f3 = (GenotypeFuzzyGPRegSym)p3;
        GenotypeFuzzyGPRegSym f4 = (GenotypeFuzzyGPRegSym)p4;
        f3.setTree(this);
        f4.setTree(f2);
        if (crossoverID == 1001) {
            double alpha = -0.1 + 0.6 * rand.Rand();
            for (int i = 0; i < this.fsChain.length; ++i) {
                f3.fsChain[i].linearComb(this.fsChain[i], f2.fsChain[i], alpha);
                f4.fsChain[i].linearComb(this.fsChain[i], f2.fsChain[i], 1.0 - alpha);
            }
        } else {
            int firstCrossPoint = 0;
            firstCrossPoint = (int)(rand.Rand() * (double)(f3.theNodes.size() - 1)) + 1;
            Node tmp = (Node)f3.theNodes.elementAt(firstCrossPoint);
            int typeOfValue = tmp.type();
            tmp = (Node)f3.theNodes.elementAt(firstCrossPoint);
            int T1 = tmp.type();
            Vector<Integer> ableToCrossNodes = new Vector<Integer>();
            for (int i = 0; i < f4.theNodes.size(); ++i) {
                tmp = (Node)f4.theNodes.elementAt(i);
                typeOfValue = tmp.type();
                Integer itmp = (Integer)this.theDepthAtEachNode.elementAt(firstCrossPoint);
                if (typeOfValue != 0 && typeOfValue != 10 && typeOfValue != 11 && typeOfValue != 12 && typeOfValue != 13 && typeOfValue != 14 && typeOfValue != 16 && typeOfValue != 15 || MAXH - itmp < this.getHeight(tmp)) continue;
                ableToCrossNodes.addElement(new Integer(i));
            }
            if (ableToCrossNodes.size() != 0) {
                int secondCrossPoint = (int)(rand.Rand() * (double)ableToCrossNodes.size());
                int nh = -1;
                tmp = (Node)f3.theParents.elementAt(firstCrossPoint);
                Node tmp1 = (Node)f3.theNodes.elementAt(firstCrossPoint);
                for (int i = 0; i < tmp.nChildren(); ++i) {
                    if (tmp.child(i) != tmp1) continue;
                    nh = i;
                    break;
                }
                int nh1 = -1;
                Integer itmp = (Integer)ableToCrossNodes.elementAt(secondCrossPoint);
                tmp = (Node)f4.theParents.elementAt(itmp);
                tmp1 = (Node)f4.theNodes.elementAt(itmp);
                for (int i = 0; i < tmp.nChildren(); ++i) {
                    if (tmp.child(i) != tmp1) continue;
                    nh1 = i;
                    break;
                }
                tmp = (Node)f3.theParents.elementAt(firstCrossPoint);
                itmp = (Integer)ableToCrossNodes.elementAt(secondCrossPoint);
                tmp1 = (Node)f4.theParents.elementAt(itmp);
                Node tmpswap = tmp.child(nh);
                tmp.changeChild(tmp1.child(nh1), nh);
                tmp1.changeChild(tmpswap, nh1);
            }
            f3.buildNodeLists();
            f4.buildNodeLists();
        }
    }

    @Override
    public void Random() {
        this.rootNode = (NodeExprHold)this.RandomTree(8, MAXH, 0);
        this.RandomCadena();
        this.buildNodeLists();
    }

    @Override
    public void debug() {
        System.out.println("Cadena=[");
        for (int i = 0; i < this.fsChain.length; ++i) {
            System.out.println(this.fsChain[i].aString() + " ");
        }
        System.out.println("]");
        this.rootNode.debug();
        System.out.println();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private int getHeight(Node n) {
        int mh = 0;
        for (int i = 0; i < n.nChildren(); ++i) {
            int h = this.getHeight(n.child(i));
            if (h <= mh) continue;
            mh = h;
        }
        return 1 + mh;
    }

    private void insertNode(Node n, Node parent, int p) {
        this.theNodes.addElement(n);
        this.theParents.addElement(parent);
        this.theDepthAtEachNode.addElement(new Integer(p));
        if (n instanceof NodeValue) {
            NodeValue nv = (NodeValue)n;
            nv.setString(this.fsChain);
        }
        for (int i = 0; i < n.nChildren(); ++i) {
            this.insertNode(n.child(i), n, p + 1);
        }
    }

    private void buildNodeLists() {
        this.theNodes = new Vector();
        this.theParents = new Vector();
        this.theDepthAtEachNode = new Vector();
        this.insertNode(this.rootNode, null, 0);
    }

    void RandomCadena() {
        double iz = 0.0;
        double ce = 0.0;
        double de = 0.0;
        block5: for (int i = 0; i < this.fsChain.length; ++i) {
            switch (typeOfValue) {
                case 0: {
                    iz = rand.Rand() * (KMAX - KMIN) + KMIN;
                    FuzzySingleton bs = new FuzzySingleton(iz);
                    this.fsChain[i] = new FuzzyAlphaCut(bs);
                    continue block5;
                }
                case 1: {
                    iz = rand.Rand() * (KMAX - KMIN) + KMIN;
                    FuzzyInterval bi = new FuzzyInterval(iz, iz);
                    this.fsChain[i] = new FuzzyAlphaCut(bi);
                    continue block5;
                }
                case 2: {
                    iz = rand.Rand() * (KMAX - KMIN) + KMIN;
                    FuzzyNumberTRIANG bt = new FuzzyNumberTRIANG(iz, iz, iz);
                    this.fsChain[i] = new FuzzyAlphaCut(bt);
                }
            }
        }
    }

    Node RandomTree(int t, int maxh, int par) {
        int opciones = 8;
        switch (t) {
            case 8: {
                NodeExprArit[] h = new NodeExprArit[1];
                block34: for (int i = 0; i < h.length; ++i) {
                    par = (int)(rand.Rand() * (double)this.getNumInputs());
                    int val = (int)(rand.Rand() * (double)opciones);
                    switch (val) {
                        case 0: {
                            h[i] = (NodeExprArit)this.RandomTree(0, maxh - 1, par);
                            continue block34;
                        }
                        case 1: {
                            h[i] = (NodeExprArit)this.RandomTree(10, maxh - 1, par);
                            continue block34;
                        }
                        case 2: {
                            h[i] = (NodeExprArit)this.RandomTree(11, maxh - 1, par);
                            continue block34;
                        }
                        case 3: {
                            h[i] = (NodeExprArit)this.RandomTree(12, maxh - 1, par);
                            continue block34;
                        }
                        case 4: {
                            h[i] = (NodeExprArit)this.RandomTree(13, maxh - 1, par);
                            continue block34;
                        }
                        case 5: {
                            h[i] = (NodeExprArit)this.RandomTree(14, maxh - 1, par);
                            continue block34;
                        }
                        case 6: {
                            h[i] = (NodeExprArit)this.RandomTree(15, maxh - 1, par);
                            continue block34;
                        }
                        case 7: {
                            h[i] = (NodeExprArit)this.RandomTree(16, maxh - 1, par);
                        }
                    }
                }
                return new NodeExprHold(h);
            }
            case 0: {
                return new NodeVariable(par);
            }
            case 10: {
                int indice = (int)(rand.Rand() * (double)LENCADENA);
                return new NodeValue(indice, this.fsChain);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                opciones = maxh <= 1 ? 2 : 8;
                int[] tr = new int[2];
                for (int i = 0; i < 2; ++i) {
                    int val = (int)(rand.Rand() * (double)opciones);
                    switch (val) {
                        case 0: {
                            tr[i] = 0;
                            break;
                        }
                        case 1: {
                            tr[i] = 10;
                            break;
                        }
                        case 2: {
                            tr[i] = 11;
                            break;
                        }
                        case 3: {
                            tr[i] = 12;
                            break;
                        }
                        case 4: {
                            tr[i] = 13;
                            break;
                        }
                        case 5: {
                            tr[i] = 14;
                            break;
                        }
                        case 6: {
                            tr[i] = 15;
                            break;
                        }
                        case 7: {
                            tr[i] = 16;
                        }
                    }
                    par = (int)(rand.Rand() * (double)this.getNumInputs());
                    NodeExprArit na1 = (NodeExprArit)this.RandomTree(tr[0], maxh - 1, par);
                    par = (int)(rand.Rand() * (double)this.getNumInputs());
                    NodeExprArit na2 = (NodeExprArit)this.RandomTree(tr[1], maxh - 1, par);
                    switch (t) {
                        case 11: {
                            return new NodeAdd(na1, na2);
                        }
                        case 12: {
                            return new NodeMinus(na1, na2);
                        }
                        case 13: {
                            return new NodeProduct(na1, na2);
                        }
                        case 14: {
                            return new NodeSquareRoot(na1);
                        }
                        case 15: {
                            return new NodeExp(na1);
                        }
                        case 16: {
                            return new NodeLog(na1);
                        }
                    }
                }
                break;
            }
        }
        System.out.println("Depura esto");
        return new NodeVariable(par);
    }

    public double[] getChainValue() {
        double[] result = new double[this.fsChain.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.fsChain[i].massCentre();
        }
        return result;
    }

    void setUsedConstants(Node n, boolean[] used) {
        if (n instanceof NodeValue) {
            NodeValue nv = (NodeValue)n;
            used[nv.getIndex()] = true;
        } else {
            for (int i = 0; i < n.children().length; ++i) {
                this.setUsedConstants(n.children()[i], used);
            }
        }
    }

    public boolean[] getUsedConstants() {
        boolean[] result = new boolean[this.fsChain.length];
        for (int i = 0; i < this.rootNode.children().length; ++i) {
            this.setUsedConstants(this.rootNode.children()[i], result);
        }
        return result;
    }

    public void setChain(double[] x) {
        double[] centros = this.getChainValue();
        for (int i = 0; i < centros.length; ++i) {
            FuzzySingleton s = new FuzzySingleton(x[i] - centros[i]);
            FuzzyAlphaCut disp = new FuzzyAlphaCut(s);
            this.fsChain[i].set(this.fsChain[i].sum(disp));
        }
    }
}

