/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.myDataset;

public class Itemset {
    ArrayList<Item> itemset;
    int clas;
    double MS;
    double support;
    double supportRule;

    public Itemset() {
    }

    public Itemset(int clas, double MS) {
        this.itemset = new ArrayList();
        this.clas = clas;
        this.MS = MS;
        this.support = 0.0;
        this.supportRule = 0.0;
    }

    public Itemset clone() {
        Itemset d = new Itemset(this.clas, this.MS);
        for (int i = 0; i < this.itemset.size(); ++i) {
            d.add(this.itemset.get(i).clone());
        }
        d.clas = this.clas;
        d.MS = this.MS;
        d.support = this.support;
        d.supportRule = this.supportRule;
        return d;
    }

    public void add(Item item) {
        this.itemset.add(item);
    }

    public Item get(int pos) {
        return this.itemset.get(pos);
    }

    public Item remove(int pos) {
        return this.itemset.remove(pos);
    }

    public int size() {
        return this.itemset.size();
    }

    public double getSupport() {
        return this.support;
    }

    public double getSupportClass() {
        return this.supportRule;
    }

    public int getClas() {
        return this.clas;
    }

    public void setMS(double value) {
        this.MS = value;
    }

    public boolean isEqual(Itemset a) {
        if (this.itemset.size() != a.size()) {
            return false;
        }
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            if (item.isEqual(a.get(i))) continue;
            return false;
        }
        return this.clas == a.getClas();
    }

    public void calculateSupports(myDataset train) {
        this.support = 0.0;
        this.supportRule = 0.0;
        for (int i = 0; i < train.size(); ++i) {
            double degree = this.degree(train.getExampleXf(i));
            if (!(degree > this.MS)) continue;
            this.support += degree;
            if (train.getOutputAsInteger(i) != this.clas) continue;
            this.supportRule += degree;
        }
        this.support /= (double)train.getnData();
        this.supportRule /= (double)train.getnData();
    }

    private double degree(double[][] ejemplo) {
        return this.degreeMinimum(ejemplo);
    }

    private double degreeMinimum(double[][] example) {
        double minimum = 1.0;
        for (int i = 0; i < this.itemset.size(); ++i) {
            Item item = this.itemset.get(i);
            minimum = Math.min(minimum, example[item.getVariable()][item.getValue()]);
        }
        return minimum;
    }
}

