/*
 * Decompiled with CFR 0.152.
 */
package dr.matrix;

import dr.matrix.ColumnVector;
import dr.matrix.ConcreteMatrix;
import dr.matrix.MutableMatrix;
import dr.matrix.RowVector;
import org.apache.commons.math.linear.RealMatrixImpl;

public interface Matrix {
    public int getRowCount();

    public int getColumnCount();

    public int getElementCount();

    public int getTriangleCount() throws NotSquareException;

    public int getDiagonalCount() throws NotSquareException;

    public double[] getElements();

    public double[][] getElements2D();

    public double[] getUpperTriangle() throws NotSquareException;

    public double[] getLowerTriangle() throws NotSquareException;

    public double[] getDiagonal() throws NotSquareException;

    public double getElement(int var1, int var2);

    public double getElement(int var1);

    public double[] getRow(int var1);

    public double[] getColumn(int var1);

    public double getMinValue();

    public double getMaxValue();

    public boolean getIsSquare();

    public boolean getIsSymmetric() throws NotSquareException;

    public String getRowId(int var1);

    public String getColumnId(int var1);

    public static abstract class AbstractMatrix
    implements Matrix {
        @Override
        public int getElementCount() {
            return this.getRowCount() * this.getColumnCount();
        }

        @Override
        public int getTriangleCount() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            int n = this.getRowCount();
            return (n - 1) * n / 2;
        }

        @Override
        public int getDiagonalCount() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            return this.getRowCount();
        }

        @Override
        public double[] getElements() {
            double[] dArray = new double[this.getElementCount()];
            int n = 0;
            int n2 = this.getRowCount();
            int n3 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[n] = this.getElement(i, j);
                    ++n;
                }
            }
            return dArray;
        }

        @Override
        public double[][] getElements2D() {
            double[][] dArray = new double[this.getRowCount()][this.getColumnCount()];
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray[i][j] = this.getElement(i, j);
                }
            }
            return dArray;
        }

        @Override
        public double getElement(int n) {
            int n2 = n / this.getColumnCount();
            int n3 = n % this.getColumnCount();
            return this.getElement(n2, n3);
        }

        @Override
        public double[] getUpperTriangle() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            double[] dArray = new double[this.getTriangleCount()];
            int n = 0;
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                for (int j = i + 1; j < n2; ++j) {
                    dArray[n] = this.getElement(i, j);
                    ++n;
                }
            }
            return dArray;
        }

        @Override
        public double[] getLowerTriangle() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            double[] dArray = new double[this.getTriangleCount()];
            int n = 0;
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < i; ++j) {
                    dArray[n] = this.getElement(i, j);
                    ++n;
                }
            }
            return dArray;
        }

        @Override
        public double[] getDiagonal() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            int n = this.getRowCount();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.getElement(i, i);
            }
            return dArray;
        }

        @Override
        public double[] getRow(int n) {
            int n2 = this.getColumnCount();
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = this.getElement(n, i);
            }
            return dArray;
        }

        @Override
        public double[] getColumn(int n) {
            int n2 = this.getRowCount();
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = this.getElement(i, n);
            }
            return dArray;
        }

        @Override
        public double getMinValue() {
            double d = this.getElement(0);
            int n = this.getElementCount();
            for (int i = 1; i < n; ++i) {
                double d2 = this.getElement(i);
                if (!(d2 < d)) continue;
                d = d2;
            }
            return d;
        }

        @Override
        public double getMaxValue() {
            double d = this.getElement(0);
            int n = this.getElementCount();
            for (int i = 1; i < n; ++i) {
                double d2 = this.getElement(i);
                if (!(d2 > d)) continue;
                d = d2;
            }
            return d;
        }

        @Override
        public boolean getIsSquare() {
            return this.getRowCount() == this.getColumnCount();
        }

        @Override
        public boolean getIsSymmetric() throws NotSquareException {
            if (!this.getIsSquare()) {
                throw new NotSquareException();
            }
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1;
                while (i < n) {
                    if (this.getElement(i, n2) != this.getElement(n2, i)) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        @Override
        public String getRowId(int n) {
            return null;
        }

        @Override
        public String getColumnId(int n) {
            return null;
        }
    }

    public static class Util {
        public static double dotProduct(Matrix matrix, Matrix matrix2) {
            throw new RuntimeException("not implemented yet");
        }

        public static void product(Matrix matrix, Matrix matrix2, MutableMatrix mutableMatrix) throws WrongDimensionException {
            int n = matrix.getRowCount();
            int n2 = matrix.getColumnCount();
            int n3 = matrix2.getRowCount();
            int n4 = matrix2.getColumnCount();
            if (n2 != n3) {
                throw new WrongDimensionException("column count of matrix a = " + n2 + ", row count of matrix b = " + n3);
            }
            mutableMatrix.setDimension(n, n4);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n4; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < n2; ++k) {
                        d += matrix.getElement(i, k) * matrix2.getElement(k, j);
                    }
                    mutableMatrix.setElement(i, j, d);
                }
            }
        }

        public static void kroneckerProduct(Matrix matrix, Matrix matrix2, MutableMatrix mutableMatrix) {
            int n = matrix.getRowCount();
            int n2 = matrix.getColumnCount();
            int n3 = matrix2.getRowCount();
            int n4 = matrix2.getColumnCount();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n; ++k) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            mutableMatrix.setElement(i * n + k, j * n2 + i2, matrix.getElement(k, i2) * matrix2.getElement(i, j));
                        }
                    }
                }
            }
        }

        public static void add(Matrix matrix, Matrix matrix2, MutableMatrix mutableMatrix) throws WrongDimensionException {
            int n = matrix.getRowCount();
            int n2 = matrix.getColumnCount();
            if (n != matrix2.getRowCount() || n2 != matrix2.getColumnCount()) {
                throw new WrongDimensionException();
            }
            mutableMatrix.setDimension(n, n2);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    mutableMatrix.setElement(i, j, matrix.getElement(i, j) + matrix2.getElement(i, j));
                }
            }
        }

        public static void subtract(Matrix matrix, Matrix matrix2, MutableMatrix mutableMatrix) throws WrongDimensionException {
            int n = matrix.getRowCount();
            int n2 = matrix.getColumnCount();
            if (n != matrix2.getRowCount() || n2 != matrix2.getColumnCount()) {
                throw new WrongDimensionException();
            }
            mutableMatrix.setDimension(n, n2);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    mutableMatrix.setElement(i, j, matrix.getElement(i, j) - matrix2.getElement(i, j));
                }
            }
        }

        public static double det(Matrix matrix) throws NotSquareException {
            int n;
            int n2 = matrix.getRowCount();
            if (n2 != (n = matrix.getColumnCount())) {
                throw new NotSquareException();
            }
            double[][] dArray = new double[n2][n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray[i][j] = matrix.getElement(i, j);
                }
            }
            RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
            return realMatrixImpl.getDeterminant();
        }

        public static double logDet(Matrix matrix) throws NotSquareException {
            throw new RuntimeException("not implemented yet");
        }

        public static void invert(MutableMatrix mutableMatrix) throws NotSquareException {
            double d;
            int n;
            int n2;
            int n3;
            int n4 = mutableMatrix.getRowCount();
            if (n4 != (n3 = mutableMatrix.getColumnCount())) {
                throw new NotSquareException();
            }
            double[][] dArray = new double[n4 + 1][n4 * 2 + 2];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n4; ++j) {
                    dArray[i + 1][j + 1] = mutableMatrix.getElement(i, j);
                }
            }
            int n5 = 2 * n4;
            for (n2 = 1; n2 <= n4; ++n2) {
                for (n = 1; n <= n4; ++n) {
                    dArray[n2][n + n4] = 0.0;
                }
                dArray[n2][n2 + n4] = 1.0;
            }
            for (n2 = 1; n2 <= n4 && (d = dArray[n2][n2]) != 0.0; ++n2) {
                for (n = 1; n <= n5; ++n) {
                    dArray[n2][n] = dArray[n2][n] / d;
                }
                for (int i = 1; i <= n4; ++i) {
                    if (i - n2 == 0) continue;
                    double d2 = dArray[i][n2];
                    for (n = 1; n <= n5; ++n) {
                        dArray[i][n] = dArray[i][n] - d2 * dArray[n2][n];
                    }
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n4; ++n) {
                    mutableMatrix.setElement(n2, n, dArray[n2 + 1][n + n4 + 1]);
                }
            }
        }

        public static void invert(Matrix matrix, Matrix matrix2, MutableMatrix mutableMatrix) throws NotSquareException, WrongDimensionException {
            throw new RuntimeException("not implemented yet");
        }

        public static void raise(Matrix matrix, double d, MutableMatrix mutableMatrix) throws NotSquareException {
            throw new RuntimeException("not implemented yet");
        }

        public static Matrix createColumnVector(double[] dArray) {
            return new ColumnVector(dArray);
        }

        public static Matrix createRowVector(double[] dArray) {
            return new RowVector(dArray);
        }

        public static MutableMatrix createMutableMatrix(double[][] dArray) {
            return new ConcreteMatrix(dArray);
        }
    }

    public static class WrongDimensionException
    extends MatrixException {
        private static final long serialVersionUID = -1799942797975356399L;

        WrongDimensionException() {
        }

        WrongDimensionException(String string) {
            super(string);
        }
    }

    public static class NotSquareException
    extends MatrixException {
        private static final long serialVersionUID = 5121968928197320497L;
    }

    public static class MatrixException
    extends Exception {
        private static final long serialVersionUID = -5904166681730282246L;

        MatrixException() {
        }

        MatrixException(String string) {
            super(string);
        }
    }
}

