/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Variable;
import java.io.Serializable;
import java.util.ArrayList;

public interface Bounds<V>
extends Serializable {
    public V getUpperLimit(int var1);

    public V getLowerLimit(int var1);

    public int getBoundsDimension();

    public static class Staircase
    implements Bounds<Integer> {
        int size = 0;
        private ArrayList<Bounds<Integer>> bounds = null;

        public Staircase(int n) {
            this.size = n;
        }

        public Staircase(Variable<Integer> variable) {
            this.size = variable.getSize();
        }

        @Override
        public Integer getUpperLimit(int n) {
            return n + 1;
        }

        @Override
        public Integer getLowerLimit(int n) {
            return 0;
        }

        @Override
        public int getBoundsDimension() {
            return this.size;
        }

        public void addBounds(Bounds<Integer> bounds) {
            if (bounds.getBoundsDimension() != this.size) {
                throw new IllegalArgumentException("Incorrect dimension of bounds, expected " + this.size + " but received " + bounds.getBoundsDimension());
            }
            if (this.bounds == null) {
                this.bounds = new ArrayList();
            }
            this.bounds.add(bounds);
        }
    }

    public static class Int
    implements Bounds<Integer> {
        int size = 1;
        int lower = Integer.MIN_VALUE;
        int upper = Integer.MAX_VALUE;

        public Int(int n, int n2, int n3) {
            this.size = n;
            this.lower = n2;
            this.upper = n3;
        }

        public Int(Variable<Integer> variable, int n, int n2) {
            this.size = variable.getSize();
            this.lower = n;
            this.upper = n2;
        }

        @Override
        public Integer getUpperLimit(int n) {
            return this.upper;
        }

        @Override
        public Integer getLowerLimit(int n) {
            return this.lower;
        }

        @Override
        public int getBoundsDimension() {
            return this.size;
        }
    }
}

