use super::*;
use crate as extendr_api;




























#[derive(Debug, PartialEq, Clone)]
pub enum Nullable<T> {
    NotNull(T),
    Null,
}

impl<T> TryFrom<Robj> for Nullable<T>
where
    T: TryFrom<Robj, Error = Error>,
{
    type Error = Error;

    
    
    
    
    
    
    
    
    
    
    
    
    fn try_from(robj: Robj) -> std::result::Result<Self, Self::Error> {
        if robj.is_null() {
            Ok(Nullable::Null)
        } else {
            Ok(Nullable::NotNull(robj.try_into()?))
        }
    }
}

impl<'a, T> TryFrom<&'a Robj> for Nullable<T>
where
    T: TryFrom<&'a Robj, Error = Error>,
{
    type Error = Error;

    
    
    
    
    
    
    
    
    
    
    
    
    fn try_from(robj: &'a Robj) -> std::result::Result<Self, Self::Error> {
        if robj.is_null() {
            Ok(Nullable::Null)
        } else {
            Ok(Nullable::NotNull(robj.try_into()?))
        }
    }
}

impl<T> From<Nullable<T>> for Robj
where
    T: Into<Robj>,
{
    
    
    
    
    
    
    
    
    fn from(val: Nullable<T>) -> Self {
        match val {
            Nullable::NotNull(t) => t.into(),
            Nullable::Null => r!(NULL),
        }
    }
}

impl<T> From<Nullable<T>> for Option<T>
where
    T: TryFrom<Robj, Error = Error>,
{
    
    
    
    
    
    
    
    
    fn from(value: Nullable<T>) -> Self {
        match value {
            Nullable::NotNull(value) => Some(value),
            _ => None,
        }
    }
}

impl<'a, T> From<&'a Nullable<T>> for Option<&'a T>
where
    T: TryFrom<Robj, Error = Error>,
{
    
    
    
    
    
    
    
    
    fn from(value: &'a Nullable<T>) -> Self {
        match value {
            Nullable::NotNull(value) => Some(value),
            _ => None,
        }
    }
}

impl<T> From<Option<T>> for Nullable<T>
where
    T: Into<Robj>,
{
    
    
    
    
    
    
    
    
    
    
    fn from(value: Option<T>) -> Self {
        match value {
            Some(value) => Nullable::NotNull(value),
            _ => Nullable::Null,
        }
    }
}

impl<T> Nullable<T>
where
    T: TryFrom<Robj, Error = Error>,
{
    
    
    
    
    
    
    
    
    pub fn into_option(self) -> Option<T> {
        self.into()
    }
}
impl<T> Nullable<T> {
    
    
    
    
    
    
    
    
    
    pub fn map<F, U>(self, f: F) -> Nullable<U>
    where
        F: FnOnce(T) -> U,
    {
        match self {
            Nullable::NotNull(value) => Nullable::NotNull(f(value)),
            _ => Nullable::Null,
        }
    }
}
