% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicateGene}
\alias{xegaGaReplicateGene}
\title{Replicates a gene with a crossover operator which returns a single gene.}
\usage{
xegaGaReplicateGene(pop, fit, lF)
}
\arguments{
\item{pop}{Population of binary genes.}

\item{fit}{Fitness vector.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A list of one gene.
}
\description{
\code{xegaGaReplicateGene()} replicates a gene
             by applying a gene reproduction pipeline 
             which uses crossover and
             mutation and finishes with an acceptance rule.
             The control flow starts
             by selecting a gene from the population
             followed by the case distinction:
             \itemize{
              \item
             Check if the mutation operation should be applied.
             (\code{mut} is \code{TRUE} with a probability of \code{lF$MutationRate()}).
             \item
             Check if the crossover operation should be applied.
             (\code{cross} is \code{TRUE} with a probability of \code{lF$CrossRate()}).
             }
             The state distinction determines which genetic operations are performed.
}
\details{
\code{xegaGaReplicateGene()} implements the control flow 
         by a dynamic definition of the operator pipeline depending
         on the random choices for mutation and crossover:
\enumerate{
  \item A gene \code{g} is selected and the boolean variables \code{mut}
        and \code{cross} are set to \code{runif(1)<rate}. 
  \item The local function for the operator pipeline \code{OPpip(g, lF)}
        is defined by the truth values of \code{cross} and \code{mut}:
  \enumerate{      
  \item \code{(cross==FALSE) & (mut==FALSE)}: 
          Identity function. 
  \item \code{(cross==TRUE) & (mut==TRUE)}: 
          Mate selection,  crossover, mutation. 
  \item \code{(cross==TRUE) & (mut==FALSE)}: 
          Mate selection, crossover. 
  \item \code{(cross==FALSE) & (mut==TRUE)}: 
          Mutation. 
  }
  \item  Perform the operator pipeline and accept the result.
         The acceptance step allows the combination of a genetic algorithm
         with other heuristic algorithms like simulated 
         annealing by executing an acceptance rule. 
         For the genetic algorithm, the identity function is used.            
  }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.001}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {gene}
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaGaReplicateGene(pop10, fit10, lFxegaGaGene)
}
\seealso{
Other Replication: 
\code{\link{xegaGaReplicate2Gene}()},
\code{\link{xegaGaReplicate2GenePipeline}()},
\code{\link{xegaGaReplicate2GenePipelineG}()},
\code{\link{xegaGaReplicateGenePipeline}()},
\code{\link{xegaGaReplicateGenePipelineG}()}
}
\concept{Replication}
