% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicate2GenePipelineG}
\alias{xegaGaReplicate2GenePipelineG}
\title{Replicates a gene with a crossover operator with 2 kids by embedding a genetic operator pipeline.}
\usage{
xegaGaReplicate2GenePipelineG(pop, fit, lF)
}
\arguments{
\item{pop}{A population of binary genes.}

\item{fit}{Fitness vector.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of either 1 or 2 function closures with the operator pipeline.
}
\description{
\code{xegaGaReplicate2GenePipelineG()} replicates a gene
             by 3 random experiments which determine if a mutation 
             operator (boolean variable \code{mut1} and \code{mut2})  
             and/or 
             a crossover operator (boolean variable \code{cross} 
             should be applied. For each of the 8 cases, the 
             appropriate pipeline constructor is executed
             and the genetic operator pipeline(s) is (are) embedded in the gene.
}
\details{
\code{xegaGaReplicate2GenePipelineG()} implements the control flow 
         by case distinction which  depends
         on the random choices for mutation and crossover.
         The pipeline constructor chosen returns the function closure 
         with the appropriate genetic operator pipeline.
\enumerate{
  \item A gene \code{g} is selected and the boolean variables \code{mut1},
        \code{mut2}, 
        and \code{cross} are set to \code{runif(1)<rate}. 
        \code{rate} is given by 
        \code{lF$MutationRate()} or \code{lF$CrossRate()}. 
  \item The truth values of \code{cross}, \code{mut1}, and \code{mut2} 
        determine 
        the genetic operator pipeline constructor that is executed:
  \enumerate{      
  \item \code{(cross==FALSE) & (mut1==FALSE)} is implicit: 
        Executes the pipeline constructor \code{newPipeline}.  
  \item \code{(cross==TRUE) & (mut1==TRUE) & (mut2==TRUE)}: 
        Crossover, mutation on both kids. 
        Executes the genetic operator 
        pipeline constructor \code{newCrossMut2Pipeline}.
  \item \code{(cross==TRUE) & (mut1==TRUE) & (mut2==FALSE)}: 
        Crossover, mutation on first kid. 
        Executes the genetic operator 
        pipeline constructor \code{newCross2Mut1Pipeline}.
  \item \code{(cross==TRUE) & (mut1==FALSE) & (mut2==TRUE)}: 
        Crossover, mutation on second kid. 
        Executes the genetic operator 
        pipeline constructor \code{newCross2Mut2Pipeline}.
  \item \code{(cross==TRUE) & (mut1==FALSE) & (mut2==FALSE)}: 
        Crossover (2 kids). 
        Executes the genetic operator 
        pipeline constructor \code{newCross2Pipeline}.
  \item \code{(cross==FALSE) & (mut1==TRUE)}: 
        Mutation. 
        Executes the genetic operator 
        pipeline constructor \code{newMutPipeline}.
  }
  }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.001}
names(lFxegaGaGene)
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaGaReplicate2GenePipelineG(pop10, fit10, lFxegaGaGene)

}
\seealso{
Other Replication: 
\code{\link{xegaGaReplicate2Gene}()},
\code{\link{xegaGaReplicate2GenePipeline}()},
\code{\link{xegaGaReplicateGene}()},
\code{\link{xegaGaReplicateGenePipeline}()},
\code{\link{xegaGaReplicateGenePipelineG}()}
}
\concept{Replication}
