% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newCross2PipelineG}
\alias{newCross2PipelineG}
\title{Converts two genes into a genetic operator pipeline embedded in a gene with crossover (2 kids).}
\usage{
newCross2PipelineG(g, g1)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline 
        with crossover only.
        The argument \code{lF} of function \code{$Pipeline()} 
        configures the behavior of the pipeline.
}
\description{
The embedded pipeline is \code{evaluate(accept(crossover, gene, gene1))}.
             The execution of this pipeline produces two genes.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OpPipeline, gene, lF) {OpPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCross2PipelineG(g, g1)
print(a)
a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newMutPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
