% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_cens.R
\name{quantile_cens}
\alias{quantile_cens}
\title{Calculate quantiles respecting the censored data}
\usage{
quantile_cens(
  x,
  probs = 0.5,
  limit = 1,
  cens = c("left", "right", "neither", "both")
)
}
\arguments{
\item{x}{numeric vector whose sample quantiles are wanted, or an
    object of a class for which a method has been defined (see also
    \sQuote{details}). \code{\link{NA}} and \code{NaN} values are not
    allowed in numeric vectors unless \code{na.rm} is \code{TRUE}.}

\item{probs}{numeric vector of probabilities with values in
    \eqn{[0,1]}.  (Values up to \samp{2e-14} outside that
    range are accepted and moved to the nearby endpoint.)}

\item{limit}{censoring limit (ignored if \code{cens="neither"})}

\item{cens}{censoring direction}
}
\value{
The quantile of \code{x} treating \code{NA} values as censored
}
\description{
Calculate quantiles respecting the censored data
}
