% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedmatrix.R
\name{query_relationship}
\alias{query_relationship}
\title{Query Relationship Coefficients from a Pedigree Matrix}
\usage{
query_relationship(x, id1, id2 = NULL)
}
\arguments{
\item{x}{A pedmat object created by \code{\link{pedmat}}.}

\item{id1}{Character, first individual ID.}

\item{id2}{Character, second individual ID. If \code{NULL}, returns 
the entire row of relationships for \code{id1}.}
}
\value{
\itemize{
  \item If \code{id2} is provided: numeric value (relationship coefficient)
  \item If \code{id2} is \code{NULL}: named numeric vector (id1's row)
  \item Returns \code{NA} if individual not found
}
}
\description{
Retrieves relationship coefficients between individuals from a pedmat object.
For compact matrices, automatically handles lookup of merged full-siblings.
}
\details{
For compact matrices (\code{compact = TRUE}), this function automatically
maps individuals to their family representatives. For methods A, D, and AA,
it can compute the correct relationship even between merged full-siblings
using the formula:
\itemize{
  \item \strong{A}: \eqn{a_{ij} = 0.5 * (a_{is} + a_{id})} where s, d are parents
  \item \strong{D}: \eqn{d_{ij} = a_{ij}^2} (for full-sibs in same family)
  \item \strong{AA}: \eqn{aa_{ij} = a_{ij}^2}
}
}
\note{
Inverse matrices (Ainv, Dinv, AAinv) are \strong{not supported} because
inverse matrix elements do not represent meaningful relationship coefficients.
}
\examples{
tped <- tidyped(small_ped)
A <- pedmat(tped, method = "A", compact = TRUE)

# Query specific pair
query_relationship(A, "A", "B")

# Query merged full-siblings (works with compact)
query_relationship(A, "Z1", "Z2")

# Get all relationships for one individual
query_relationship(A, "A")

}
\seealso{
\code{\link{pedmat}}, \code{\link{expand_pedmat}}
}
