% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-unchop.R
\name{list_unchop}
\alias{list_unchop}
\title{Combine a list of vectors}
\usage{
list_unchop(
  x,
  ...,
  indices = NULL,
  ptype = NULL,
  name_spec = NULL,
  name_repair = c("minimal", "unique", "check_unique", "universal", "unique_quiet",
    "universal_quiet"),
  error_arg = "x",
  error_call = current_env()
)
}
\arguments{
\item{x}{A list}

\item{...}{These dots are for future extensions and must be empty.}

\item{indices}{A list of positive integer vectors specifying the
locations to place elements of \code{x} in. Each element of \code{x} is recycled to
the size of the corresponding index vector. The size of \code{indices} must
match the size of \code{x}. If \code{NULL}, \code{x} is combined in the order it is
provided in, which is equivalent to using \code{\link[=vec_c]{vec_c()}}.}

\item{ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{x}. Alternatively, you
can supply \code{ptype} to give the output a known type.}

\item{name_spec}{A name specification for combining
inner and outer names. This is relevant for inputs passed with a
name, when these inputs are themselves named, like \code{outer = c(inner = 1)}, or when they have length greater than 1: \code{outer = 1:2}. By default, these cases trigger an error. You can resolve
the error by providing a specification that describes how to
combine the names or the indices of the inner vector with the
name of the input. This specification can be:
\itemize{
\item A function of two arguments. The outer name is passed as a
string to the first argument, and the inner names or positions
are passed as second argument.
\item An anonymous function as a purrr-style formula.
\item A glue specification of the form \code{"{outer}_{inner}"}.
\item \code{"inner"}, in which case outer names are ignored, and inner
names are used if they exist. Note that outer names may still
be used to provide informative error messages.
\item An \code{\link[rlang:zap]{rlang::zap()}} object, in which case both outer and inner
names are ignored and the result is unnamed.
}

See the \link[=name_spec]{name specification topic}.}

\item{name_repair}{How to repair names, see \code{repair} options in
\code{\link[=vec_as_names]{vec_as_names()}}.}

\item{error_arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A vector of type \code{vec_ptype_common(!!!x)}, or \code{ptype}, if specified. The size
is computed as \code{vec_size_common(!!!indices)} unless the indices are \code{NULL},
in which case the size is \code{vec_size_common(!!!x)}.
}
\description{
While \code{list_unchop()} is not deprecated, we now recommend that you use
either:
\itemize{
\item \code{list_combine(x, indices = indices, size = size)} over
\code{list_unchop(x, indices = indices)}
\item \code{vec_c(!!!x)} over \code{list_unchop(x)}
}

\code{list_unchop()} combines a list of vectors into a single vector, placing
elements in the output according to the locations specified by \code{indices}. It
is similar to \code{\link[=vec_c]{vec_c()}}, but gives greater control over how the elements are
combined.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_c]{vec_c()}}
}
}

\examples{
# If `indices` selects every value in `x` exactly once,
# in any order, then `list_unchop()` inverts `vec_chop()`
x <- c("a", "b", "c", "d")
indices <- list(2, c(3, 1), 4)
vec_chop(x, indices = indices)
list_unchop(vec_chop(x, indices = indices), indices = indices)

# When unchopping, size 1 elements of `x` are recycled
# to the size of the corresponding index
list_unchop(list(1, 2:3), indices = list(c(1, 3, 5), c(2, 4)))

# Names are retained, and outer names can be combined with inner
# names through the use of a `name_spec`
lst <- list(x = c(a = 1, b = 2), y = 1)
list_unchop(lst, indices = list(c(3, 2), c(1, 4)), name_spec = "{outer}_{inner}")

# If you have a list of homogeneous vectors, sometimes it can be useful to
# unchop, apply a function to the flattened vector, and then rechop according
# to the original indices. This can be done efficiently with `list_sizes()`.
x <- list(c(1, 2, 1), c(3, 1), 5, double())
x_flat <- list_unchop(x)
x_flat <- x_flat + max(x_flat)
vec_chop(x_flat, sizes = list_sizes(x))
}
\keyword{internal}
