% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scramble_values.R
\name{scramble_values}
\alias{scramble_values}
\title{Scramble a vector of values}
\usage{
scramble_values(x)
}
\arguments{
\item{x}{a vector \code{x}}
}
\value{
the scrambled vector
}
\description{
Scramble a vector of values
}
\examples{

# Example with character vector
set.seed(123)

x <- letters[1:10]
scramble_values(x)

# Example with numeric vector
nums <- 1:5
scramble_values(nums)

# Scramble a column in the 'williams' dataset
data(williams)

# Simple scrambling of a single column
set.seed(123)
williams$ecology_scrambled <- scramble_values(williams$ecology)
head(williams[c("ecology", "ecology_scrambled")])

}
\seealso{
\code{\link{scramble_variables}} for scrambling multiple variables in a data frame, and
\code{\link{scramble_variables_rowwise}} for rowwise scrambling.
}
\keyword{scramble}
