% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_vk.R
\name{uplot_vk}
\alias{uplot_vk}
\title{uplot_vk}
\usage{
uplot_vk(
  mfd,
  z_var = "norm_int",
  nice_labels = TRUE,
  projection = TRUE,
  palname = "viridis",
  median_vK = TRUE,
  col_median = "white",
  ai = TRUE,
  logo = TRUE,
  size_dots = 3,
  col_bar = TRUE,
  tf = FALSE,
  cex.axis = 12,
  cex.lab = 15,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{z_var}{Character. Column name for variable used for color-coding. Content of column should be numeric.}

\item{nice_labels}{Logical. If true (default) axis/legend labels are generated from ume::nice_labels_dt.}

\item{projection}{If TRUE, median z-values per (oc,hc) are used.}

\item{palname}{Color palette name for f_colorz() (viridis, magma, plasma, etc.).}

\item{median_vK}{Add median VK point.}

\item{col_median}{Color of the marker for the median O/C and H/C value (Default = "white")}

\item{ai}{Add aromaticity index threshold lines.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{size_dots}{Numeric. Size of the dots in the plot (default = 0.5).}

\item{col_bar}{Logical. If \code{TRUE}, adds a color legend (default is \code{TRUE}).}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{cex.axis}{Numeric. Size of axis text (default is \code{1}).}

\item{cex.lab}{Numeric. Size of axis labels (default is \code{1.4}).}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{
  Arguments passed on to \code{\link[=f_colorz]{f_colorz}}
  \describe{
    \item{\code{z}}{Numeric vector. Values whose colors should be computed.}
    \item{\code{col_num}}{Integer. Number of colors in the palette (default: \code{100}).}
    \item{\code{verbose}}{logical; if \code{TRUE}, show progress messages.}
  }}
}
\value{
ggplot or plotly object
}
\description{
Creates a Van Krevelen diagram (H/C vs O/C).
}
\details{
Plot Van Krevelen Diagram
}
\references{
Van Krevelen D. (1950). Graphical-statistical method for
the study of structure and reaction processes of coal. \emph{Fuel}, \strong{29}, 269-284.

Kim S., Kramer R.W., Hatcher P.G. (2003). Graphical method for analysis of ultrahigh-resolution broadband mass spectra of natural
organic matter, the Van Krevelen Diagram. \emph{Analytical Chemistry}, \strong{75}, 5336-5344.
\doi{10.1021/ac034415p}
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()}
}
\concept{plots}
