% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_ri_vs_sample.R
\name{uplot_ri_vs_sample}
\alias{uplot_ri_vs_sample}
\title{Average Relative Intensity per Sample}
\usage{
uplot_ri_vs_sample(
  df,
  int_col = "norm_int",
  grp = "file_id",
  col = "grey",
  logo = TRUE,
  width = 0.3,
  gg_size = 12
)
}
\arguments{
\item{df}{A data.table containing at least:
\itemize{
\item a column with relative intensity values (\code{int_col})
\item a sample or file identifier (\code{grp})
}}

\item{int_col}{Character. Column name containing relative intensity values.}

\item{grp}{Character. Column name specifying sample / file grouping.}

\item{col}{Character. Fill color for bars.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{width}{Numeric. Width of bars (default \code{0.3}).}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}
}
\value{
A \strong{ggplot2 object} containing a bar plot of per-sample median relative intensity.
}
\description{
Creates a bar plot showing the \strong{median relative intensity} (default: \code{norm_int})
for each sample (grouped by \code{file_id}).
The overall dataset-wide median and standard deviation are shown in the title.
}
\details{
Plot Average Relative Intensity per Sample
}
\examples{
uplot_ri_vs_sample(mf_data_demo, int_col = "norm_int", grp = "file")

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
