% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ume_utilities.R
\name{ume_filter_formulas}
\alias{ume_filter_formulas}
\title{Complete Formula subsetting / filtering (wrapper)}
\usage{
ume_filter_formulas(mfd, verbose = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{
  Arguments passed on to \code{\link[=filter_mf_data]{filter_mf_data}}, \code{\link[=subset_known_mf]{subset_known_mf}}, \code{\link[=calc_norm_int]{calc_norm_int}}, \code{\link[=filter_int]{filter_int}}, \code{\link[=remove_blanks]{remove_blanks}}
  \describe{
    \item{\code{c_iso_check}}{(TRUE / FALSE); check if formulas are verified by the presence of the main daughter isotope}
    \item{\code{n_iso_check}}{(TRUE / FALSE); check if formulas are verified by the presence of the main daughter isotope}
    \item{\code{s_iso_check}}{(TRUE / FALSE); check if formulas are verified by the presence of the main daughter isotope}
    \item{\code{ma_dev}}{Deviation range of mass accuracy in +/- ppm (default: 3 ppm)}
    \item{\code{dbe_max}}{Maximum number for DBE}
    \item{\code{dbe_o_min}}{Minimum number for DBE minus O atoms}
    \item{\code{dbe_o_max}}{Maximum number for DBE minus O atoms}
    \item{\code{mz_min}}{Minimum of mass to charge value}
    \item{\code{mz_max}}{Maximum of mass to charge value}
    \item{\code{n_min}}{Minimum number of nitrogen atoms}
    \item{\code{n_max}}{Maximum number of nitrogen atoms}
    \item{\code{s_min}}{Minimum number of nitrogen atoms}
    \item{\code{s_max}}{Maximum number of nitrogen atoms}
    \item{\code{p_min}}{Minimum number of nitrogen atoms}
    \item{\code{p_max}}{Maximum number of nitrogen atoms}
    \item{\code{oc_min}}{Minimum atomic ratio of oxygen / carbon}
    \item{\code{oc_max}}{Maximum atomic ratio of oxygen / carbon}
    \item{\code{hc_min}}{Minimum atomic ratio of hydrogen / carbon}
    \item{\code{hc_max}}{Maximum atomic ratio of hydrogen / carbon}
    \item{\code{nc_min}}{Minimum atomic ratio of nitrogen / carbon}
    \item{\code{nc_max}}{Maximum atomic ratio of nitrogen / carbon}
    \item{\code{select_category}}{List of category names that should be selected}
    \item{\code{exclude_category}}{List of category names that should be ignored}
    \item{\code{ms_id}}{Character; name of the column identifying individual spectra (default: \code{"file_id"}).}
    \item{\code{peak_id}}{Character; name of the column identifying unique peaks (default: \code{"peak_id"}).}
    \item{\code{peak_magnitude}}{Character; name of the column containing peak intensity values (default: \code{"i_magnitude"}).}
    \item{\code{normalization}}{Character; normalization method to apply. One of \code{"bp"}, \code{"sum"}, \code{"sum_ubiq"}, \code{"sum_rank"}, \code{"none"}. Default is \code{"bp"}.}
    \item{\code{n_rank}}{Integer; number of top-ranked peaks to use for \code{"sum_rank"} normalization (default: 200).}
    \item{\code{norm_int_min}}{Lower threshold (>=) of (normalized) peak magnitude}
    \item{\code{norm_int_max}}{Upper threshold (<=) of (normalized) peak magnitude}
    \item{\code{blank_file_ids}}{Integer vector of \code{file_id} values that represent blank analyses.}
    \item{\code{blank_prevalence}}{Numeric between 0 and 1. Threshold for blank filtering:
the proportion of blanks in which a molecular formula must occur before it is
excluded from the sample data. For example, \code{blank_prevalence = 0} (default)
removes any formula detected in at least one blank, while \code{blank_prevalence = 0.5}
removes formulas detected in 50\% or more of the blanks.}
    \item{\code{ret_time_col}}{Character scalar. Name of the retention-time column that
contains the beginning of the retention time segment that corresponds to the
mass spectrum.
If \code{NULL} (default), the function will auto-detect the first column in
\code{c("ret_time_min","retention_time","rt","RT")} that exists in \code{mfd}.
If none is found, blanks are removed ignoring retention time.}
  }}
}
\value{
A data.table having molecular formula assignments for each mass.
ume_filter_formulas(mfd = mf_data_demo, dbe_o_max = 15, norm_int_min = 2)
}
\description{
A wrapper function to filter molecular formulas according to a evaluation parameters.
}
\seealso{
Other Formula subsetting: 
\code{\link{filter_int}()},
\code{\link{filter_mass_accuracy}()},
\code{\link{filter_mf_data}()},
\code{\link{remove_blanks}()},
\code{\link{subset_known_mf}()},
\code{\link{ume_assign_formulas}()}

Other ume wrapper: 
\code{\link{ume_assign_formulas}()}
}
\concept{Formula subsetting}
\concept{ume wrapper}
\keyword{filter_int}
