% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_docu.R
\name{main_docu}
\alias{main_docu}
\title{Common parameters for ume package functions}
\arguments{
\item{formula_library}{Molecular formula library: a predefined data.table used for
assigning molecular formulas to a peak list and for mass calibration. The library
requires a fixed format, including mass values for matching. Predefined libraries
are available in the R package \emph{ume.formulas} and further described in
Leefmann et al. (2019). A standard library for marine dissolved organic matter is
\code{ume.formulas::lib_02}. New libraries can be built using
\code{ume::create_ume_formula_library()}.}

\item{grp}{Character vector. Names of columns (e.g., sample or file identifiers)
used to aggregate results.}

\item{i_magnitude}{String. Name of the column that contains peak intensity information
(default: \code{"i_magnitude"}).}

\item{known_mf}{data.table with known molecular formulas (\code{ume::known_mf}).}

\item{masses}{A data.table. Defaults to \code{ume::masses} (based on NIST data)
containing isotope information for elements, including nominal and exact mass,
relative abundance, and Hill system order.}

\item{mf}{Character vector of molecular formula(s)
(e.g., \code{c("C10H23NO4", "C10H24N4O2S")}).}

\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{msg}{logical. Deprecated synonym for \code{verbose}.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{mz}{String. Name of the column that contains mass-to-charge information
(default: \code{"mz"}).}

\item{pl}{data.table containing peak data. Mandatory columns include neutral
molecular mass (\code{mass}), peak magnitude (\code{i_magnitude}), and a peak
identifier (\code{peak_id}).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{palname}{Color palette name for f_colorz() (viridis, magma, plasma, etc.).}

\item{nice_labels}{Logical. If true (default) axis/legend labels are generated from ume::nice_labels_dt.}

\item{col_bar}{Logical. If \code{TRUE}, adds a color legend (default is \code{TRUE}).}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{int_col}{Character. The name of the column that contains the intensity values
to be used (e.g. for clustering or color coding). Default usually is "norm_int" for normalized intensity values.}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{size_dots}{Numeric. Size of the dots in the plot (default = 0.5).}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{cex.axis}{Numeric. Size of axis text (default is \code{1}).}

\item{cex.lab}{Numeric. Size of axis labels (default is \code{1.4}).}

\item{z_var}{Character. Column name for variable used for color-coding. Content of column should be numeric.}

\item{...}{Additional arguments passed to methods.}
}
\description{
Central place to document arguments (e.g., \code{msg}, \code{pl}, \code{formula_library}) that are
inherited by multiple functions via \verb{@inheritParams main_docu}. This is not a user-facing
function and is only provided for documentation reuse.
}
\details{
Use \verb{@inheritParams main_docu} in other functions to pull in these definitions.
This topic is marked internal so it does not clutter the index.
}
\section{License}{

This package is released under the MIT License.
See the LICENSE file for details.
}

\keyword{internal}
