% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_mass_accuracy}
\alias{filter_mass_accuracy}
\title{Automated filter for mass accuracy}
\usage{
filter_mass_accuracy(
  mfd,
  ma_col = "ppm",
  file_col = "file_id",
  msg = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{ma_col}{Name of the column that contains mass accuracy values in ppm (string)}

\item{file_col}{Name of the column that contains file name}

\item{msg}{logical. Deprecated synonym for \code{verbose}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
data.table; subset of original molecular formula table
}
\description{
This function automatically sets a filter for mass accuracy for each individual spectrum.
}
\seealso{
Other Formula subsetting: 
\code{\link{filter_int}()},
\code{\link{filter_mf_data}()},
\code{\link{remove_blanks}()},
\code{\link{subset_known_mf}()},
\code{\link{ume_assign_formulas}()},
\code{\link{ume_filter_formulas}()}
}
\concept{Formula subsetting}
\keyword{misc}
