% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_aquisition_params.R
\name{extract_aquisition_params}
\alias{extract_aquisition_params}
\title{Extract Acquisition Parameters from a Bruker PDF Report}
\usage{
extract_aquisition_params(pdf_path)
}
\arguments{
\item{pdf_path}{Character. Path to the PDF file.}
}
\value{
A \code{data.table} with columns: \code{Parameter}, \code{Value}, \code{Unit}, \code{Spectrum_Filename}, \code{Analysis_Method}.
}
\description{
This function reads a PDF file from Bruker Compass DataAnalysis reports, extracts
acquisition parameters, including the spectrum filename and analysis method, and
returns them as a \code{data.table}. Parameter values are separated into numeric values
and corresponding units.
}
\seealso{
Other internal functions: 
\code{\link{create_custom_formula_library}()},
\code{\link{extract_aquisition_params_from_folder}()},
\code{\link{extract_metadata_from_ufz_files}()},
\code{\link{read_xml_peaklist}()}
}
\concept{internal functions}
\keyword{internal}
