% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_molecular_formula_to_data_table.R
\name{convert_molecular_formula_to_data_table}
\alias{convert_molecular_formula_to_data_table}
\title{Convert Molecular Formulas to a Data Table of Element Counts}
\usage{
convert_molecular_formula_to_data_table(
  mf,
  masses = ume::masses,
  table_format = c("wide", "long")
)
}
\arguments{
\item{mf}{Character vector of molecular formula(s)
(e.g., \code{c("C10H23NO4", "C10H24N4O2S")}).}

\item{masses}{A data.table. Defaults to \code{ume::masses} (based on NIST data)
containing isotope information for elements, including nominal and exact mass,
relative abundance, and Hill system order.}

\item{table_format}{A string (two options) that controls the output table format: \code{wide} (DEFAULT, dcast) or \code{long} (normalized, melt)}
}
\value{
A \code{data.table} with:
\describe{
\item{mf}{Standardized molecular formula following the Hill order.}
\item{mf_iso}{Original input molecular formula.}
\item{mass}{Exact molecular mass calculated from element masses.}
\item{elements}{Columns for each element present in the formulas, showing the atom count.}
}
}
\description{
Parses a character vector of molecular formulas and returns a \code{data.table} where each row represents
a molecular formula, and each column corresponds to an element, showing the count of atoms of that element.
The resulting table follows the \strong{Hill system order} for element arrangement.
}
\details{
This function extracts element counts from molecular formulas, including those with isotopic notation.
It ensures that only valid elements are included based on a reference table (\code{masses}) and flags invalid entries.
Duplicate molecular formulas are identified and processed only once, with a warning issued.

The function internally creates an enriched \code{masses} table to account for isotopic symbols and standard element notation.
}
\section{Warnings}{

\itemize{
\item If duplicate formulas are detected, only unique ones are processed, and a warning is issued.
\item If invalid element symbols are found, the function stops with an error message.
\item If a molecular formula contains duplicate isotopes/elements, an error is triggered.
}
}

\section{Notes}{

\itemize{
\item The function correctly handles isotopic notations such as \verb{[13C]} and \verb{[18O2]}.
\item The output follows the \strong{Hill order}, meaning \strong{C, H first}, followed by other elements in alphabetical order.
\item Single-element counts (e.g., \code{C1H4} → \code{CH4}) are formatted without explicit \code{1}.
}
}

\examples{
# Example usage
molecular_formulas <- c("C10H23NO4", "C10H24N4O2S", "C6[13C2]H12[18O2]ONaCl")
convert_molecular_formula_to_data_table(molecular_formulas)

}
\seealso{
Other molecular formula functions: 
\code{\link{convert_data_table_to_molecular_formulas}()}
}
\concept{molecular formula functions}
\keyword{chemistry}
\keyword{molecular-formula}
